/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qxmlstreamwriter_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qxmlstream.h>

using namespace Shiboken;

static int
SbkQXmlStreamWriter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlStreamWriter* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlStreamWriter", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlStreamWriter()
        cptr = new QXmlStreamWriter();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        // QXmlStreamWriter(QIODevice*)
        cptr = new QXmlStreamWriter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QByteArray * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // QXmlStreamWriter(QByteArray*)
        cptr = new QXmlStreamWriter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlStreamWriter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlStreamWriter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlStreamWriter_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QByteArray", "PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter", overloads);
        return -1;
}

static PyObject* SbkQXmlStreamWriterFunc_autoFormatting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoFormatting()const
    QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlStreamWriter::autoFormatting();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamWriterFunc_autoFormattingIndent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoFormattingIndent()const
    QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QXmlStreamWriter::autoFormattingIndent();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamWriterFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QXmlStreamWriter::device();
    py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlStreamWriterFunc_setAutoFormatting(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoFormatting(bool)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::setAutoFormatting(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_setAutoFormatting_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_setAutoFormatting_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.setAutoFormatting", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_setAutoFormattingIndent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAutoFormattingIndent(int)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::setAutoFormattingIndent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_setAutoFormattingIndent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_setAutoFormattingIndent_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.setAutoFormattingIndent", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_setCodec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);
        // setCodec(const char*)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::setCodec(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QTextCodec * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTextCodec* cpp_arg0 = Shiboken::Converter<QTextCodec* >::toCpp(arg);
        // setCodec(QTextCodec*)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::setCodec(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_setCodec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_setCodec_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec", "str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.setCodec", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::setDevice(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.setDevice", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "writeAttribute", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QXmlStreamAttribute & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlStreamAttribute* cpp_arg0 = Shiboken::Converter<QXmlStreamAttribute* >::toCpp(pyargs[0]);
        // writeAttribute(QXmlStreamAttribute)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeAttribute(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // writeAttribute(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeAttribute(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // writeAttribute(QString,QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeAttribute(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeAttribute_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QXmlStreamAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeAttribute", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeAttributes(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlStreamAttributes & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamAttributes* cpp_arg0 = Shiboken::Converter<QXmlStreamAttributes* >::toCpp(arg);
        // writeAttributes(QXmlStreamAttributes)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeAttributes(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeAttributes_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeAttributes_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamAttributes", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeAttributes", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeCDATA(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeCDATA(QString)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeCDATA(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeCDATA_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeCDATA_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeCDATA", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeCharacters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeCharacters(QString)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeCharacters(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeCharacters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeCharacters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeCharacters", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeComment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeComment(QString)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeComment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeComment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeComment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeComment", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeCurrentToken(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlStreamReader & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlStreamReader* cpp_arg0 = Shiboken::Converter<QXmlStreamReader* >::toCpp(arg);
        // writeCurrentToken(QXmlStreamReader)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeCurrentToken(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeCurrentToken_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeCurrentToken_TypeError:
        const char* overloads[] = {"PySide.QtCore.QXmlStreamReader", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeCurrentToken", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeDTD(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeDTD(QString)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeDTD(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeDTD_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeDTD_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeDTD", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeDefaultNamespace(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeDefaultNamespace(QString)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeDefaultNamespace(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeDefaultNamespace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeDefaultNamespace_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeDefaultNamespace", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeEmptyElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeEmptyElement", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // writeEmptyElement(QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeEmptyElement(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // writeEmptyElement(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeEmptyElement(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeEmptyElement_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeEmptyElement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeEmptyElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeEmptyElement", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeEndDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // writeEndDocument()
    QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
    cppSelf->QXmlStreamWriter::writeEndDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlStreamWriterFunc_writeEndElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // writeEndElement()
    QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
    cppSelf->QXmlStreamWriter::writeEndElement();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlStreamWriterFunc_writeEntityReference(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // writeEntityReference(QString)
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeEntityReference(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlStreamWriterFunc_writeEntityReference_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeEntityReference_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QXmlStreamWriter.writeEntityReference", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeNamespace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeNamespace", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // writeNamespace(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeNamespace(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // writeNamespace(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeNamespace(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeNamespace_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeNamespace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeNamespace_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeNamespace", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeProcessingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeProcessingInstruction", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // writeProcessingInstruction(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeProcessingInstruction(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // writeProcessingInstruction(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeProcessingInstruction(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeProcessingInstruction_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeProcessingInstruction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeProcessingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeProcessingInstruction", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeStartDocument(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeStartDocument", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // writeStartDocument()
        QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
        cppSelf->QXmlStreamWriter::writeStartDocument();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // writeStartDocument(QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeStartDocument(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // writeStartDocument(QString,bool)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeStartDocument(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeStartDocument_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeStartDocument_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeStartDocument_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", "PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeStartDocument", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeStartElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "writeStartElement", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // writeStartElement(QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeStartElement(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // writeStartElement(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeStartElement(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeStartElement_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeStartElement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeStartElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeStartElement", overloads);
        return 0;
}

static PyObject* SbkQXmlStreamWriterFunc_writeTextElement(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "writeTextElement", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // writeTextElement(QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeTextElement(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // writeTextElement(QString,QString,QString)
            QXmlStreamWriter* cppSelf = Shiboken::Converter<QXmlStreamWriter* >::toCpp((PyObject*)self);
            cppSelf->QXmlStreamWriter::writeTextElement(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlStreamWriterFunc_writeTextElement_TypeError;
    } else goto SbkQXmlStreamWriterFunc_writeTextElement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlStreamWriterFunc_writeTextElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QXmlStreamWriter.writeTextElement", overloads);
        return 0;
}

static PyMethodDef SbkQXmlStreamWriter_methods[] = {
    {"autoFormatting", (PyCFunction)SbkQXmlStreamWriterFunc_autoFormatting, METH_NOARGS},
    {"autoFormattingIndent", (PyCFunction)SbkQXmlStreamWriterFunc_autoFormattingIndent, METH_NOARGS},
    {"device", (PyCFunction)SbkQXmlStreamWriterFunc_device, METH_NOARGS},
    {"setAutoFormatting", (PyCFunction)SbkQXmlStreamWriterFunc_setAutoFormatting, METH_O},
    {"setAutoFormattingIndent", (PyCFunction)SbkQXmlStreamWriterFunc_setAutoFormattingIndent, METH_O},
    {"setCodec", (PyCFunction)SbkQXmlStreamWriterFunc_setCodec, METH_O},
    {"setDevice", (PyCFunction)SbkQXmlStreamWriterFunc_setDevice, METH_O},
    {"writeAttribute", (PyCFunction)SbkQXmlStreamWriterFunc_writeAttribute, METH_VARARGS},
    {"writeAttributes", (PyCFunction)SbkQXmlStreamWriterFunc_writeAttributes, METH_O},
    {"writeCDATA", (PyCFunction)SbkQXmlStreamWriterFunc_writeCDATA, METH_O},
    {"writeCharacters", (PyCFunction)SbkQXmlStreamWriterFunc_writeCharacters, METH_O},
    {"writeComment", (PyCFunction)SbkQXmlStreamWriterFunc_writeComment, METH_O},
    {"writeCurrentToken", (PyCFunction)SbkQXmlStreamWriterFunc_writeCurrentToken, METH_O},
    {"writeDTD", (PyCFunction)SbkQXmlStreamWriterFunc_writeDTD, METH_O},
    {"writeDefaultNamespace", (PyCFunction)SbkQXmlStreamWriterFunc_writeDefaultNamespace, METH_O},
    {"writeEmptyElement", (PyCFunction)SbkQXmlStreamWriterFunc_writeEmptyElement, METH_VARARGS},
    {"writeEndDocument", (PyCFunction)SbkQXmlStreamWriterFunc_writeEndDocument, METH_NOARGS},
    {"writeEndElement", (PyCFunction)SbkQXmlStreamWriterFunc_writeEndElement, METH_NOARGS},
    {"writeEntityReference", (PyCFunction)SbkQXmlStreamWriterFunc_writeEntityReference, METH_O},
    {"writeNamespace", (PyCFunction)SbkQXmlStreamWriterFunc_writeNamespace, METH_VARARGS},
    {"writeProcessingInstruction", (PyCFunction)SbkQXmlStreamWriterFunc_writeProcessingInstruction, METH_VARARGS},
    {"writeStartDocument", (PyCFunction)SbkQXmlStreamWriterFunc_writeStartDocument, METH_VARARGS},
    {"writeStartElement", (PyCFunction)SbkQXmlStreamWriterFunc_writeStartElement, METH_VARARGS},
    {"writeTextElement", (PyCFunction)SbkQXmlStreamWriterFunc_writeTextElement, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlStreamWriter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QXmlStreamWriter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlStreamWriter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlStreamWriter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlStreamWriter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlStreamWriter(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QXMLSTREAMWRITER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlStreamWriter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlStreamWriter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlStreamWriter_Type));
    PyModule_AddObject(module, "QXmlStreamWriter",
        ((PyObject*)&SbkQXmlStreamWriter_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlStreamWriter >("QXmlStreamWriter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlStreamWriter >(typeid(QXmlStreamWriter).name());
}


} // extern "C"

