/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "quuid_wrapper.h"

// Extra includes
#include <qstring.h>
#include <quuid.h>

using namespace Shiboken;

static int
SbkQUuid_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QUuid* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8 || numArgs == 9 || numArgs == 10)
        goto SbkQUuid_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QUuid", 0, 11, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8]), &(pyargs[9]), &(pyargs[10])))
        return -1;

    if (numArgs == 0) {
        // QUuid()
        cptr = new QUuid();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 11 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[3]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[4]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[5]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[6]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[7]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[8]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[9]) && Shiboken::Converter<unsigned char >::isConvertible(pyargs[10])) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(pyargs[0]);
        ushort cpp_arg1 = Shiboken::Converter<ushort >::toCpp(pyargs[1]);
        ushort cpp_arg2 = Shiboken::Converter<ushort >::toCpp(pyargs[2]);
        uchar cpp_arg3 = Shiboken::Converter<uchar >::toCpp(pyargs[3]);
        uchar cpp_arg4 = Shiboken::Converter<uchar >::toCpp(pyargs[4]);
        uchar cpp_arg5 = Shiboken::Converter<uchar >::toCpp(pyargs[5]);
        uchar cpp_arg6 = Shiboken::Converter<uchar >::toCpp(pyargs[6]);
        uchar cpp_arg7 = Shiboken::Converter<uchar >::toCpp(pyargs[7]);
        uchar cpp_arg8 = Shiboken::Converter<uchar >::toCpp(pyargs[8]);
        uchar cpp_arg9 = Shiboken::Converter<uchar >::toCpp(pyargs[9]);
        uchar cpp_arg10 = Shiboken::Converter<uchar >::toCpp(pyargs[10]);
        // QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)
        cptr = new QUuid(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7, cpp_arg8, cpp_arg9, cpp_arg10);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QUuid & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QUuid > cpp_arg0_auto_ptr;
        QUuid* cpp_arg0 = Shiboken::Converter<QUuid* >::toCpp(pyargs[0]);
        if (!SbkQUuid_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUuid >(cpp_arg0);
        // QUuid(QUuid)
        cptr = new QUuid(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QUuid(QString)
        cptr = new QUuid(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQUuid_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QUuid >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQUuid_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQUuid_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUuid", "", "PySide.QtCore.QString", "unsigned int, ushort, ushort, unsigned char, unsigned char, unsigned char, unsigned char, unsigned char, unsigned char, unsigned char, unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QUuid", overloads);
        return -1;
}

static PyObject* SbkQUuidFunc_createUuid(PyObject* self)
{
    PyObject* py_result = 0;

    // createUuid()
    QUuid cpp_result = QUuid::createUuid();
    py_result = Shiboken::Converter<QUuid >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUuidFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QUuid* cppSelf = Shiboken::Converter<QUuid* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QUuid::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUuidFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QUuid* cppSelf = Shiboken::Converter<QUuid* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QUuid::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUuidFunc_variant(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // variant()const
    QUuid* cppSelf = Shiboken::Converter<QUuid* >::toCpp((PyObject*)self);
    QUuid::Variant cpp_result = cppSelf->QUuid::variant();
    py_result = Shiboken::Converter<QUuid::Variant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQUuidFunc_version(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // version()const
    QUuid* cppSelf = Shiboken::Converter<QUuid* >::toCpp((PyObject*)self);
    QUuid::Version cpp_result = cppSelf->QUuid::version();
    py_result = Shiboken::Converter<QUuid::Version >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQUuid_methods[] = {
    {"createUuid", (PyCFunction)SbkQUuidFunc_createUuid, METH_NOARGS|METH_STATIC},
    {"isNull", (PyCFunction)SbkQUuidFunc_isNull, METH_NOARGS},
    {"toString", (PyCFunction)SbkQUuidFunc_toString, METH_NOARGS},
    {"variant", (PyCFunction)SbkQUuidFunc_variant, METH_NOARGS},
    {"version", (PyCFunction)SbkQUuidFunc_version, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQUuid_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QUuid& cpp_self = *Shiboken::Converter<QUuid* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QUuid & >::isConvertible(other)) {
                // operator!=(const QUuid & orig) const
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUuid  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QUuid >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUuid > cpp_other_auto_ptr;
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp(other);
                if (!SbkQUuid_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUuid >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQUuid_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QUuid & >::isConvertible(other)) {
                // operator<(const QUuid & other) const
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUuid  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QUuid >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUuid > cpp_other_auto_ptr;
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp(other);
                if (!SbkQUuid_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUuid >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQUuid_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QUuid & >::isConvertible(other)) {
                // operator==(const QUuid & orig) const
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUuid  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QUuid >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUuid > cpp_other_auto_ptr;
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp(other);
                if (!SbkQUuid_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUuid >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQUuid_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QUuid & >::isConvertible(other)) {
                // operator>(const QUuid & other) const
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QUuid  >::toCpp(other) : (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<QUuid >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QUuid > cpp_other_auto_ptr;
                QUuid* cpp_other = Shiboken::Converter<QUuid* >::toCpp(other);
                if (!SbkQUuid_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QUuid >(cpp_other);
                result = (cpp_self > (*cpp_other));
            } else goto SbkQUuid_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQUuid_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQUuid_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QUuid",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQUuid_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQUuid_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQUuid_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QUuid >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QUuid_Variant_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QUuid_Variant_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QUuid_Variant_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Variant",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QUuid_Variant_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QUuid_Variant_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QUuid_Variant_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QUuid_Version_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QUuid_Version_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QUuid_Version_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Version",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QUuid_Version_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QUuid_Version_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QUuid_Version_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QUuid(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QUUID_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQUuid_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQUuid_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQUuid_Type));
    PyModule_AddObject(module, "QUuid",
        ((PyObject*)&SbkQUuid_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Variant
    SbkPySide_QtCoreTypes[SBK_QUUID_VARIANT_IDX] = &SbkPySide_QtCore_QUuid_Variant_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QUuid_Variant_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QUuid_Variant_Type);
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
            "Variant",((PyObject*)&SbkPySide_QtCore_QUuid_Variant_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Variant_Type,
        (long) QUuid::VarUnknown, "VarUnknown");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "VarUnknown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Variant_Type.tp_dict,
        "VarUnknown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Variant_Type,
        (long) QUuid::NCS, "NCS");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "NCS", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Variant_Type.tp_dict,
        "NCS", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Variant_Type,
        (long) QUuid::DCE, "DCE");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "DCE", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Variant_Type.tp_dict,
        "DCE", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Variant_Type,
        (long) QUuid::Microsoft, "Microsoft");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "Microsoft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Variant_Type.tp_dict,
        "Microsoft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Variant_Type,
        (long) QUuid::Reserved, "Reserved");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "Reserved", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Variant_Type.tp_dict,
        "Reserved", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QUuid::Variant");

    // init enum class: Version
    SbkPySide_QtCoreTypes[SBK_QUUID_VERSION_IDX] = &SbkPySide_QtCore_QUuid_Version_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QUuid_Version_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QUuid_Version_Type);
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
            "Version",((PyObject*)&SbkPySide_QtCore_QUuid_Version_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Version_Type,
        (long) QUuid::VerUnknown, "VerUnknown");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "VerUnknown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Version_Type.tp_dict,
        "VerUnknown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Version_Type,
        (long) QUuid::Time, "Time");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "Time", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Version_Type.tp_dict,
        "Time", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Version_Type,
        (long) QUuid::EmbeddedPOSIX, "EmbeddedPOSIX");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "EmbeddedPOSIX", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Version_Type.tp_dict,
        "EmbeddedPOSIX", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Version_Type,
        (long) QUuid::Name, "Name");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "Name", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Version_Type.tp_dict,
        "Name", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QUuid_Version_Type,
        (long) QUuid::Random, "Random");
    PyDict_SetItemString(SbkQUuid_Type.super.ht_type.tp_dict,
        "Random", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QUuid_Version_Type.tp_dict,
        "Random", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QUuid::Version");

    Shiboken::TypeResolver::createValueTypeResolver<QUuid >("QUuid");
    Shiboken::TypeResolver::createValueTypeResolver<QUuid >(typeid(QUuid).name());
}


} // extern "C"

