/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qt_wrapper.h"

// Extra includes
#include <QTextDocument>

using namespace Shiboken;

static PyMethodDef SbkQt_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQt_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.Qt",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQt_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_Qt_ShortcutContext_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ShortcutContext_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ShortcutContext_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ShortcutContext",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ShortcutContext_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ShortcutContext_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ShortcutContext_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_CheckState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_CheckState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_CheckState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CheckState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_CheckState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_CheckState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_CheckState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_FocusPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_FocusPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_FocusPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FocusPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_FocusPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_FocusPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_FocusPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_GestureType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_GestureType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_GestureType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "GestureType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_GestureType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_GestureType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_GestureType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_DropAction___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DropActions >::toPython(
        ((Qt::DropActions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::DropActions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_DropAction___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DropActions >::toPython(
        ((Qt::DropActions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::DropActions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_DropAction___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DropActions >::toPython(
        ((Qt::DropActions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::DropActions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_DropAction___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DropActions >::toPython(
        ~ Shiboken::Converter< Qt::DropActions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_DropAction_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_DropAction___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_DropAction___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_DropAction___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_DropAction___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_DropAction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DropAction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DropAction_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DropAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_DropAction_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_DropAction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DropAction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DropAction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DropActions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DropActions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DropActions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_DropAction_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DropActions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DropActions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_DropActions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyObject*
SbkPySide_QtCore_Qt_WindowType___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowFlags >::toPython(
        ((Qt::WindowFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::WindowFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_WindowType___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowFlags >::toPython(
        ((Qt::WindowFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::WindowFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_WindowType___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowFlags >::toPython(
        ((Qt::WindowFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::WindowFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_WindowType___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowFlags >::toPython(
        ~ Shiboken::Converter< Qt::WindowFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_WindowType_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_WindowType___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_WindowType___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_WindowType___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_WindowType___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_WindowType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WindowType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WindowType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_WindowType_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_WindowType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WindowType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WindowType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WindowFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WindowFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_WindowType_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WindowFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WindowFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_WindowFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_DateFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DateFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DateFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DateFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_DateFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DateFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DateFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TextFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TextFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TextFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TextFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TextFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TextFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TextFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_PenJoinStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_PenJoinStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_PenJoinStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PenJoinStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_PenJoinStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_PenJoinStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_PenJoinStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_GestureFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::GestureFlags >::toPython(
        ((Qt::GestureFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::GestureFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_GestureFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::GestureFlags >::toPython(
        ((Qt::GestureFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::GestureFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_GestureFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::GestureFlags >::toPython(
        ((Qt::GestureFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::GestureFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_GestureFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::GestureFlags >::toPython(
        ~ Shiboken::Converter< Qt::GestureFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_GestureFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_GestureFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_GestureFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_GestureFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_GestureFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_GestureFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_GestureFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_GestureFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "GestureFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_GestureFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_GestureFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_GestureFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_GestureFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_GestureFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_GestureFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "GestureFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_GestureFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_GestureFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_GestureFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_GestureFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_CaseSensitivity_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_CaseSensitivity_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_CaseSensitivity_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CaseSensitivity",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_CaseSensitivity_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_CaseSensitivity_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_CaseSensitivity_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_EventPriority_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_EventPriority_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_EventPriority_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EventPriority",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_EventPriority_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_EventPriority_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_EventPriority_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_ImageConversionFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ImageConversionFlags >::toPython(
        ((Qt::ImageConversionFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::ImageConversionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ImageConversionFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ImageConversionFlags >::toPython(
        ((Qt::ImageConversionFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::ImageConversionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ImageConversionFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ImageConversionFlags >::toPython(
        ((Qt::ImageConversionFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::ImageConversionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ImageConversionFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ImageConversionFlags >::toPython(
        ~ Shiboken::Converter< Qt::ImageConversionFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_ImageConversionFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_ImageConversionFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_ImageConversionFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_ImageConversionFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_ImageConversionFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_ImageConversionFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ImageConversionFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ImageConversionFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ImageConversionFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_ImageConversionFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ImageConversionFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ImageConversionFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ImageConversionFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ImageConversionFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ImageConversionFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ImageConversionFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ImageConversionFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ImageConversionFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_ImageConversionFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_GestureState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_GestureState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_GestureState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "GestureState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_GestureState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_GestureState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_GestureState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_BGMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_BGMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_BGMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BGMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_BGMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_BGMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_BGMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ConnectionType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ConnectionType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ConnectionType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ConnectionType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ConnectionType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ConnectionType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ConnectionType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_ToolBarArea___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ToolBarAreas >::toPython(
        ((Qt::ToolBarAreas) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::ToolBarAreas >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ToolBarArea___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ToolBarAreas >::toPython(
        ((Qt::ToolBarAreas) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::ToolBarAreas >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ToolBarArea___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ToolBarAreas >::toPython(
        ((Qt::ToolBarAreas) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::ToolBarAreas >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ToolBarArea___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ToolBarAreas >::toPython(
        ~ Shiboken::Converter< Qt::ToolBarAreas >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_ToolBarArea_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_ToolBarArea___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_ToolBarArea___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_ToolBarArea___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_ToolBarArea___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_ToolBarArea_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ToolBarArea_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ToolBarArea_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolBarArea",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_ToolBarArea_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ToolBarArea_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ToolBarArea_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ToolBarArea_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ToolBarAreas_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ToolBarAreas_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolBarAreas",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_ToolBarArea_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ToolBarAreas_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ToolBarAreas_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_ToolBarAreas_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_CoordinateSystem_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_CoordinateSystem_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_CoordinateSystem_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CoordinateSystem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_CoordinateSystem_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_CoordinateSystem_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_CoordinateSystem_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_SizeMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_SizeMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_SizeMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SizeMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_SizeMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_SizeMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_SizeMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_FocusReason_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_FocusReason_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_FocusReason_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FocusReason",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_FocusReason_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_FocusReason_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_FocusReason_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_Modifier_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Modifier_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Modifier_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Modifier",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_Modifier_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Modifier_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Modifier_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TileRule_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TileRule_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TileRule_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TileRule",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TileRule_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TileRule_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TileRule_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_WhiteSpaceMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WhiteSpaceMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WhiteSpaceMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WhiteSpaceMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_WhiteSpaceMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WhiteSpaceMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WhiteSpaceMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_AspectRatioMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_AspectRatioMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_AspectRatioMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AspectRatioMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_AspectRatioMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_AspectRatioMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_AspectRatioMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_SizeHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_SizeHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_SizeHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SizeHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_SizeHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_SizeHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_SizeHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_AlignmentFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Alignment >::toPython(
        ((Qt::Alignment) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::Alignment >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_AlignmentFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Alignment >::toPython(
        ((Qt::Alignment) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::Alignment >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_AlignmentFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Alignment >::toPython(
        ((Qt::Alignment) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::Alignment >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_AlignmentFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Alignment >::toPython(
        ~ Shiboken::Converter< Qt::Alignment >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_AlignmentFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_AlignmentFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_AlignmentFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_AlignmentFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_AlignmentFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_AlignmentFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_AlignmentFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_AlignmentFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AlignmentFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_AlignmentFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_AlignmentFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_AlignmentFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_AlignmentFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Alignment_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Alignment_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Alignment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_AlignmentFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Alignment_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Alignment_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_Alignment_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_ContextMenuPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ContextMenuPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ContextMenuPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ContextMenuPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ContextMenuPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ContextMenuPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ContextMenuPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_DockWidgetArea___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DockWidgetAreas >::toPython(
        ((Qt::DockWidgetAreas) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::DockWidgetAreas >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_DockWidgetArea___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DockWidgetAreas >::toPython(
        ((Qt::DockWidgetAreas) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::DockWidgetAreas >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_DockWidgetArea___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DockWidgetAreas >::toPython(
        ((Qt::DockWidgetAreas) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::DockWidgetAreas >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_DockWidgetArea___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::DockWidgetAreas >::toPython(
        ~ Shiboken::Converter< Qt::DockWidgetAreas >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_DockWidgetArea_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_DockWidgetArea___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_DockWidgetArea___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_DockWidgetArea___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_DockWidgetArea___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_DockWidgetArea_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DockWidgetArea_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DockWidgetArea_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DockWidgetArea",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_DockWidgetArea_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_DockWidgetArea_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DockWidgetArea_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DockWidgetArea_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DockWidgetAreas_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DockWidgetAreas_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DockWidgetAreas",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_DockWidgetArea_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DockWidgetAreas_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DockWidgetAreas_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_DockWidgetAreas_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_UIEffect_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_UIEffect_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_UIEffect_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "UIEffect",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_UIEffect_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_UIEffect_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_UIEffect_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_Initialization_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Initialization_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Initialization_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Initialization",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_Initialization_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Initialization_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Initialization_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_AnchorPoint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_AnchorPoint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_AnchorPoint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AnchorPoint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_AnchorPoint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_AnchorPoint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_AnchorPoint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_GlobalColor_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_GlobalColor_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_GlobalColor_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "GlobalColor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_GlobalColor_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_GlobalColor_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_GlobalColor_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_KeyboardModifier___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::KeyboardModifiers >::toPython(
        ((Qt::KeyboardModifiers) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::KeyboardModifiers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_KeyboardModifier___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::KeyboardModifiers >::toPython(
        ((Qt::KeyboardModifiers) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::KeyboardModifiers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_KeyboardModifier___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::KeyboardModifiers >::toPython(
        ((Qt::KeyboardModifiers) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::KeyboardModifiers >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_KeyboardModifier___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::KeyboardModifiers >::toPython(
        ~ Shiboken::Converter< Qt::KeyboardModifiers >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_KeyboardModifier_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_KeyboardModifier___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_KeyboardModifier___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_KeyboardModifier___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_KeyboardModifier___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_KeyboardModifier_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_KeyboardModifier_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_KeyboardModifier_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "KeyboardModifier",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_KeyboardModifier_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_KeyboardModifier_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_KeyboardModifier_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_KeyboardModifier_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_KeyboardModifiers_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_KeyboardModifiers_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "KeyboardModifiers",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_KeyboardModifier_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_KeyboardModifiers_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_KeyboardModifiers_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_KeyboardModifiers_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_NavigationMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_NavigationMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_NavigationMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NavigationMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_NavigationMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_NavigationMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_NavigationMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ItemDataRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ItemDataRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ItemDataRole_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemDataRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ItemDataRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ItemDataRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ItemDataRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ScrollBarPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ScrollBarPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ScrollBarPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ScrollBarPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ScrollBarPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ScrollBarPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ScrollBarPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_InputMethodHint___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::InputMethodHints >::toPython(
        ((Qt::InputMethodHints) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::InputMethodHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_InputMethodHint___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::InputMethodHints >::toPython(
        ((Qt::InputMethodHints) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::InputMethodHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_InputMethodHint___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::InputMethodHints >::toPython(
        ((Qt::InputMethodHints) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::InputMethodHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_InputMethodHint___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::InputMethodHints >::toPython(
        ~ Shiboken::Converter< Qt::InputMethodHints >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_InputMethodHint_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_InputMethodHint___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_InputMethodHint___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_InputMethodHint___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_InputMethodHint___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_InputMethodHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_InputMethodHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_InputMethodHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputMethodHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_InputMethodHint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_InputMethodHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_InputMethodHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_InputMethodHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_InputMethodHints_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_InputMethodHints_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputMethodHints",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_InputMethodHint_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_InputMethodHints_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_InputMethodHints_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_InputMethodHints_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_AnchorAttribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_AnchorAttribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_AnchorAttribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AnchorAttribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_AnchorAttribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_AnchorAttribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_AnchorAttribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_WindowModality_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WindowModality_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WindowModality_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowModality",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_WindowModality_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WindowModality_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WindowModality_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_SortOrder_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_SortOrder_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_SortOrder_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SortOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_SortOrder_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_SortOrder_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_SortOrder_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_PenStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_PenStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_PenStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PenStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_PenStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_PenStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_PenStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_ItemFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ItemFlags >::toPython(
        ((Qt::ItemFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::ItemFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ItemFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ItemFlags >::toPython(
        ((Qt::ItemFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::ItemFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ItemFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ItemFlags >::toPython(
        ((Qt::ItemFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::ItemFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_ItemFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::ItemFlags >::toPython(
        ~ Shiboken::Converter< Qt::ItemFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_ItemFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_ItemFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_ItemFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_ItemFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_ItemFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_ItemFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ItemFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ItemFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_ItemFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ItemFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ItemFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ItemFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ItemFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ItemFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_ItemFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ItemFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ItemFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_ItemFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_Axis_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Axis_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Axis_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Axis",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_Axis_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Axis_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Axis_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TransformationMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TransformationMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TransformationMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TransformationMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TransformationMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TransformationMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TransformationMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_WindowFrameSection_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WindowFrameSection_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WindowFrameSection_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowFrameSection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_WindowFrameSection_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WindowFrameSection_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WindowFrameSection_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_HitTestAccuracy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_HitTestAccuracy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_HitTestAccuracy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "HitTestAccuracy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_HitTestAccuracy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_HitTestAccuracy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_HitTestAccuracy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_CursorShape_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_CursorShape_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_CursorShape_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CursorShape",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_CursorShape_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_CursorShape_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_CursorShape_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ItemSelectionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ItemSelectionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ItemSelectionMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ItemSelectionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ItemSelectionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ItemSelectionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ItemSelectionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_Orientation___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Orientations >::toPython(
        ((Qt::Orientations) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::Orientations >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_Orientation___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Orientations >::toPython(
        ((Qt::Orientations) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::Orientations >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_Orientation___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Orientations >::toPython(
        ((Qt::Orientations) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::Orientations >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_Orientation___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::Orientations >::toPython(
        ~ Shiboken::Converter< Qt::Orientations >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_Orientation_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_Orientation___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_Orientation___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_Orientation___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_Orientation___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_Orientation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Orientation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Orientation_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Orientation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_Orientation_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_Orientation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Orientation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Orientation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Orientations_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Orientations_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Orientations",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_Orientation_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Orientations_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Orientations_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_Orientations_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_InputMethodQuery_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_InputMethodQuery_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_InputMethodQuery_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputMethodQuery",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_InputMethodQuery_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_InputMethodQuery_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_InputMethodQuery_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TimeSpec_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TimeSpec_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TimeSpec_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TimeSpec",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TimeSpec_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TimeSpec_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TimeSpec_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ArrowType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ArrowType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ArrowType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ArrowType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ArrowType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ArrowType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ArrowType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_FillRule_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_FillRule_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_FillRule_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FillRule",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_FillRule_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_FillRule_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_FillRule_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_MaskMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_MaskMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_MaskMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MaskMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_MaskMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_MaskMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_MaskMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_WindowState___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowStates >::toPython(
        ((Qt::WindowStates) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::WindowStates >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_WindowState___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowStates >::toPython(
        ((Qt::WindowStates) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::WindowStates >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_WindowState___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowStates >::toPython(
        ((Qt::WindowStates) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::WindowStates >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_WindowState___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::WindowStates >::toPython(
        ~ Shiboken::Converter< Qt::WindowStates >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_WindowState_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_WindowState___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_WindowState___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_WindowState___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_WindowState___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_WindowState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WindowState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WindowState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_WindowState_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_WindowState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WindowState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WindowState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WindowStates_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WindowStates_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WindowStates",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_WindowState_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WindowStates_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WindowStates_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_WindowStates_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_ToolBarAreaSizes_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ToolBarAreaSizes_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolBarAreaSizes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ToolBarAreaSizes_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ToolBarAreaSizes_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ToolBarAreaSizes_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_Corner_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Corner_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Corner_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Corner",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_Corner_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Corner_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Corner_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_DayOfWeek_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DayOfWeek_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DayOfWeek_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DayOfWeek",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_DayOfWeek_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DayOfWeek_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DayOfWeek_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ClipOperation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ClipOperation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ClipOperation_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ClipOperation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ClipOperation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ClipOperation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ClipOperation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_LayoutDirection_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_LayoutDirection_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_LayoutDirection_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LayoutDirection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_LayoutDirection_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_LayoutDirection_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_LayoutDirection_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ToolButtonStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ToolButtonStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ToolButtonStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ToolButtonStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ToolButtonStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ToolButtonStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ToolButtonStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_DockWidgetAreaSizes_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_DockWidgetAreaSizes_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DockWidgetAreaSizes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_DockWidgetAreaSizes_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_DockWidgetAreaSizes_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_DockWidgetAreaSizes_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_Key_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_Key_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_Key_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Key",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_Key_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_Key_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_Key_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_ApplicationAttribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_ApplicationAttribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_ApplicationAttribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ApplicationAttribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_ApplicationAttribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_ApplicationAttribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_ApplicationAttribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TextFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TextFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TextFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TextFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TextFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TextFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TextFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_BrushStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_BrushStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_BrushStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BrushStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_BrushStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_BrushStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_BrushStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_WidgetAttribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_WidgetAttribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_WidgetAttribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "WidgetAttribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_WidgetAttribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_WidgetAttribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_WidgetAttribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TouchPointState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TouchPointState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TouchPointState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TouchPointState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TouchPointState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TouchPointState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TouchPointState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtCore_Qt_TextInteractionFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::TextInteractionFlags >::toPython(
        ((Qt::TextInteractionFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::TextInteractionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_TextInteractionFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::TextInteractionFlags >::toPython(
        ((Qt::TextInteractionFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::TextInteractionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_TextInteractionFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::TextInteractionFlags >::toPython(
        ((Qt::TextInteractionFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::TextInteractionFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_TextInteractionFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::TextInteractionFlags >::toPython(
        ~ Shiboken::Converter< Qt::TextInteractionFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_TextInteractionFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_TextInteractionFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_TextInteractionFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_TextInteractionFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_TextInteractionFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_TextInteractionFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TextInteractionFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TextInteractionFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TextInteractionFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_TextInteractionFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TextInteractionFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TextInteractionFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TextInteractionFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TextInteractionFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TextInteractionFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TextInteractionFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TextInteractionFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TextInteractionFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_TextInteractionFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyObject*
SbkPySide_QtCore_Qt_MouseButton___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MouseButtons >::toPython(
        ((Qt::MouseButtons) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::MouseButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_MouseButton___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MouseButtons >::toPython(
        ((Qt::MouseButtons) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::MouseButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_MouseButton___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MouseButtons >::toPython(
        ((Qt::MouseButtons) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::MouseButtons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_MouseButton___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MouseButtons >::toPython(
        ~ Shiboken::Converter< Qt::MouseButtons >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_MouseButton_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_MouseButton___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_MouseButton___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_MouseButton___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_MouseButton___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_MouseButton_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_MouseButton_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_MouseButton_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MouseButton",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_MouseButton_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_MouseButton_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_MouseButton_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_MouseButton_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_MouseButtons_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_MouseButtons_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MouseButtons",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_MouseButton_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_MouseButtons_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_MouseButtons_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_MouseButtons_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyObject*
SbkPySide_QtCore_Qt_MatchFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MatchFlags >::toPython(
        ((Qt::MatchFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Qt::MatchFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_MatchFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MatchFlags >::toPython(
        ((Qt::MatchFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Qt::MatchFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_MatchFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MatchFlags >::toPython(
        ((Qt::MatchFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Qt::MatchFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_Qt_MatchFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Qt::MatchFlags >::toPython(
        ~ Shiboken::Converter< Qt::MatchFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_Qt_MatchFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_Qt_MatchFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_Qt_MatchFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_Qt_MatchFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_Qt_MatchFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_Qt_MatchFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_MatchFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_MatchFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MatchFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_Qt_MatchFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_MatchFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_MatchFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_MatchFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_MatchFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_MatchFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MatchFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_Qt_MatchFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_MatchFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_MatchFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_Qt_MatchFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_Qt_PenCapStyle_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_PenCapStyle_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_PenCapStyle_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PenCapStyle",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_PenCapStyle_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_PenCapStyle_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_PenCapStyle_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_Qt_TextElideMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_Qt_TextElideMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_Qt_TextElideMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TextElideMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_Qt_TextElideMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_Qt_TextElideMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_Qt_TextElideMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_Qt(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQt_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQt_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQt_Type));
    PyModule_AddObject(module, "Qt",
        ((PyObject*)&SbkQt_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ShortcutContext
    SbkPySide_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX] = &SbkPySide_QtCore_Qt_ShortcutContext_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ShortcutContext_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ShortcutContext_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ShortcutContext",((PyObject*)&SbkPySide_QtCore_Qt_ShortcutContext_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ShortcutContext_Type,
        (long) Qt::WidgetShortcut, "WidgetShortcut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WidgetShortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ShortcutContext_Type.tp_dict,
        "WidgetShortcut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ShortcutContext_Type,
        (long) Qt::WindowShortcut, "WindowShortcut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowShortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ShortcutContext_Type.tp_dict,
        "WindowShortcut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ShortcutContext_Type,
        (long) Qt::ApplicationShortcut, "ApplicationShortcut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ApplicationShortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ShortcutContext_Type.tp_dict,
        "ApplicationShortcut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ShortcutContext_Type,
        (long) Qt::WidgetWithChildrenShortcut, "WidgetWithChildrenShortcut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WidgetWithChildrenShortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ShortcutContext_Type.tp_dict,
        "WidgetWithChildrenShortcut", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ShortcutContext");

    // init enum class: CheckState
    SbkPySide_QtCoreTypes[SBK_QT_CHECKSTATE_IDX] = &SbkPySide_QtCore_Qt_CheckState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_CheckState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_CheckState_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "CheckState",((PyObject*)&SbkPySide_QtCore_Qt_CheckState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CheckState_Type,
        (long) Qt::Unchecked, "Unchecked");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Unchecked", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CheckState_Type.tp_dict,
        "Unchecked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CheckState_Type,
        (long) Qt::PartiallyChecked, "PartiallyChecked");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PartiallyChecked", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CheckState_Type.tp_dict,
        "PartiallyChecked", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CheckState_Type,
        (long) Qt::Checked, "Checked");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Checked", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CheckState_Type.tp_dict,
        "Checked", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::CheckState");

    // init enum class: FocusPolicy
    SbkPySide_QtCoreTypes[SBK_QT_FOCUSPOLICY_IDX] = &SbkPySide_QtCore_Qt_FocusPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_FocusPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_FocusPolicy_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "FocusPolicy",((PyObject*)&SbkPySide_QtCore_Qt_FocusPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusPolicy_Type,
        (long) Qt::NoFocus, "NoFocus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusPolicy_Type.tp_dict,
        "NoFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusPolicy_Type,
        (long) Qt::TabFocus, "TabFocus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TabFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusPolicy_Type.tp_dict,
        "TabFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusPolicy_Type,
        (long) Qt::ClickFocus, "ClickFocus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ClickFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusPolicy_Type.tp_dict,
        "ClickFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusPolicy_Type,
        (long) Qt::StrongFocus, "StrongFocus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "StrongFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusPolicy_Type.tp_dict,
        "StrongFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusPolicy_Type,
        (long) Qt::WheelFocus, "WheelFocus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WheelFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusPolicy_Type.tp_dict,
        "WheelFocus", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::FocusPolicy");

    // init enum class: GestureType
    SbkPySide_QtCoreTypes[SBK_QT_GESTURETYPE_IDX] = &SbkPySide_QtCore_Qt_GestureType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_GestureType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_GestureType_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "GestureType",((PyObject*)&SbkPySide_QtCore_Qt_GestureType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::TapGesture, "TapGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TapGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "TapGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::TapAndHoldGesture, "TapAndHoldGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TapAndHoldGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "TapAndHoldGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::PanGesture, "PanGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PanGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "PanGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::PinchGesture, "PinchGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PinchGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "PinchGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::SwipeGesture, "SwipeGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SwipeGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "SwipeGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::CustomGesture, "CustomGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CustomGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "CustomGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureType_Type,
        (long) Qt::LastGestureType, "LastGestureType");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LastGestureType", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureType_Type.tp_dict,
        "LastGestureType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::GestureType");

    // init enum class: DropAction
    SbkPySide_QtCoreTypes[SBK_QT_DROPACTION_IDX] = &SbkPySide_QtCore_Qt_DropAction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DropAction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DropAction_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DropAction",((PyObject*)&SbkPySide_QtCore_Qt_DropAction_Type));

    // init flags class: QFlags<Qt::DropAction>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_DROPACTION__IDX] = &SbkPySide_QtCore_Qt_DropActions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DropActions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DropActions_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DropActions",((PyObject*)&SbkPySide_QtCore_Qt_DropActions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DropAction_Type,
        (long) Qt::CopyAction, "CopyAction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CopyAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DropAction_Type.tp_dict,
        "CopyAction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DropAction_Type,
        (long) Qt::MoveAction, "MoveAction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MoveAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DropAction_Type.tp_dict,
        "MoveAction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DropAction_Type,
        (long) Qt::LinkAction, "LinkAction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LinkAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DropAction_Type.tp_dict,
        "LinkAction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DropAction_Type,
        (long) Qt::ActionMask, "ActionMask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ActionMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DropAction_Type.tp_dict,
        "ActionMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DropAction_Type,
        (long) Qt::TargetMoveAction, "TargetMoveAction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TargetMoveAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DropAction_Type.tp_dict,
        "TargetMoveAction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DropAction_Type,
        (long) Qt::IgnoreAction, "IgnoreAction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "IgnoreAction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DropAction_Type.tp_dict,
        "IgnoreAction", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::DropAction");

    // init enum class: WindowType
    SbkPySide_QtCoreTypes[SBK_QT_WINDOWTYPE_IDX] = &SbkPySide_QtCore_Qt_WindowType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WindowType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WindowType_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WindowType",((PyObject*)&SbkPySide_QtCore_Qt_WindowType_Type));

    // init flags class: QFlags<Qt::WindowType>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE__IDX] = &SbkPySide_QtCore_Qt_WindowFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WindowFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WindowFlags_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WindowFlags",((PyObject*)&SbkPySide_QtCore_Qt_WindowFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Widget, "Widget");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Widget", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Widget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Window, "Window");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Window", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Window", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Dialog, "Dialog");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dialog", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Dialog", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Sheet, "Sheet");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Sheet", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Sheet", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Drawer, "Drawer");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Drawer", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Drawer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Popup, "Popup");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Popup", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Popup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Tool, "Tool");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Tool", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Tool", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::ToolTip, "ToolTip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolTip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "ToolTip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::SplashScreen, "SplashScreen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SplashScreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "SplashScreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::Desktop, "Desktop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Desktop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "Desktop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::SubWindow, "SubWindow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SubWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "SubWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowType_Mask, "WindowType_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowType_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowType_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::MSWindowsFixedSizeDialogHint, "MSWindowsFixedSizeDialogHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MSWindowsFixedSizeDialogHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "MSWindowsFixedSizeDialogHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::MSWindowsOwnDC, "MSWindowsOwnDC");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MSWindowsOwnDC", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "MSWindowsOwnDC", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::X11BypassWindowManagerHint, "X11BypassWindowManagerHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "X11BypassWindowManagerHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "X11BypassWindowManagerHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::FramelessWindowHint, "FramelessWindowHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "FramelessWindowHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "FramelessWindowHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowTitleHint, "WindowTitleHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowTitleHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowTitleHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowSystemMenuHint, "WindowSystemMenuHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowSystemMenuHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowSystemMenuHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowMinimizeButtonHint, "WindowMinimizeButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowMinimizeButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowMinimizeButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowMaximizeButtonHint, "WindowMaximizeButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowMaximizeButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowMaximizeButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowMinMaxButtonsHint, "WindowMinMaxButtonsHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowMinMaxButtonsHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowMinMaxButtonsHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowContextHelpButtonHint, "WindowContextHelpButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowContextHelpButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowContextHelpButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowShadeButtonHint, "WindowShadeButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowShadeButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowShadeButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowStaysOnTopHint, "WindowStaysOnTopHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowStaysOnTopHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowStaysOnTopHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::CustomizeWindowHint, "CustomizeWindowHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CustomizeWindowHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "CustomizeWindowHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowStaysOnBottomHint, "WindowStaysOnBottomHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowStaysOnBottomHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowStaysOnBottomHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowCloseButtonHint, "WindowCloseButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowCloseButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowCloseButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::MacWindowToolBarButtonHint, "MacWindowToolBarButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MacWindowToolBarButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "MacWindowToolBarButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::BypassGraphicsProxyWidget, "BypassGraphicsProxyWidget");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BypassGraphicsProxyWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "BypassGraphicsProxyWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowOkButtonHint, "WindowOkButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowOkButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowOkButtonHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowType_Type,
        (long) Qt::WindowCancelButtonHint, "WindowCancelButtonHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowCancelButtonHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowType_Type.tp_dict,
        "WindowCancelButtonHint", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::WindowType");

    // init enum class: DateFormat
    SbkPySide_QtCoreTypes[SBK_QT_DATEFORMAT_IDX] = &SbkPySide_QtCore_Qt_DateFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DateFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DateFormat_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DateFormat",((PyObject*)&SbkPySide_QtCore_Qt_DateFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::TextDate, "TextDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "TextDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::ISODate, "ISODate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ISODate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "ISODate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::SystemLocaleDate, "SystemLocaleDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SystemLocaleDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "SystemLocaleDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::LocalDate, "LocalDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LocalDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "LocalDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::LocaleDate, "LocaleDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LocaleDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "LocaleDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::SystemLocaleShortDate, "SystemLocaleShortDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SystemLocaleShortDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "SystemLocaleShortDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::SystemLocaleLongDate, "SystemLocaleLongDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SystemLocaleLongDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "SystemLocaleLongDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::DefaultLocaleShortDate, "DefaultLocaleShortDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DefaultLocaleShortDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "DefaultLocaleShortDate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DateFormat_Type,
        (long) Qt::DefaultLocaleLongDate, "DefaultLocaleLongDate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DefaultLocaleLongDate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DateFormat_Type.tp_dict,
        "DefaultLocaleLongDate", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::DateFormat");

    // init enum class: TextFormat
    SbkPySide_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX] = &SbkPySide_QtCore_Qt_TextFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TextFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TextFormat_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TextFormat",((PyObject*)&SbkPySide_QtCore_Qt_TextFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFormat_Type,
        (long) Qt::PlainText, "PlainText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PlainText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFormat_Type.tp_dict,
        "PlainText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFormat_Type,
        (long) Qt::RichText, "RichText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RichText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFormat_Type.tp_dict,
        "RichText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFormat_Type,
        (long) Qt::AutoText, "AutoText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AutoText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFormat_Type.tp_dict,
        "AutoText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFormat_Type,
        (long) Qt::LogText, "LogText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LogText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFormat_Type.tp_dict,
        "LogText", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TextFormat");

    // init enum class: PenJoinStyle
    SbkPySide_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX] = &SbkPySide_QtCore_Qt_PenJoinStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_PenJoinStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_PenJoinStyle_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "PenJoinStyle",((PyObject*)&SbkPySide_QtCore_Qt_PenJoinStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenJoinStyle_Type,
        (long) Qt::MiterJoin, "MiterJoin");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MiterJoin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenJoinStyle_Type.tp_dict,
        "MiterJoin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenJoinStyle_Type,
        (long) Qt::BevelJoin, "BevelJoin");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BevelJoin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenJoinStyle_Type.tp_dict,
        "BevelJoin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenJoinStyle_Type,
        (long) Qt::RoundJoin, "RoundJoin");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RoundJoin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenJoinStyle_Type.tp_dict,
        "RoundJoin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenJoinStyle_Type,
        (long) Qt::SvgMiterJoin, "SvgMiterJoin");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SvgMiterJoin", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenJoinStyle_Type.tp_dict,
        "SvgMiterJoin", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenJoinStyle_Type,
        (long) Qt::MPenJoinStyle, "MPenJoinStyle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MPenJoinStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenJoinStyle_Type.tp_dict,
        "MPenJoinStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::PenJoinStyle");

    // init enum class: GestureFlag
    SbkPySide_QtCoreTypes[SBK_QT_GESTUREFLAG_IDX] = &SbkPySide_QtCore_Qt_GestureFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_GestureFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_GestureFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "GestureFlag",((PyObject*)&SbkPySide_QtCore_Qt_GestureFlag_Type));

    // init flags class: QFlags<Qt::GestureFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_GESTUREFLAG__IDX] = &SbkPySide_QtCore_Qt_GestureFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_GestureFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_GestureFlags_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "GestureFlags",((PyObject*)&SbkPySide_QtCore_Qt_GestureFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureFlag_Type,
        (long) Qt::DontStartGestureOnChildren, "DontStartGestureOnChildren");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DontStartGestureOnChildren", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureFlag_Type.tp_dict,
        "DontStartGestureOnChildren", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureFlag_Type,
        (long) Qt::ReceivePartialGestures, "ReceivePartialGestures");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ReceivePartialGestures", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureFlag_Type.tp_dict,
        "ReceivePartialGestures", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::GestureFlag");

    // init enum class: CaseSensitivity
    SbkPySide_QtCoreTypes[SBK_QT_CASESENSITIVITY_IDX] = &SbkPySide_QtCore_Qt_CaseSensitivity_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_CaseSensitivity_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_CaseSensitivity_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "CaseSensitivity",((PyObject*)&SbkPySide_QtCore_Qt_CaseSensitivity_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CaseSensitivity_Type,
        (long) Qt::CaseInsensitive, "CaseInsensitive");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CaseInsensitive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CaseSensitivity_Type.tp_dict,
        "CaseInsensitive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CaseSensitivity_Type,
        (long) Qt::CaseSensitive, "CaseSensitive");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CaseSensitive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CaseSensitivity_Type.tp_dict,
        "CaseSensitive", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::CaseSensitivity");

    // init enum class: EventPriority
    SbkPySide_QtCoreTypes[SBK_QT_EVENTPRIORITY_IDX] = &SbkPySide_QtCore_Qt_EventPriority_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_EventPriority_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_EventPriority_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "EventPriority",((PyObject*)&SbkPySide_QtCore_Qt_EventPriority_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_EventPriority_Type,
        (long) Qt::HighEventPriority, "HighEventPriority");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "HighEventPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_EventPriority_Type.tp_dict,
        "HighEventPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_EventPriority_Type,
        (long) Qt::NormalEventPriority, "NormalEventPriority");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NormalEventPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_EventPriority_Type.tp_dict,
        "NormalEventPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_EventPriority_Type,
        (long) Qt::LowEventPriority, "LowEventPriority");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LowEventPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_EventPriority_Type.tp_dict,
        "LowEventPriority", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::EventPriority");

    // init enum class: ImageConversionFlag
    SbkPySide_QtCoreTypes[SBK_QT_IMAGECONVERSIONFLAG_IDX] = &SbkPySide_QtCore_Qt_ImageConversionFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ImageConversionFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ImageConversionFlag",((PyObject*)&SbkPySide_QtCore_Qt_ImageConversionFlag_Type));

    // init flags class: QFlags<Qt::ImageConversionFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_IMAGECONVERSIONFLAG__IDX] = &SbkPySide_QtCore_Qt_ImageConversionFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ImageConversionFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ImageConversionFlags_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ImageConversionFlags",((PyObject*)&SbkPySide_QtCore_Qt_ImageConversionFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::ColorMode_Mask, "ColorMode_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ColorMode_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "ColorMode_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::AutoColor, "AutoColor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AutoColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "AutoColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::ColorOnly, "ColorOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ColorOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "ColorOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::MonoOnly, "MonoOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MonoOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "MonoOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::AlphaDither_Mask, "AlphaDither_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlphaDither_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "AlphaDither_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::ThresholdAlphaDither, "ThresholdAlphaDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ThresholdAlphaDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "ThresholdAlphaDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::OrderedAlphaDither, "OrderedAlphaDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OrderedAlphaDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "OrderedAlphaDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::DiffuseAlphaDither, "DiffuseAlphaDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DiffuseAlphaDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "DiffuseAlphaDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::NoAlpha, "NoAlpha");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoAlpha", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "NoAlpha", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::Dither_Mask, "Dither_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dither_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "Dither_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::DiffuseDither, "DiffuseDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DiffuseDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "DiffuseDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::OrderedDither, "OrderedDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OrderedDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "OrderedDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::ThresholdDither, "ThresholdDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ThresholdDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "ThresholdDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::DitherMode_Mask, "DitherMode_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DitherMode_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "DitherMode_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::AutoDither, "AutoDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AutoDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "AutoDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::PreferDither, "PreferDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PreferDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "PreferDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::AvoidDither, "AvoidDither");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AvoidDither", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "AvoidDither", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ImageConversionFlag_Type,
        (long) Qt::NoOpaqueDetection, "NoOpaqueDetection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoOpaqueDetection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ImageConversionFlag_Type.tp_dict,
        "NoOpaqueDetection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ImageConversionFlag");

    // init enum class: GestureState
    SbkPySide_QtCoreTypes[SBK_QT_GESTURESTATE_IDX] = &SbkPySide_QtCore_Qt_GestureState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_GestureState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_GestureState_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "GestureState",((PyObject*)&SbkPySide_QtCore_Qt_GestureState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureState_Type,
        (long) Qt::NoGesture, "NoGesture");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoGesture", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureState_Type.tp_dict,
        "NoGesture", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureState_Type,
        (long) Qt::GestureStarted, "GestureStarted");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "GestureStarted", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureState_Type.tp_dict,
        "GestureStarted", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureState_Type,
        (long) Qt::GestureUpdated, "GestureUpdated");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "GestureUpdated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureState_Type.tp_dict,
        "GestureUpdated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureState_Type,
        (long) Qt::GestureFinished, "GestureFinished");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "GestureFinished", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureState_Type.tp_dict,
        "GestureFinished", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GestureState_Type,
        (long) Qt::GestureCanceled, "GestureCanceled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "GestureCanceled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GestureState_Type.tp_dict,
        "GestureCanceled", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::GestureState");

    // init enum class: BGMode
    SbkPySide_QtCoreTypes[SBK_QT_BGMODE_IDX] = &SbkPySide_QtCore_Qt_BGMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_BGMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_BGMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "BGMode",((PyObject*)&SbkPySide_QtCore_Qt_BGMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BGMode_Type,
        (long) Qt::TransparentMode, "TransparentMode");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TransparentMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BGMode_Type.tp_dict,
        "TransparentMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BGMode_Type,
        (long) Qt::OpaqueMode, "OpaqueMode");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OpaqueMode", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BGMode_Type.tp_dict,
        "OpaqueMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::BGMode");

    // init enum class: ConnectionType
    SbkPySide_QtCoreTypes[SBK_QT_CONNECTIONTYPE_IDX] = &SbkPySide_QtCore_Qt_ConnectionType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ConnectionType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ConnectionType_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ConnectionType",((PyObject*)&SbkPySide_QtCore_Qt_ConnectionType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ConnectionType_Type,
        (long) Qt::AutoConnection, "AutoConnection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AutoConnection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ConnectionType_Type.tp_dict,
        "AutoConnection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ConnectionType_Type,
        (long) Qt::DirectConnection, "DirectConnection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DirectConnection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ConnectionType_Type.tp_dict,
        "DirectConnection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ConnectionType_Type,
        (long) Qt::QueuedConnection, "QueuedConnection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "QueuedConnection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ConnectionType_Type.tp_dict,
        "QueuedConnection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ConnectionType_Type,
        (long) Qt::AutoCompatConnection, "AutoCompatConnection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AutoCompatConnection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ConnectionType_Type.tp_dict,
        "AutoCompatConnection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ConnectionType_Type,
        (long) Qt::BlockingQueuedConnection, "BlockingQueuedConnection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BlockingQueuedConnection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ConnectionType_Type.tp_dict,
        "BlockingQueuedConnection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ConnectionType_Type,
        (long) Qt::UniqueConnection, "UniqueConnection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UniqueConnection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ConnectionType_Type.tp_dict,
        "UniqueConnection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ConnectionType");

    // init enum class: ToolBarArea
    SbkPySide_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX] = &SbkPySide_QtCore_Qt_ToolBarArea_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ToolBarArea_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ToolBarArea_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ToolBarArea",((PyObject*)&SbkPySide_QtCore_Qt_ToolBarArea_Type));

    // init flags class: QFlags<Qt::ToolBarArea>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_TOOLBARAREA__IDX] = &SbkPySide_QtCore_Qt_ToolBarAreas_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ToolBarAreas_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ToolBarAreas_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ToolBarAreas",((PyObject*)&SbkPySide_QtCore_Qt_ToolBarAreas_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::LeftToolBarArea, "LeftToolBarArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LeftToolBarArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "LeftToolBarArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::RightToolBarArea, "RightToolBarArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RightToolBarArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "RightToolBarArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::TopToolBarArea, "TopToolBarArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopToolBarArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "TopToolBarArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::BottomToolBarArea, "BottomToolBarArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomToolBarArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "BottomToolBarArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::ToolBarArea_Mask, "ToolBarArea_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolBarArea_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "ToolBarArea_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::AllToolBarAreas, "AllToolBarAreas");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AllToolBarAreas", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "AllToolBarAreas", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarArea_Type,
        (long) Qt::NoToolBarArea, "NoToolBarArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoToolBarArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarArea_Type.tp_dict,
        "NoToolBarArea", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ToolBarArea");

    // init enum class: CoordinateSystem
    SbkPySide_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX] = &SbkPySide_QtCore_Qt_CoordinateSystem_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_CoordinateSystem_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_CoordinateSystem_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "CoordinateSystem",((PyObject*)&SbkPySide_QtCore_Qt_CoordinateSystem_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CoordinateSystem_Type,
        (long) Qt::DeviceCoordinates, "DeviceCoordinates");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DeviceCoordinates", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CoordinateSystem_Type.tp_dict,
        "DeviceCoordinates", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CoordinateSystem_Type,
        (long) Qt::LogicalCoordinates, "LogicalCoordinates");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LogicalCoordinates", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CoordinateSystem_Type.tp_dict,
        "LogicalCoordinates", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::CoordinateSystem");

    // init enum class: SizeMode
    SbkPySide_QtCoreTypes[SBK_QT_SIZEMODE_IDX] = &SbkPySide_QtCore_Qt_SizeMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_SizeMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_SizeMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "SizeMode",((PyObject*)&SbkPySide_QtCore_Qt_SizeMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeMode_Type,
        (long) Qt::AbsoluteSize, "AbsoluteSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AbsoluteSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeMode_Type.tp_dict,
        "AbsoluteSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeMode_Type,
        (long) Qt::RelativeSize, "RelativeSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RelativeSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeMode_Type.tp_dict,
        "RelativeSize", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::SizeMode");

    // init enum class: FocusReason
    SbkPySide_QtCoreTypes[SBK_QT_FOCUSREASON_IDX] = &SbkPySide_QtCore_Qt_FocusReason_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_FocusReason_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_FocusReason_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "FocusReason",((PyObject*)&SbkPySide_QtCore_Qt_FocusReason_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::MouseFocusReason, "MouseFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MouseFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "MouseFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::TabFocusReason, "TabFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TabFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "TabFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::BacktabFocusReason, "BacktabFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BacktabFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "BacktabFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::ActiveWindowFocusReason, "ActiveWindowFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ActiveWindowFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "ActiveWindowFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::PopupFocusReason, "PopupFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PopupFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "PopupFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::ShortcutFocusReason, "ShortcutFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ShortcutFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "ShortcutFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::MenuBarFocusReason, "MenuBarFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MenuBarFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "MenuBarFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::OtherFocusReason, "OtherFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OtherFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "OtherFocusReason", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FocusReason_Type,
        (long) Qt::NoFocusReason, "NoFocusReason");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoFocusReason", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FocusReason_Type.tp_dict,
        "NoFocusReason", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::FocusReason");

    // init enum class: Modifier
    SbkPySide_QtCoreTypes[SBK_QT_MODIFIER_IDX] = &SbkPySide_QtCore_Qt_Modifier_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Modifier_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Modifier_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Modifier",((PyObject*)&SbkPySide_QtCore_Qt_Modifier_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Modifier_Type,
        (long) Qt::META, "META");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "META", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Modifier_Type.tp_dict,
        "META", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Modifier_Type,
        (long) Qt::SHIFT, "SHIFT");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SHIFT", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Modifier_Type.tp_dict,
        "SHIFT", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Modifier_Type,
        (long) Qt::CTRL, "CTRL");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CTRL", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Modifier_Type.tp_dict,
        "CTRL", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Modifier_Type,
        (long) Qt::ALT, "ALT");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ALT", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Modifier_Type.tp_dict,
        "ALT", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Modifier_Type,
        (long) Qt::MODIFIER_MASK, "MODIFIER_MASK");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MODIFIER_MASK", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Modifier_Type.tp_dict,
        "MODIFIER_MASK", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Modifier_Type,
        (long) Qt::UNICODE_ACCEL, "UNICODE_ACCEL");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UNICODE_ACCEL", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Modifier_Type.tp_dict,
        "UNICODE_ACCEL", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::Modifier");

    // init enum class: TileRule
    SbkPySide_QtCoreTypes[SBK_QT_TILERULE_IDX] = &SbkPySide_QtCore_Qt_TileRule_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TileRule_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TileRule_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TileRule",((PyObject*)&SbkPySide_QtCore_Qt_TileRule_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TileRule_Type,
        (long) Qt::StretchTile, "StretchTile");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "StretchTile", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TileRule_Type.tp_dict,
        "StretchTile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TileRule_Type,
        (long) Qt::RepeatTile, "RepeatTile");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RepeatTile", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TileRule_Type.tp_dict,
        "RepeatTile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TileRule_Type,
        (long) Qt::RoundTile, "RoundTile");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RoundTile", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TileRule_Type.tp_dict,
        "RoundTile", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TileRule");

    // init enum class: WhiteSpaceMode
    SbkPySide_QtCoreTypes[SBK_QT_WHITESPACEMODE_IDX] = &SbkPySide_QtCore_Qt_WhiteSpaceMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WhiteSpaceMode",((PyObject*)&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type,
        (long) Qt::WhiteSpaceNormal, "WhiteSpaceNormal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhiteSpaceNormal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WhiteSpaceMode_Type.tp_dict,
        "WhiteSpaceNormal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type,
        (long) Qt::WhiteSpacePre, "WhiteSpacePre");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhiteSpacePre", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WhiteSpaceMode_Type.tp_dict,
        "WhiteSpacePre", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type,
        (long) Qt::WhiteSpaceNoWrap, "WhiteSpaceNoWrap");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhiteSpaceNoWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WhiteSpaceMode_Type.tp_dict,
        "WhiteSpaceNoWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WhiteSpaceMode_Type,
        (long) Qt::WhiteSpaceModeUndefined, "WhiteSpaceModeUndefined");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhiteSpaceModeUndefined", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WhiteSpaceMode_Type.tp_dict,
        "WhiteSpaceModeUndefined", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::WhiteSpaceMode");

    // init enum class: AspectRatioMode
    SbkPySide_QtCoreTypes[SBK_QT_ASPECTRATIOMODE_IDX] = &SbkPySide_QtCore_Qt_AspectRatioMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_AspectRatioMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_AspectRatioMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "AspectRatioMode",((PyObject*)&SbkPySide_QtCore_Qt_AspectRatioMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AspectRatioMode_Type,
        (long) Qt::IgnoreAspectRatio, "IgnoreAspectRatio");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "IgnoreAspectRatio", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AspectRatioMode_Type.tp_dict,
        "IgnoreAspectRatio", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AspectRatioMode_Type,
        (long) Qt::KeepAspectRatio, "KeepAspectRatio");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "KeepAspectRatio", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AspectRatioMode_Type.tp_dict,
        "KeepAspectRatio", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AspectRatioMode_Type,
        (long) Qt::KeepAspectRatioByExpanding, "KeepAspectRatioByExpanding");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "KeepAspectRatioByExpanding", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AspectRatioMode_Type.tp_dict,
        "KeepAspectRatioByExpanding", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::AspectRatioMode");

    // init enum class: SizeHint
    SbkPySide_QtCoreTypes[SBK_QT_SIZEHINT_IDX] = &SbkPySide_QtCore_Qt_SizeHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_SizeHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_SizeHint_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "SizeHint",((PyObject*)&SbkPySide_QtCore_Qt_SizeHint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeHint_Type,
        (long) Qt::MinimumSize, "MinimumSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MinimumSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeHint_Type.tp_dict,
        "MinimumSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeHint_Type,
        (long) Qt::PreferredSize, "PreferredSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PreferredSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeHint_Type.tp_dict,
        "PreferredSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeHint_Type,
        (long) Qt::MaximumSize, "MaximumSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MaximumSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeHint_Type.tp_dict,
        "MaximumSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeHint_Type,
        (long) Qt::MinimumDescent, "MinimumDescent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MinimumDescent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeHint_Type.tp_dict,
        "MinimumDescent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SizeHint_Type,
        (long) Qt::NSizeHints, "NSizeHints");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NSizeHints", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SizeHint_Type.tp_dict,
        "NSizeHints", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::SizeHint");

    // init enum class: AlignmentFlag
    SbkPySide_QtCoreTypes[SBK_QT_ALIGNMENTFLAG_IDX] = &SbkPySide_QtCore_Qt_AlignmentFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_AlignmentFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_AlignmentFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "AlignmentFlag",((PyObject*)&SbkPySide_QtCore_Qt_AlignmentFlag_Type));

    // init flags class: QFlags<Qt::AlignmentFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG__IDX] = &SbkPySide_QtCore_Qt_Alignment_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Alignment_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Alignment_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Alignment",((PyObject*)&SbkPySide_QtCore_Qt_Alignment_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignLeft, "AlignLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignLeading, "AlignLeading");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignLeading", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignLeading", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignRight, "AlignRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignTrailing, "AlignTrailing");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignTrailing", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignTrailing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignHCenter, "AlignHCenter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignHCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignHCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignJustify, "AlignJustify");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignJustify", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignJustify", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignAbsolute, "AlignAbsolute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignAbsolute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignAbsolute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignHorizontal_Mask, "AlignHorizontal_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignHorizontal_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignHorizontal_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignTop, "AlignTop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignBottom, "AlignBottom");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignBottom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignVCenter, "AlignVCenter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignVCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignVCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignVertical_Mask, "AlignVertical_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignVertical_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignVertical_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AlignmentFlag_Type,
        (long) Qt::AlignCenter, "AlignCenter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AlignCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AlignmentFlag_Type.tp_dict,
        "AlignCenter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::AlignmentFlag");

    // init enum class: ContextMenuPolicy
    SbkPySide_QtCoreTypes[SBK_QT_CONTEXTMENUPOLICY_IDX] = &SbkPySide_QtCore_Qt_ContextMenuPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ContextMenuPolicy",((PyObject*)&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type,
        (long) Qt::NoContextMenu, "NoContextMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ContextMenuPolicy_Type.tp_dict,
        "NoContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type,
        (long) Qt::DefaultContextMenu, "DefaultContextMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DefaultContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ContextMenuPolicy_Type.tp_dict,
        "DefaultContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type,
        (long) Qt::ActionsContextMenu, "ActionsContextMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ActionsContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ContextMenuPolicy_Type.tp_dict,
        "ActionsContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type,
        (long) Qt::CustomContextMenu, "CustomContextMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CustomContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ContextMenuPolicy_Type.tp_dict,
        "CustomContextMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ContextMenuPolicy_Type,
        (long) Qt::PreventContextMenu, "PreventContextMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PreventContextMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ContextMenuPolicy_Type.tp_dict,
        "PreventContextMenu", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ContextMenuPolicy");

    // init enum class: DockWidgetArea
    SbkPySide_QtCoreTypes[SBK_QT_DOCKWIDGETAREA_IDX] = &SbkPySide_QtCore_Qt_DockWidgetArea_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DockWidgetArea_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DockWidgetArea_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DockWidgetArea",((PyObject*)&SbkPySide_QtCore_Qt_DockWidgetArea_Type));

    // init flags class: QFlags<Qt::DockWidgetArea>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_DOCKWIDGETAREA__IDX] = &SbkPySide_QtCore_Qt_DockWidgetAreas_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DockWidgetAreas_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DockWidgetAreas_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DockWidgetAreas",((PyObject*)&SbkPySide_QtCore_Qt_DockWidgetAreas_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::LeftDockWidgetArea, "LeftDockWidgetArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LeftDockWidgetArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "LeftDockWidgetArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::RightDockWidgetArea, "RightDockWidgetArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RightDockWidgetArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "RightDockWidgetArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::TopDockWidgetArea, "TopDockWidgetArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopDockWidgetArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "TopDockWidgetArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::BottomDockWidgetArea, "BottomDockWidgetArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomDockWidgetArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "BottomDockWidgetArea", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::DockWidgetArea_Mask, "DockWidgetArea_Mask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DockWidgetArea_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "DockWidgetArea_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::AllDockWidgetAreas, "AllDockWidgetAreas");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AllDockWidgetAreas", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "AllDockWidgetAreas", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetArea_Type,
        (long) Qt::NoDockWidgetArea, "NoDockWidgetArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoDockWidgetArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetArea_Type.tp_dict,
        "NoDockWidgetArea", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::DockWidgetArea");

    // init enum class: UIEffect
    SbkPySide_QtCoreTypes[SBK_QT_UIEFFECT_IDX] = &SbkPySide_QtCore_Qt_UIEffect_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_UIEffect_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_UIEffect_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "UIEffect",((PyObject*)&SbkPySide_QtCore_Qt_UIEffect_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_General, "UI_General");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_General", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_General", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_AnimateMenu, "UI_AnimateMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_AnimateMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_AnimateMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_FadeMenu, "UI_FadeMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_FadeMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_FadeMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_AnimateCombo, "UI_AnimateCombo");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_AnimateCombo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_AnimateCombo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_AnimateTooltip, "UI_AnimateTooltip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_AnimateTooltip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_AnimateTooltip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_FadeTooltip, "UI_FadeTooltip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_FadeTooltip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_FadeTooltip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_UIEffect_Type,
        (long) Qt::UI_AnimateToolBox, "UI_AnimateToolBox");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UI_AnimateToolBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_UIEffect_Type.tp_dict,
        "UI_AnimateToolBox", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::UIEffect");

    // init enum class: Initialization
    SbkPySide_QtCoreTypes[SBK_QT_INITIALIZATION_IDX] = &SbkPySide_QtCore_Qt_Initialization_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Initialization_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Initialization_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Initialization",((PyObject*)&SbkPySide_QtCore_Qt_Initialization_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Initialization_Type,
        (long) Qt::Uninitialized, "Uninitialized");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Uninitialized", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Initialization_Type.tp_dict,
        "Uninitialized", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::Initialization");

    // init enum class: AnchorPoint
    SbkPySide_QtCoreTypes[SBK_QT_ANCHORPOINT_IDX] = &SbkPySide_QtCore_Qt_AnchorPoint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_AnchorPoint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_AnchorPoint_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "AnchorPoint",((PyObject*)&SbkPySide_QtCore_Qt_AnchorPoint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorPoint_Type,
        (long) Qt::AnchorLeft, "AnchorLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorPoint_Type.tp_dict,
        "AnchorLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorPoint_Type,
        (long) Qt::AnchorHorizontalCenter, "AnchorHorizontalCenter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorHorizontalCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorPoint_Type.tp_dict,
        "AnchorHorizontalCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorPoint_Type,
        (long) Qt::AnchorRight, "AnchorRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorPoint_Type.tp_dict,
        "AnchorRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorPoint_Type,
        (long) Qt::AnchorTop, "AnchorTop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorPoint_Type.tp_dict,
        "AnchorTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorPoint_Type,
        (long) Qt::AnchorVerticalCenter, "AnchorVerticalCenter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorVerticalCenter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorPoint_Type.tp_dict,
        "AnchorVerticalCenter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorPoint_Type,
        (long) Qt::AnchorBottom, "AnchorBottom");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorPoint_Type.tp_dict,
        "AnchorBottom", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::AnchorPoint");

    // init enum class: GlobalColor
    SbkPySide_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX] = &SbkPySide_QtCore_Qt_GlobalColor_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_GlobalColor_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_GlobalColor_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "GlobalColor",((PyObject*)&SbkPySide_QtCore_Qt_GlobalColor_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::color0, "color0");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "color0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "color0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::color1, "color1");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "color1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "color1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::black, "black");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "black", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "black", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::white, "white");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "white", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "white", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkGray, "darkGray");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkGray", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkGray", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::gray, "gray");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "gray", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "gray", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::lightGray, "lightGray");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "lightGray", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "lightGray", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::red, "red");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "red", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "red", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::green, "green");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "green", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "green", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::blue, "blue");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "blue", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "blue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::cyan, "cyan");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "cyan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "cyan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::magenta, "magenta");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "magenta", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "magenta", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::yellow, "yellow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "yellow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "yellow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkRed, "darkRed");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkRed", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkRed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkGreen, "darkGreen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkGreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkGreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkBlue, "darkBlue");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkBlue", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkBlue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkCyan, "darkCyan");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkCyan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkCyan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkMagenta, "darkMagenta");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkMagenta", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkMagenta", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::darkYellow, "darkYellow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "darkYellow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "darkYellow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_GlobalColor_Type,
        (long) Qt::transparent, "transparent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "transparent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_GlobalColor_Type.tp_dict,
        "transparent", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::GlobalColor");

    // init enum class: KeyboardModifier
    SbkPySide_QtCoreTypes[SBK_QT_KEYBOARDMODIFIER_IDX] = &SbkPySide_QtCore_Qt_KeyboardModifier_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_KeyboardModifier_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_KeyboardModifier_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "KeyboardModifier",((PyObject*)&SbkPySide_QtCore_Qt_KeyboardModifier_Type));

    // init flags class: QFlags<Qt::KeyboardModifier>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER__IDX] = &SbkPySide_QtCore_Qt_KeyboardModifiers_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_KeyboardModifiers_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_KeyboardModifiers_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "KeyboardModifiers",((PyObject*)&SbkPySide_QtCore_Qt_KeyboardModifiers_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::NoModifier, "NoModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "NoModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::ShiftModifier, "ShiftModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ShiftModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "ShiftModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::ControlModifier, "ControlModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ControlModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "ControlModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::AltModifier, "AltModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AltModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "AltModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::MetaModifier, "MetaModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MetaModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "MetaModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::KeypadModifier, "KeypadModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "KeypadModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "KeypadModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::GroupSwitchModifier, "GroupSwitchModifier");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "GroupSwitchModifier", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "GroupSwitchModifier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_KeyboardModifier_Type,
        (long) Qt::KeyboardModifierMask, "KeyboardModifierMask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "KeyboardModifierMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_KeyboardModifier_Type.tp_dict,
        "KeyboardModifierMask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::KeyboardModifier");

    // init enum class: NavigationMode
    SbkPySide_QtCoreTypes[SBK_QT_NAVIGATIONMODE_IDX] = &SbkPySide_QtCore_Qt_NavigationMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_NavigationMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_NavigationMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "NavigationMode",((PyObject*)&SbkPySide_QtCore_Qt_NavigationMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_NavigationMode_Type,
        (long) Qt::NavigationModeNone, "NavigationModeNone");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NavigationModeNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_NavigationMode_Type.tp_dict,
        "NavigationModeNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_NavigationMode_Type,
        (long) Qt::NavigationModeKeypadTabOrder, "NavigationModeKeypadTabOrder");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NavigationModeKeypadTabOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_NavigationMode_Type.tp_dict,
        "NavigationModeKeypadTabOrder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_NavigationMode_Type,
        (long) Qt::NavigationModeKeypadDirectional, "NavigationModeKeypadDirectional");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NavigationModeKeypadDirectional", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_NavigationMode_Type.tp_dict,
        "NavigationModeKeypadDirectional", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_NavigationMode_Type,
        (long) Qt::NavigationModeCursorAuto, "NavigationModeCursorAuto");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NavigationModeCursorAuto", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_NavigationMode_Type.tp_dict,
        "NavigationModeCursorAuto", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_NavigationMode_Type,
        (long) Qt::NavigationModeCursorForceVisible, "NavigationModeCursorForceVisible");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NavigationModeCursorForceVisible", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_NavigationMode_Type.tp_dict,
        "NavigationModeCursorForceVisible", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::NavigationMode");

    // init enum class: ItemDataRole
    SbkPySide_QtCoreTypes[SBK_QT_ITEMDATAROLE_IDX] = &SbkPySide_QtCore_Qt_ItemDataRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ItemDataRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ItemDataRole_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ItemDataRole",((PyObject*)&SbkPySide_QtCore_Qt_ItemDataRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::DisplayRole, "DisplayRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DisplayRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "DisplayRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::DecorationRole, "DecorationRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DecorationRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "DecorationRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::EditRole, "EditRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "EditRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "EditRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::ToolTipRole, "ToolTipRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolTipRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "ToolTipRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::StatusTipRole, "StatusTipRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "StatusTipRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "StatusTipRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::WhatsThisRole, "WhatsThisRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhatsThisRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "WhatsThisRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::FontRole, "FontRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "FontRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "FontRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::TextAlignmentRole, "TextAlignmentRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextAlignmentRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "TextAlignmentRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::BackgroundColorRole, "BackgroundColorRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BackgroundColorRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "BackgroundColorRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::BackgroundRole, "BackgroundRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BackgroundRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "BackgroundRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::TextColorRole, "TextColorRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextColorRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "TextColorRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::ForegroundRole, "ForegroundRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ForegroundRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "ForegroundRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::CheckStateRole, "CheckStateRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CheckStateRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "CheckStateRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::AccessibleTextRole, "AccessibleTextRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AccessibleTextRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "AccessibleTextRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::AccessibleDescriptionRole, "AccessibleDescriptionRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AccessibleDescriptionRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "AccessibleDescriptionRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::SizeHintRole, "SizeHintRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SizeHintRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "SizeHintRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::DisplayPropertyRole, "DisplayPropertyRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DisplayPropertyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "DisplayPropertyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::DecorationPropertyRole, "DecorationPropertyRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DecorationPropertyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "DecorationPropertyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::ToolTipPropertyRole, "ToolTipPropertyRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolTipPropertyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "ToolTipPropertyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::StatusTipPropertyRole, "StatusTipPropertyRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "StatusTipPropertyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "StatusTipPropertyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::WhatsThisPropertyRole, "WhatsThisPropertyRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhatsThisPropertyRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "WhatsThisPropertyRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemDataRole_Type,
        (long) Qt::UserRole, "UserRole");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UserRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemDataRole_Type.tp_dict,
        "UserRole", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ItemDataRole");

    // init enum class: ScrollBarPolicy
    SbkPySide_QtCoreTypes[SBK_QT_SCROLLBARPOLICY_IDX] = &SbkPySide_QtCore_Qt_ScrollBarPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ScrollBarPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ScrollBarPolicy_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ScrollBarPolicy",((PyObject*)&SbkPySide_QtCore_Qt_ScrollBarPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ScrollBarPolicy_Type,
        (long) Qt::ScrollBarAsNeeded, "ScrollBarAsNeeded");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ScrollBarAsNeeded", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ScrollBarPolicy_Type.tp_dict,
        "ScrollBarAsNeeded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ScrollBarPolicy_Type,
        (long) Qt::ScrollBarAlwaysOff, "ScrollBarAlwaysOff");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ScrollBarAlwaysOff", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ScrollBarPolicy_Type.tp_dict,
        "ScrollBarAlwaysOff", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ScrollBarPolicy_Type,
        (long) Qt::ScrollBarAlwaysOn, "ScrollBarAlwaysOn");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ScrollBarAlwaysOn", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ScrollBarPolicy_Type.tp_dict,
        "ScrollBarAlwaysOn", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ScrollBarPolicy");

    // init enum class: InputMethodHint
    SbkPySide_QtCoreTypes[SBK_QT_INPUTMETHODHINT_IDX] = &SbkPySide_QtCore_Qt_InputMethodHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_InputMethodHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_InputMethodHint_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "InputMethodHint",((PyObject*)&SbkPySide_QtCore_Qt_InputMethodHint_Type));

    // init flags class: QFlags<Qt::InputMethodHint>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODHINT__IDX] = &SbkPySide_QtCore_Qt_InputMethodHints_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_InputMethodHints_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_InputMethodHints_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "InputMethodHints",((PyObject*)&SbkPySide_QtCore_Qt_InputMethodHints_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhNone, "ImhNone");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhHiddenText, "ImhHiddenText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhHiddenText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhHiddenText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhNoAutoUppercase, "ImhNoAutoUppercase");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhNoAutoUppercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhNoAutoUppercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhPreferNumbers, "ImhPreferNumbers");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhPreferNumbers", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhPreferNumbers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhPreferUppercase, "ImhPreferUppercase");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhPreferUppercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhPreferUppercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhPreferLowercase, "ImhPreferLowercase");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhPreferLowercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhPreferLowercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhNoPredictiveText, "ImhNoPredictiveText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhNoPredictiveText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhNoPredictiveText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhDigitsOnly, "ImhDigitsOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhDigitsOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhDigitsOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhFormattedNumbersOnly, "ImhFormattedNumbersOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhFormattedNumbersOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhFormattedNumbersOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhUppercaseOnly, "ImhUppercaseOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhUppercaseOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhUppercaseOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhLowercaseOnly, "ImhLowercaseOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhLowercaseOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhLowercaseOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhDialableCharactersOnly, "ImhDialableCharactersOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhDialableCharactersOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhDialableCharactersOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhEmailCharactersOnly, "ImhEmailCharactersOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhEmailCharactersOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhEmailCharactersOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhUrlCharactersOnly, "ImhUrlCharactersOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhUrlCharactersOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhUrlCharactersOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodHint_Type,
        (long) Qt::ImhExclusiveInputMask, "ImhExclusiveInputMask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImhExclusiveInputMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodHint_Type.tp_dict,
        "ImhExclusiveInputMask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::InputMethodHint");

    // init enum class: AnchorAttribute
    SbkPySide_QtCoreTypes[SBK_QT_ANCHORATTRIBUTE_IDX] = &SbkPySide_QtCore_Qt_AnchorAttribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_AnchorAttribute_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_AnchorAttribute_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "AnchorAttribute",((PyObject*)&SbkPySide_QtCore_Qt_AnchorAttribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorAttribute_Type,
        (long) Qt::AnchorName, "AnchorName");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorName", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorAttribute_Type.tp_dict,
        "AnchorName", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_AnchorAttribute_Type,
        (long) Qt::AnchorHref, "AnchorHref");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AnchorHref", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_AnchorAttribute_Type.tp_dict,
        "AnchorHref", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::AnchorAttribute");

    // init enum class: WindowModality
    SbkPySide_QtCoreTypes[SBK_QT_WINDOWMODALITY_IDX] = &SbkPySide_QtCore_Qt_WindowModality_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WindowModality_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WindowModality_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WindowModality",((PyObject*)&SbkPySide_QtCore_Qt_WindowModality_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowModality_Type,
        (long) Qt::NonModal, "NonModal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NonModal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowModality_Type.tp_dict,
        "NonModal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowModality_Type,
        (long) Qt::WindowModal, "WindowModal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowModal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowModality_Type.tp_dict,
        "WindowModal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowModality_Type,
        (long) Qt::ApplicationModal, "ApplicationModal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ApplicationModal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowModality_Type.tp_dict,
        "ApplicationModal", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::WindowModality");

    // init enum class: SortOrder
    SbkPySide_QtCoreTypes[SBK_QT_SORTORDER_IDX] = &SbkPySide_QtCore_Qt_SortOrder_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_SortOrder_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_SortOrder_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "SortOrder",((PyObject*)&SbkPySide_QtCore_Qt_SortOrder_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SortOrder_Type,
        (long) Qt::AscendingOrder, "AscendingOrder");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AscendingOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SortOrder_Type.tp_dict,
        "AscendingOrder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_SortOrder_Type,
        (long) Qt::DescendingOrder, "DescendingOrder");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DescendingOrder", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_SortOrder_Type.tp_dict,
        "DescendingOrder", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::SortOrder");

    // init enum class: PenStyle
    SbkPySide_QtCoreTypes[SBK_QT_PENSTYLE_IDX] = &SbkPySide_QtCore_Qt_PenStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_PenStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_PenStyle_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "PenStyle",((PyObject*)&SbkPySide_QtCore_Qt_PenStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::NoPen, "NoPen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoPen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "NoPen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::SolidLine, "SolidLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SolidLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "SolidLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::DashLine, "DashLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DashLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "DashLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::DotLine, "DotLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DotLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "DotLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::DashDotLine, "DashDotLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DashDotLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "DashDotLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::DashDotDotLine, "DashDotDotLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DashDotDotLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "DashDotDotLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::CustomDashLine, "CustomDashLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CustomDashLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "CustomDashLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenStyle_Type,
        (long) Qt::MPenStyle, "MPenStyle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MPenStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenStyle_Type.tp_dict,
        "MPenStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::PenStyle");

    // init enum class: ItemFlag
    SbkPySide_QtCoreTypes[SBK_QT_ITEMFLAG_IDX] = &SbkPySide_QtCore_Qt_ItemFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ItemFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ItemFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ItemFlag",((PyObject*)&SbkPySide_QtCore_Qt_ItemFlag_Type));

    // init flags class: QFlags<Qt::ItemFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ITEMFLAG__IDX] = &SbkPySide_QtCore_Qt_ItemFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ItemFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ItemFlags_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ItemFlags",((PyObject*)&SbkPySide_QtCore_Qt_ItemFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::NoItemFlags, "NoItemFlags");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoItemFlags", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "NoItemFlags", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsSelectable, "ItemIsSelectable");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsSelectable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsSelectable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsEditable, "ItemIsEditable");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsEditable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsEditable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsDragEnabled, "ItemIsDragEnabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsDragEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsDragEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsDropEnabled, "ItemIsDropEnabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsDropEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsDropEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsUserCheckable, "ItemIsUserCheckable");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsUserCheckable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsUserCheckable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsEnabled, "ItemIsEnabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemFlag_Type,
        (long) Qt::ItemIsTristate, "ItemIsTristate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ItemIsTristate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemFlag_Type.tp_dict,
        "ItemIsTristate", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ItemFlag");

    // init enum class: Axis
    SbkPySide_QtCoreTypes[SBK_QT_AXIS_IDX] = &SbkPySide_QtCore_Qt_Axis_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Axis_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Axis_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Axis",((PyObject*)&SbkPySide_QtCore_Qt_Axis_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Axis_Type,
        (long) Qt::XAxis, "XAxis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "XAxis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Axis_Type.tp_dict,
        "XAxis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Axis_Type,
        (long) Qt::YAxis, "YAxis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "YAxis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Axis_Type.tp_dict,
        "YAxis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Axis_Type,
        (long) Qt::ZAxis, "ZAxis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ZAxis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Axis_Type.tp_dict,
        "ZAxis", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::Axis");

    // init enum class: TransformationMode
    SbkPySide_QtCoreTypes[SBK_QT_TRANSFORMATIONMODE_IDX] = &SbkPySide_QtCore_Qt_TransformationMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TransformationMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TransformationMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TransformationMode",((PyObject*)&SbkPySide_QtCore_Qt_TransformationMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TransformationMode_Type,
        (long) Qt::FastTransformation, "FastTransformation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "FastTransformation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TransformationMode_Type.tp_dict,
        "FastTransformation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TransformationMode_Type,
        (long) Qt::SmoothTransformation, "SmoothTransformation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SmoothTransformation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TransformationMode_Type.tp_dict,
        "SmoothTransformation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TransformationMode");

    // init enum class: WindowFrameSection
    SbkPySide_QtCoreTypes[SBK_QT_WINDOWFRAMESECTION_IDX] = &SbkPySide_QtCore_Qt_WindowFrameSection_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WindowFrameSection_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WindowFrameSection_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WindowFrameSection",((PyObject*)&SbkPySide_QtCore_Qt_WindowFrameSection_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::NoSection, "NoSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "NoSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::LeftSection, "LeftSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LeftSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "LeftSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::TopLeftSection, "TopLeftSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopLeftSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "TopLeftSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::TopSection, "TopSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "TopSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::TopRightSection, "TopRightSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopRightSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "TopRightSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::RightSection, "RightSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RightSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "RightSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::BottomRightSection, "BottomRightSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomRightSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "BottomRightSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::BottomSection, "BottomSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "BottomSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::BottomLeftSection, "BottomLeftSection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomLeftSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "BottomLeftSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowFrameSection_Type,
        (long) Qt::TitleBarArea, "TitleBarArea");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TitleBarArea", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowFrameSection_Type.tp_dict,
        "TitleBarArea", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::WindowFrameSection");

    // init enum class: HitTestAccuracy
    SbkPySide_QtCoreTypes[SBK_QT_HITTESTACCURACY_IDX] = &SbkPySide_QtCore_Qt_HitTestAccuracy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_HitTestAccuracy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_HitTestAccuracy_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "HitTestAccuracy",((PyObject*)&SbkPySide_QtCore_Qt_HitTestAccuracy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_HitTestAccuracy_Type,
        (long) Qt::ExactHit, "ExactHit");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ExactHit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_HitTestAccuracy_Type.tp_dict,
        "ExactHit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_HitTestAccuracy_Type,
        (long) Qt::FuzzyHit, "FuzzyHit");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "FuzzyHit", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_HitTestAccuracy_Type.tp_dict,
        "FuzzyHit", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::HitTestAccuracy");

    // init enum class: CursorShape
    SbkPySide_QtCoreTypes[SBK_QT_CURSORSHAPE_IDX] = &SbkPySide_QtCore_Qt_CursorShape_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_CursorShape_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_CursorShape_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "CursorShape",((PyObject*)&SbkPySide_QtCore_Qt_CursorShape_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::ArrowCursor, "ArrowCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ArrowCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "ArrowCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::UpArrowCursor, "UpArrowCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UpArrowCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "UpArrowCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::CrossCursor, "CrossCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CrossCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "CrossCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::WaitCursor, "WaitCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WaitCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "WaitCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::IBeamCursor, "IBeamCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "IBeamCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "IBeamCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SizeVerCursor, "SizeVerCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SizeVerCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SizeVerCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SizeHorCursor, "SizeHorCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SizeHorCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SizeHorCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SizeBDiagCursor, "SizeBDiagCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SizeBDiagCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SizeBDiagCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SizeFDiagCursor, "SizeFDiagCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SizeFDiagCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SizeFDiagCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SizeAllCursor, "SizeAllCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SizeAllCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SizeAllCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::BlankCursor, "BlankCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BlankCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "BlankCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SplitVCursor, "SplitVCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SplitVCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SplitVCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::SplitHCursor, "SplitHCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SplitHCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "SplitHCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::PointingHandCursor, "PointingHandCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "PointingHandCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "PointingHandCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::ForbiddenCursor, "ForbiddenCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ForbiddenCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "ForbiddenCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::WhatsThisCursor, "WhatsThisCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WhatsThisCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "WhatsThisCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::BusyCursor, "BusyCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BusyCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "BusyCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::OpenHandCursor, "OpenHandCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OpenHandCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "OpenHandCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::ClosedHandCursor, "ClosedHandCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ClosedHandCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "ClosedHandCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::LastCursor, "LastCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LastCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "LastCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::BitmapCursor, "BitmapCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BitmapCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "BitmapCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_CursorShape_Type,
        (long) Qt::CustomCursor, "CustomCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CustomCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_CursorShape_Type.tp_dict,
        "CustomCursor", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::CursorShape");

    // init enum class: ItemSelectionMode
    SbkPySide_QtCoreTypes[SBK_QT_ITEMSELECTIONMODE_IDX] = &SbkPySide_QtCore_Qt_ItemSelectionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ItemSelectionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ItemSelectionMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ItemSelectionMode",((PyObject*)&SbkPySide_QtCore_Qt_ItemSelectionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemSelectionMode_Type,
        (long) Qt::ContainsItemShape, "ContainsItemShape");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ContainsItemShape", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemSelectionMode_Type.tp_dict,
        "ContainsItemShape", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemSelectionMode_Type,
        (long) Qt::IntersectsItemShape, "IntersectsItemShape");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "IntersectsItemShape", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemSelectionMode_Type.tp_dict,
        "IntersectsItemShape", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemSelectionMode_Type,
        (long) Qt::ContainsItemBoundingRect, "ContainsItemBoundingRect");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ContainsItemBoundingRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemSelectionMode_Type.tp_dict,
        "ContainsItemBoundingRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ItemSelectionMode_Type,
        (long) Qt::IntersectsItemBoundingRect, "IntersectsItemBoundingRect");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "IntersectsItemBoundingRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ItemSelectionMode_Type.tp_dict,
        "IntersectsItemBoundingRect", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ItemSelectionMode");

    // init enum class: Orientation
    SbkPySide_QtCoreTypes[SBK_QT_ORIENTATION_IDX] = &SbkPySide_QtCore_Qt_Orientation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Orientation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Orientation_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Orientation",((PyObject*)&SbkPySide_QtCore_Qt_Orientation_Type));

    // init flags class: QFlags<Qt::Orientation>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION__IDX] = &SbkPySide_QtCore_Qt_Orientations_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Orientations_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Orientations_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Orientations",((PyObject*)&SbkPySide_QtCore_Qt_Orientations_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Orientation_Type,
        (long) Qt::Horizontal, "Horizontal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Horizontal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Orientation_Type.tp_dict,
        "Horizontal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Orientation_Type,
        (long) Qt::Vertical, "Vertical");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Vertical", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Orientation_Type.tp_dict,
        "Vertical", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::Orientation");

    // init enum class: InputMethodQuery
    SbkPySide_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX] = &SbkPySide_QtCore_Qt_InputMethodQuery_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_InputMethodQuery_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_InputMethodQuery_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "InputMethodQuery",((PyObject*)&SbkPySide_QtCore_Qt_InputMethodQuery_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImMicroFocus, "ImMicroFocus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImMicroFocus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImMicroFocus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImFont, "ImFont");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImCursorPosition, "ImCursorPosition");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImCursorPosition", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImCursorPosition", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImSurroundingText, "ImSurroundingText");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImSurroundingText", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImSurroundingText", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImCurrentSelection, "ImCurrentSelection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImCurrentSelection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImCurrentSelection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImMaximumTextLength, "ImMaximumTextLength");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImMaximumTextLength", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImMaximumTextLength", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_InputMethodQuery_Type,
        (long) Qt::ImAnchorPosition, "ImAnchorPosition");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ImAnchorPosition", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_InputMethodQuery_Type.tp_dict,
        "ImAnchorPosition", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::InputMethodQuery");

    // init enum class: TimeSpec
    SbkPySide_QtCoreTypes[SBK_QT_TIMESPEC_IDX] = &SbkPySide_QtCore_Qt_TimeSpec_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TimeSpec_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TimeSpec_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TimeSpec",((PyObject*)&SbkPySide_QtCore_Qt_TimeSpec_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TimeSpec_Type,
        (long) Qt::LocalTime, "LocalTime");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LocalTime", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TimeSpec_Type.tp_dict,
        "LocalTime", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TimeSpec_Type,
        (long) Qt::UTC, "UTC");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UTC", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TimeSpec_Type.tp_dict,
        "UTC", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TimeSpec_Type,
        (long) Qt::OffsetFromUTC, "OffsetFromUTC");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OffsetFromUTC", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TimeSpec_Type.tp_dict,
        "OffsetFromUTC", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TimeSpec");

    // init enum class: ArrowType
    SbkPySide_QtCoreTypes[SBK_QT_ARROWTYPE_IDX] = &SbkPySide_QtCore_Qt_ArrowType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ArrowType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ArrowType_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ArrowType",((PyObject*)&SbkPySide_QtCore_Qt_ArrowType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ArrowType_Type,
        (long) Qt::NoArrow, "NoArrow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ArrowType_Type.tp_dict,
        "NoArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ArrowType_Type,
        (long) Qt::UpArrow, "UpArrow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UpArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ArrowType_Type.tp_dict,
        "UpArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ArrowType_Type,
        (long) Qt::DownArrow, "DownArrow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DownArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ArrowType_Type.tp_dict,
        "DownArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ArrowType_Type,
        (long) Qt::LeftArrow, "LeftArrow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LeftArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ArrowType_Type.tp_dict,
        "LeftArrow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ArrowType_Type,
        (long) Qt::RightArrow, "RightArrow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RightArrow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ArrowType_Type.tp_dict,
        "RightArrow", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ArrowType");

    // init enum class: FillRule
    SbkPySide_QtCoreTypes[SBK_QT_FILLRULE_IDX] = &SbkPySide_QtCore_Qt_FillRule_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_FillRule_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_FillRule_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "FillRule",((PyObject*)&SbkPySide_QtCore_Qt_FillRule_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FillRule_Type,
        (long) Qt::OddEvenFill, "OddEvenFill");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "OddEvenFill", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FillRule_Type.tp_dict,
        "OddEvenFill", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_FillRule_Type,
        (long) Qt::WindingFill, "WindingFill");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindingFill", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_FillRule_Type.tp_dict,
        "WindingFill", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::FillRule");

    // init enum class: MaskMode
    SbkPySide_QtCoreTypes[SBK_QT_MASKMODE_IDX] = &SbkPySide_QtCore_Qt_MaskMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_MaskMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_MaskMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "MaskMode",((PyObject*)&SbkPySide_QtCore_Qt_MaskMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MaskMode_Type,
        (long) Qt::MaskInColor, "MaskInColor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MaskInColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MaskMode_Type.tp_dict,
        "MaskInColor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MaskMode_Type,
        (long) Qt::MaskOutColor, "MaskOutColor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MaskOutColor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MaskMode_Type.tp_dict,
        "MaskOutColor", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::MaskMode");

    // init enum class: WindowState
    SbkPySide_QtCoreTypes[SBK_QT_WINDOWSTATE_IDX] = &SbkPySide_QtCore_Qt_WindowState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WindowState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WindowState_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WindowState",((PyObject*)&SbkPySide_QtCore_Qt_WindowState_Type));

    // init flags class: QFlags<Qt::WindowState>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_WINDOWSTATE__IDX] = &SbkPySide_QtCore_Qt_WindowStates_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WindowStates_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WindowStates_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WindowStates",((PyObject*)&SbkPySide_QtCore_Qt_WindowStates_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowState_Type,
        (long) Qt::WindowNoState, "WindowNoState");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowNoState", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowState_Type.tp_dict,
        "WindowNoState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowState_Type,
        (long) Qt::WindowMinimized, "WindowMinimized");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowMinimized", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowState_Type.tp_dict,
        "WindowMinimized", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowState_Type,
        (long) Qt::WindowMaximized, "WindowMaximized");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowMaximized", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowState_Type.tp_dict,
        "WindowMaximized", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowState_Type,
        (long) Qt::WindowFullScreen, "WindowFullScreen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowFullScreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowState_Type.tp_dict,
        "WindowFullScreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WindowState_Type,
        (long) Qt::WindowActive, "WindowActive");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WindowActive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WindowState_Type.tp_dict,
        "WindowActive", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::WindowState");

    // init enum class: ToolBarAreaSizes
    SbkPySide_QtCoreTypes[SBK_QT_TOOLBARAREASIZES_IDX] = &SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ToolBarAreaSizes",((PyObject*)&SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type,
        (long) Qt::NToolBarAreas, "NToolBarAreas");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NToolBarAreas", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolBarAreaSizes_Type.tp_dict,
        "NToolBarAreas", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ToolBarAreaSizes");

    // init enum class: Corner
    SbkPySide_QtCoreTypes[SBK_QT_CORNER_IDX] = &SbkPySide_QtCore_Qt_Corner_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Corner_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Corner_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Corner",((PyObject*)&SbkPySide_QtCore_Qt_Corner_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Corner_Type,
        (long) Qt::TopLeftCorner, "TopLeftCorner");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopLeftCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Corner_Type.tp_dict,
        "TopLeftCorner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Corner_Type,
        (long) Qt::TopRightCorner, "TopRightCorner");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TopRightCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Corner_Type.tp_dict,
        "TopRightCorner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Corner_Type,
        (long) Qt::BottomLeftCorner, "BottomLeftCorner");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomLeftCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Corner_Type.tp_dict,
        "BottomLeftCorner", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Corner_Type,
        (long) Qt::BottomRightCorner, "BottomRightCorner");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BottomRightCorner", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Corner_Type.tp_dict,
        "BottomRightCorner", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::Corner");

    // init enum class: DayOfWeek
    SbkPySide_QtCoreTypes[SBK_QT_DAYOFWEEK_IDX] = &SbkPySide_QtCore_Qt_DayOfWeek_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DayOfWeek_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DayOfWeek_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DayOfWeek",((PyObject*)&SbkPySide_QtCore_Qt_DayOfWeek_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Monday, "Monday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Monday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Monday", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Tuesday, "Tuesday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Tuesday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Tuesday", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Wednesday, "Wednesday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Wednesday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Wednesday", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Thursday, "Thursday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Thursday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Thursday", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Friday, "Friday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Friday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Friday", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Saturday, "Saturday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Saturday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Saturday", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DayOfWeek_Type,
        (long) Qt::Sunday, "Sunday");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Sunday", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DayOfWeek_Type.tp_dict,
        "Sunday", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::DayOfWeek");

    // init enum class: ClipOperation
    SbkPySide_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX] = &SbkPySide_QtCore_Qt_ClipOperation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ClipOperation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ClipOperation_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ClipOperation",((PyObject*)&SbkPySide_QtCore_Qt_ClipOperation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ClipOperation_Type,
        (long) Qt::NoClip, "NoClip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoClip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ClipOperation_Type.tp_dict,
        "NoClip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ClipOperation_Type,
        (long) Qt::ReplaceClip, "ReplaceClip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ReplaceClip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ClipOperation_Type.tp_dict,
        "ReplaceClip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ClipOperation_Type,
        (long) Qt::IntersectClip, "IntersectClip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "IntersectClip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ClipOperation_Type.tp_dict,
        "IntersectClip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ClipOperation_Type,
        (long) Qt::UniteClip, "UniteClip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "UniteClip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ClipOperation_Type.tp_dict,
        "UniteClip", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ClipOperation");

    // init enum class: LayoutDirection
    SbkPySide_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX] = &SbkPySide_QtCore_Qt_LayoutDirection_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_LayoutDirection_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_LayoutDirection_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "LayoutDirection",((PyObject*)&SbkPySide_QtCore_Qt_LayoutDirection_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_LayoutDirection_Type,
        (long) Qt::LeftToRight, "LeftToRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LeftToRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_LayoutDirection_Type.tp_dict,
        "LeftToRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_LayoutDirection_Type,
        (long) Qt::RightToLeft, "RightToLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RightToLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_LayoutDirection_Type.tp_dict,
        "RightToLeft", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::LayoutDirection");

    // init enum class: ToolButtonStyle
    SbkPySide_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX] = &SbkPySide_QtCore_Qt_ToolButtonStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ToolButtonStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ToolButtonStyle_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ToolButtonStyle",((PyObject*)&SbkPySide_QtCore_Qt_ToolButtonStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolButtonStyle_Type,
        (long) Qt::ToolButtonIconOnly, "ToolButtonIconOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolButtonIconOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolButtonStyle_Type.tp_dict,
        "ToolButtonIconOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolButtonStyle_Type,
        (long) Qt::ToolButtonTextOnly, "ToolButtonTextOnly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolButtonTextOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolButtonStyle_Type.tp_dict,
        "ToolButtonTextOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolButtonStyle_Type,
        (long) Qt::ToolButtonTextBesideIcon, "ToolButtonTextBesideIcon");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolButtonTextBesideIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolButtonStyle_Type.tp_dict,
        "ToolButtonTextBesideIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolButtonStyle_Type,
        (long) Qt::ToolButtonTextUnderIcon, "ToolButtonTextUnderIcon");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolButtonTextUnderIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolButtonStyle_Type.tp_dict,
        "ToolButtonTextUnderIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ToolButtonStyle_Type,
        (long) Qt::ToolButtonFollowStyle, "ToolButtonFollowStyle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ToolButtonFollowStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ToolButtonStyle_Type.tp_dict,
        "ToolButtonFollowStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ToolButtonStyle");

    // init enum class: DockWidgetAreaSizes
    SbkPySide_QtCoreTypes[SBK_QT_DOCKWIDGETAREASIZES_IDX] = &SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "DockWidgetAreaSizes",((PyObject*)&SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type,
        (long) Qt::NDockWidgetAreas, "NDockWidgetAreas");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NDockWidgetAreas", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_DockWidgetAreaSizes_Type.tp_dict,
        "NDockWidgetAreas", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::DockWidgetAreaSizes");

    // init enum class: Key
    SbkPySide_QtCoreTypes[SBK_QT_KEY_IDX] = &SbkPySide_QtCore_Qt_Key_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_Key_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_Key_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "Key",((PyObject*)&SbkPySide_QtCore_Qt_Key_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Escape, "Key_Escape");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Escape", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Escape", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Tab, "Key_Tab");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Tab", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Tab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Backtab, "Key_Backtab");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Backtab", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Backtab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Backspace, "Key_Backspace");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Backspace", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Backspace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Return, "Key_Return");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Return", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Return", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Enter, "Key_Enter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Enter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Enter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Insert, "Key_Insert");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Insert", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Insert", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Delete, "Key_Delete");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Delete", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Delete", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Pause, "Key_Pause");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Pause", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Pause", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Print, "Key_Print");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Print", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Print", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_SysReq, "Key_SysReq");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_SysReq", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_SysReq", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Clear, "Key_Clear");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Clear", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Clear", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Home, "Key_Home");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Home", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Home", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_End, "Key_End");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_End", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Left, "Key_Left");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Left", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Left", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Up, "Key_Up");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Up", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Up", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Right, "Key_Right");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Right", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Right", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Down, "Key_Down");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Down", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Down", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_PageUp, "Key_PageUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_PageUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_PageUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_PageDown, "Key_PageDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_PageDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_PageDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Shift, "Key_Shift");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Shift", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Shift", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Control, "Key_Control");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Control", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Control", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Meta, "Key_Meta");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Meta", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Meta", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Alt, "Key_Alt");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Alt", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Alt", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_CapsLock, "Key_CapsLock");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_CapsLock", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_CapsLock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_NumLock, "Key_NumLock");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_NumLock", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_NumLock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ScrollLock, "Key_ScrollLock");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ScrollLock", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ScrollLock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F1, "Key_F1");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F2, "Key_F2");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F3, "Key_F3");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F4, "Key_F4");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F5, "Key_F5");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F5", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F6, "Key_F6");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F6", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F7, "Key_F7");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F7", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F7", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F8, "Key_F8");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F8", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F9, "Key_F9");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F9", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F9", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F10, "Key_F10");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F10", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F10", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F11, "Key_F11");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F11", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F11", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F12, "Key_F12");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F12", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F12", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F13, "Key_F13");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F13", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F13", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F14, "Key_F14");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F14", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F14", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F15, "Key_F15");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F15", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F15", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F16, "Key_F16");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F16", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F16", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F17, "Key_F17");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F17", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F17", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F18, "Key_F18");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F18", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F18", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F19, "Key_F19");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F19", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F19", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F20, "Key_F20");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F20", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F20", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F21, "Key_F21");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F21", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F21", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F22, "Key_F22");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F22", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F22", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F23, "Key_F23");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F23", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F23", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F24, "Key_F24");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F24", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F24", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F25, "Key_F25");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F25", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F25", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F26, "Key_F26");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F26", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F26", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F27, "Key_F27");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F27", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F27", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F28, "Key_F28");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F28", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F28", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F29, "Key_F29");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F29", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F29", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F30, "Key_F30");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F30", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F30", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F31, "Key_F31");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F31", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F31", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F32, "Key_F32");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F32", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F32", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F33, "Key_F33");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F33", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F33", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F34, "Key_F34");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F34", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F34", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F35, "Key_F35");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F35", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F35", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Super_L, "Key_Super_L");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Super_L", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Super_L", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Super_R, "Key_Super_R");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Super_R", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Super_R", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Menu, "Key_Menu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Menu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Menu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hyper_L, "Key_Hyper_L");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hyper_L", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hyper_L", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hyper_R, "Key_Hyper_R");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hyper_R", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hyper_R", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Help, "Key_Help");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Help", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Help", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Direction_L, "Key_Direction_L");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Direction_L", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Direction_L", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Direction_R, "Key_Direction_R");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Direction_R", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Direction_R", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Space, "Key_Space");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Space", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Space", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Any, "Key_Any");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Any", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Any", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Exclam, "Key_Exclam");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Exclam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Exclam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_QuoteDbl, "Key_QuoteDbl");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_QuoteDbl", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_QuoteDbl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_NumberSign, "Key_NumberSign");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_NumberSign", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_NumberSign", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dollar, "Key_Dollar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dollar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dollar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Percent, "Key_Percent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Percent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Percent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ampersand, "Key_Ampersand");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ampersand", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ampersand", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Apostrophe, "Key_Apostrophe");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Apostrophe", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Apostrophe", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ParenLeft, "Key_ParenLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ParenLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ParenLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ParenRight, "Key_ParenRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ParenRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ParenRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Asterisk, "Key_Asterisk");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Asterisk", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Asterisk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Plus, "Key_Plus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Plus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Plus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Comma, "Key_Comma");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Comma", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Comma", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Minus, "Key_Minus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Minus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Minus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Period, "Key_Period");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Period", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Period", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Slash, "Key_Slash");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Slash", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Slash", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_0, "Key_0");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_1, "Key_1");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_2, "Key_2");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_3, "Key_3");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_4, "Key_4");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_5, "Key_5");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_5", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_6, "Key_6");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_6", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_7, "Key_7");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_7", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_7", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_8, "Key_8");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_8", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_9, "Key_9");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_9", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_9", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Colon, "Key_Colon");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Colon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Colon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Semicolon, "Key_Semicolon");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Semicolon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Semicolon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Less, "Key_Less");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Less", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Less", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Equal, "Key_Equal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Equal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Equal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Greater, "Key_Greater");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Greater", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Greater", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Question, "Key_Question");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Question", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Question", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_At, "Key_At");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_At", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_At", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_A, "Key_A");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_A", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_A", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_B, "Key_B");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_B", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_B", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_C, "Key_C");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_C", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_C", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_D, "Key_D");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_D", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_D", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_E, "Key_E");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_E", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_E", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_F, "Key_F");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_F", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_F", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_G, "Key_G");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_G", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_G", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_H, "Key_H");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_H", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_H", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_I, "Key_I");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_I", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_I", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_J, "Key_J");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_J", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_J", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_K, "Key_K");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_K", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_K", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_L, "Key_L");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_L", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_L", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_M, "Key_M");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_M", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_M", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_N, "Key_N");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_N", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_N", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_O, "Key_O");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_O", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_O", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_P, "Key_P");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_P", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_P", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Q, "Key_Q");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Q", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Q", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_R, "Key_R");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_R", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_R", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_S, "Key_S");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_S", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_S", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_T, "Key_T");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_T", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_T", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_U, "Key_U");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_U", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_U", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_V, "Key_V");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_V", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_V", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_W, "Key_W");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_W", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_W", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_X, "Key_X");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_X", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_X", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Y, "Key_Y");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Y", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Y", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Z, "Key_Z");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Z", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Z", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BracketLeft, "Key_BracketLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BracketLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BracketLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Backslash, "Key_Backslash");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Backslash", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Backslash", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BracketRight, "Key_BracketRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BracketRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BracketRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AsciiCircum, "Key_AsciiCircum");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AsciiCircum", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AsciiCircum", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Underscore, "Key_Underscore");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Underscore", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Underscore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_QuoteLeft, "Key_QuoteLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_QuoteLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_QuoteLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BraceLeft, "Key_BraceLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BraceLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BraceLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Bar, "Key_Bar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Bar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Bar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BraceRight, "Key_BraceRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BraceRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BraceRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AsciiTilde, "Key_AsciiTilde");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AsciiTilde", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AsciiTilde", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_nobreakspace, "Key_nobreakspace");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_nobreakspace", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_nobreakspace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_exclamdown, "Key_exclamdown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_exclamdown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_exclamdown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_cent, "Key_cent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_cent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_cent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_sterling, "Key_sterling");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_sterling", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_sterling", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_currency, "Key_currency");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_currency", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_currency", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_yen, "Key_yen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_yen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_yen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_brokenbar, "Key_brokenbar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_brokenbar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_brokenbar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_section, "Key_section");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_section", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_section", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_diaeresis, "Key_diaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_diaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_diaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_copyright, "Key_copyright");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_copyright", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_copyright", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ordfeminine, "Key_ordfeminine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ordfeminine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ordfeminine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_guillemotleft, "Key_guillemotleft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_guillemotleft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_guillemotleft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_notsign, "Key_notsign");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_notsign", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_notsign", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_hyphen, "Key_hyphen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_hyphen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_hyphen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_registered, "Key_registered");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_registered", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_registered", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_macron, "Key_macron");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_macron", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_macron", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_degree, "Key_degree");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_degree", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_degree", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_plusminus, "Key_plusminus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_plusminus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_plusminus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_twosuperior, "Key_twosuperior");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_twosuperior", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_twosuperior", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_threesuperior, "Key_threesuperior");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_threesuperior", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_threesuperior", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_acute, "Key_acute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_acute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_acute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_mu, "Key_mu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_mu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_mu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_paragraph, "Key_paragraph");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_paragraph", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_paragraph", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_periodcentered, "Key_periodcentered");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_periodcentered", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_periodcentered", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_cedilla, "Key_cedilla");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_cedilla", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_cedilla", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_onesuperior, "Key_onesuperior");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_onesuperior", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_onesuperior", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_masculine, "Key_masculine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_masculine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_masculine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_guillemotright, "Key_guillemotright");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_guillemotright", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_guillemotright", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_onequarter, "Key_onequarter");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_onequarter", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_onequarter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_onehalf, "Key_onehalf");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_onehalf", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_onehalf", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_threequarters, "Key_threequarters");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_threequarters", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_threequarters", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_questiondown, "Key_questiondown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_questiondown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_questiondown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Agrave, "Key_Agrave");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Agrave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Agrave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Aacute, "Key_Aacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Aacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Aacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Acircumflex, "Key_Acircumflex");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Acircumflex", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Acircumflex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Atilde, "Key_Atilde");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Atilde", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Atilde", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Adiaeresis, "Key_Adiaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Adiaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Adiaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Aring, "Key_Aring");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Aring", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Aring", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AE, "Key_AE");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AE", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AE", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ccedilla, "Key_Ccedilla");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ccedilla", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ccedilla", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Egrave, "Key_Egrave");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Egrave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Egrave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Eacute, "Key_Eacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Eacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Eacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ecircumflex, "Key_Ecircumflex");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ecircumflex", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ecircumflex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ediaeresis, "Key_Ediaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ediaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ediaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Igrave, "Key_Igrave");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Igrave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Igrave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Iacute, "Key_Iacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Iacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Iacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Icircumflex, "Key_Icircumflex");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Icircumflex", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Icircumflex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Idiaeresis, "Key_Idiaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Idiaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Idiaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ETH, "Key_ETH");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ETH", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ETH", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ntilde, "Key_Ntilde");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ntilde", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ntilde", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ograve, "Key_Ograve");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ograve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ograve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Oacute, "Key_Oacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Oacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Oacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ocircumflex, "Key_Ocircumflex");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ocircumflex", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ocircumflex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Otilde, "Key_Otilde");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Otilde", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Otilde", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Odiaeresis, "Key_Odiaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Odiaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Odiaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_multiply, "Key_multiply");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_multiply", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_multiply", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ooblique, "Key_Ooblique");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ooblique", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ooblique", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ugrave, "Key_Ugrave");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ugrave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ugrave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Uacute, "Key_Uacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Uacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Uacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Ucircumflex, "Key_Ucircumflex");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Ucircumflex", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Ucircumflex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Udiaeresis, "Key_Udiaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Udiaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Udiaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Yacute, "Key_Yacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Yacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Yacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_THORN, "Key_THORN");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_THORN", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_THORN", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ssharp, "Key_ssharp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ssharp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ssharp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_division, "Key_division");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_division", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_division", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ydiaeresis, "Key_ydiaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ydiaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ydiaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AltGr, "Key_AltGr");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AltGr", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AltGr", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Multi_key, "Key_Multi_key");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Multi_key", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Multi_key", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Codeinput, "Key_Codeinput");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Codeinput", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Codeinput", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_SingleCandidate, "Key_SingleCandidate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_SingleCandidate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_SingleCandidate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MultipleCandidate, "Key_MultipleCandidate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MultipleCandidate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MultipleCandidate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_PreviousCandidate, "Key_PreviousCandidate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_PreviousCandidate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_PreviousCandidate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Mode_switch, "Key_Mode_switch");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Mode_switch", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Mode_switch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Kanji, "Key_Kanji");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Kanji", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Kanji", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Muhenkan, "Key_Muhenkan");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Muhenkan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Muhenkan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Henkan, "Key_Henkan");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Henkan", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Henkan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Romaji, "Key_Romaji");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Romaji", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Romaji", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hiragana, "Key_Hiragana");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hiragana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hiragana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Katakana, "Key_Katakana");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Katakana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Katakana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hiragana_Katakana, "Key_Hiragana_Katakana");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hiragana_Katakana", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hiragana_Katakana", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Zenkaku, "Key_Zenkaku");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Zenkaku", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Zenkaku", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hankaku, "Key_Hankaku");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hankaku", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hankaku", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Zenkaku_Hankaku, "Key_Zenkaku_Hankaku");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Zenkaku_Hankaku", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Zenkaku_Hankaku", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Touroku, "Key_Touroku");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Touroku", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Touroku", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Massyo, "Key_Massyo");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Massyo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Massyo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Kana_Lock, "Key_Kana_Lock");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Kana_Lock", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Kana_Lock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Kana_Shift, "Key_Kana_Shift");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Kana_Shift", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Kana_Shift", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Eisu_Shift, "Key_Eisu_Shift");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Eisu_Shift", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Eisu_Shift", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Eisu_toggle, "Key_Eisu_toggle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Eisu_toggle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Eisu_toggle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul, "Key_Hangul");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Start, "Key_Hangul_Start");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Start", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Start", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_End, "Key_Hangul_End");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_End", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_End", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Hanja, "Key_Hangul_Hanja");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Hanja", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Hanja", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Jamo, "Key_Hangul_Jamo");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Jamo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Jamo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Romaja, "Key_Hangul_Romaja");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Romaja", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Romaja", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Jeonja, "Key_Hangul_Jeonja");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Jeonja", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Jeonja", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Banja, "Key_Hangul_Banja");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Banja", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Banja", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_PreHanja, "Key_Hangul_PreHanja");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_PreHanja", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_PreHanja", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_PostHanja, "Key_Hangul_PostHanja");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_PostHanja", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_PostHanja", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangul_Special, "Key_Hangul_Special");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangul_Special", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangul_Special", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Grave, "Key_Dead_Grave");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Grave", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Grave", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Acute, "Key_Dead_Acute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Acute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Acute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Circumflex, "Key_Dead_Circumflex");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Circumflex", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Circumflex", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Tilde, "Key_Dead_Tilde");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Tilde", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Tilde", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Macron, "Key_Dead_Macron");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Macron", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Macron", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Breve, "Key_Dead_Breve");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Breve", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Breve", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Abovedot, "Key_Dead_Abovedot");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Abovedot", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Abovedot", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Diaeresis, "Key_Dead_Diaeresis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Diaeresis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Diaeresis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Abovering, "Key_Dead_Abovering");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Abovering", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Abovering", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Doubleacute, "Key_Dead_Doubleacute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Doubleacute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Doubleacute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Caron, "Key_Dead_Caron");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Caron", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Caron", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Cedilla, "Key_Dead_Cedilla");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Cedilla", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Cedilla", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Ogonek, "Key_Dead_Ogonek");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Ogonek", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Ogonek", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Iota, "Key_Dead_Iota");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Iota", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Iota", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Voiced_Sound, "Key_Dead_Voiced_Sound");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Voiced_Sound", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Voiced_Sound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Semivoiced_Sound, "Key_Dead_Semivoiced_Sound");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Semivoiced_Sound", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Semivoiced_Sound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Belowdot, "Key_Dead_Belowdot");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Belowdot", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Belowdot", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Hook, "Key_Dead_Hook");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Hook", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Hook", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Dead_Horn, "Key_Dead_Horn");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Dead_Horn", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Dead_Horn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Back, "Key_Back");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Back", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Back", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Forward, "Key_Forward");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Forward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Forward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Stop, "Key_Stop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Stop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Stop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Refresh, "Key_Refresh");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Refresh", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Refresh", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_VolumeDown, "Key_VolumeDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_VolumeDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_VolumeDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_VolumeMute, "Key_VolumeMute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_VolumeMute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_VolumeMute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_VolumeUp, "Key_VolumeUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_VolumeUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_VolumeUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BassBoost, "Key_BassBoost");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BassBoost", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BassBoost", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BassUp, "Key_BassUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BassUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BassUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BassDown, "Key_BassDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BassDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BassDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_TrebleUp, "Key_TrebleUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_TrebleUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_TrebleUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_TrebleDown, "Key_TrebleDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_TrebleDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_TrebleDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MediaPlay, "Key_MediaPlay");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MediaPlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MediaPlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MediaStop, "Key_MediaStop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MediaStop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MediaStop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MediaPrevious, "Key_MediaPrevious");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MediaPrevious", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MediaPrevious", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MediaNext, "Key_MediaNext");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MediaNext", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MediaNext", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MediaRecord, "Key_MediaRecord");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MediaRecord", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MediaRecord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_HomePage, "Key_HomePage");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_HomePage", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_HomePage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Favorites, "Key_Favorites");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Favorites", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Favorites", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Search, "Key_Search");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Search", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Search", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Standby, "Key_Standby");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Standby", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Standby", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_OpenUrl, "Key_OpenUrl");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_OpenUrl", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_OpenUrl", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchMail, "Key_LaunchMail");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchMail", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchMail", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchMedia, "Key_LaunchMedia");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchMedia", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchMedia", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch0, "Key_Launch0");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch0", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch0", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch1, "Key_Launch1");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch2, "Key_Launch2");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch3, "Key_Launch3");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch4, "Key_Launch4");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch5, "Key_Launch5");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch5", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch5", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch6, "Key_Launch6");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch6", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch7, "Key_Launch7");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch7", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch7", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch8, "Key_Launch8");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch8", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Launch9, "Key_Launch9");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Launch9", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Launch9", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchA, "Key_LaunchA");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchA", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchA", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchB, "Key_LaunchB");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchC, "Key_LaunchC");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchC", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchC", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchD, "Key_LaunchD");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchD", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchD", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchE, "Key_LaunchE");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchE", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchE", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LaunchF, "Key_LaunchF");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LaunchF", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LaunchF", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MonBrightnessUp, "Key_MonBrightnessUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MonBrightnessUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MonBrightnessUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MonBrightnessDown, "Key_MonBrightnessDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MonBrightnessDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MonBrightnessDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_KeyboardLightOnOff, "Key_KeyboardLightOnOff");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_KeyboardLightOnOff", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_KeyboardLightOnOff", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_KeyboardBrightnessUp, "Key_KeyboardBrightnessUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_KeyboardBrightnessUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_KeyboardBrightnessUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_KeyboardBrightnessDown, "Key_KeyboardBrightnessDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_KeyboardBrightnessDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_KeyboardBrightnessDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_PowerOff, "Key_PowerOff");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_PowerOff", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_PowerOff", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_WakeUp, "Key_WakeUp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_WakeUp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_WakeUp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Eject, "Key_Eject");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Eject", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Eject", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ScreenSaver, "Key_ScreenSaver");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ScreenSaver", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ScreenSaver", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_WWW, "Key_WWW");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_WWW", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_WWW", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Memo, "Key_Memo");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Memo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Memo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LightBulb, "Key_LightBulb");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LightBulb", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LightBulb", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Shop, "Key_Shop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Shop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Shop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_History, "Key_History");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_History", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_History", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AddFavorite, "Key_AddFavorite");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AddFavorite", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AddFavorite", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_HotLinks, "Key_HotLinks");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_HotLinks", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_HotLinks", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BrightnessAdjust, "Key_BrightnessAdjust");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BrightnessAdjust", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BrightnessAdjust", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Finance, "Key_Finance");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Finance", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Finance", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Community, "Key_Community");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Community", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Community", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AudioRewind, "Key_AudioRewind");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AudioRewind", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AudioRewind", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_BackForward, "Key_BackForward");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_BackForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_BackForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ApplicationLeft, "Key_ApplicationLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ApplicationLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ApplicationLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ApplicationRight, "Key_ApplicationRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ApplicationRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ApplicationRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Book, "Key_Book");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Book", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Book", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_CD, "Key_CD");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_CD", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_CD", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Calculator, "Key_Calculator");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Calculator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Calculator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ToDoList, "Key_ToDoList");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ToDoList", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ToDoList", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ClearGrab, "Key_ClearGrab");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ClearGrab", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ClearGrab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Close, "Key_Close");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Close", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Close", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Copy, "Key_Copy");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Copy", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Copy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Cut, "Key_Cut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Cut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Cut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Display, "Key_Display");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Display", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Display", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_DOS, "Key_DOS");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_DOS", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_DOS", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Documents, "Key_Documents");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Documents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Documents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Excel, "Key_Excel");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Excel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Excel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Explorer, "Key_Explorer");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Explorer", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Explorer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Game, "Key_Game");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Game", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Game", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Go, "Key_Go");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Go", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Go", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_iTouch, "Key_iTouch");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_iTouch", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_iTouch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_LogOff, "Key_LogOff");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_LogOff", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_LogOff", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Market, "Key_Market");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Market", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Market", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Meeting, "Key_Meeting");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Meeting", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Meeting", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MenuKB, "Key_MenuKB");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MenuKB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MenuKB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MenuPB, "Key_MenuPB");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MenuPB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MenuPB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MySites, "Key_MySites");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MySites", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MySites", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_News, "Key_News");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_News", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_News", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_OfficeHome, "Key_OfficeHome");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_OfficeHome", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_OfficeHome", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Option, "Key_Option");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Option", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Option", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Paste, "Key_Paste");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Paste", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Paste", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Phone, "Key_Phone");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Phone", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Phone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Calendar, "Key_Calendar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Calendar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Calendar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Reply, "Key_Reply");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Reply", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Reply", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Reload, "Key_Reload");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Reload", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Reload", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_RotateWindows, "Key_RotateWindows");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_RotateWindows", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_RotateWindows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_RotationPB, "Key_RotationPB");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_RotationPB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_RotationPB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_RotationKB, "Key_RotationKB");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_RotationKB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_RotationKB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Save, "Key_Save");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Save", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Save", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Send, "Key_Send");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Send", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Send", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Spell, "Key_Spell");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Spell", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Spell", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_SplitScreen, "Key_SplitScreen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_SplitScreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_SplitScreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Support, "Key_Support");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Support", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Support", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_TaskPane, "Key_TaskPane");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_TaskPane", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_TaskPane", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Terminal, "Key_Terminal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Terminal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Terminal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Tools, "Key_Tools");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Tools", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Tools", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Travel, "Key_Travel");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Travel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Travel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Video, "Key_Video");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Video", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Video", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Word, "Key_Word");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Word", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Word", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Xfer, "Key_Xfer");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Xfer", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Xfer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ZoomIn, "Key_ZoomIn");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ZoomIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ZoomIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ZoomOut, "Key_ZoomOut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ZoomOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ZoomOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Away, "Key_Away");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Away", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Away", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Messenger, "Key_Messenger");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Messenger", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Messenger", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_WebCam, "Key_WebCam");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_WebCam", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_WebCam", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MailForward, "Key_MailForward");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MailForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MailForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Pictures, "Key_Pictures");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Pictures", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Pictures", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Music, "Key_Music");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Music", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Music", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Battery, "Key_Battery");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Battery", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Battery", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Bluetooth, "Key_Bluetooth");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Bluetooth", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Bluetooth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_WLAN, "Key_WLAN");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_WLAN", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_WLAN", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_UWB, "Key_UWB");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_UWB", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_UWB", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AudioForward, "Key_AudioForward");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AudioForward", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AudioForward", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AudioRepeat, "Key_AudioRepeat");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AudioRepeat", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AudioRepeat", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AudioRandomPlay, "Key_AudioRandomPlay");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AudioRandomPlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AudioRandomPlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Subtitle, "Key_Subtitle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Subtitle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Subtitle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_AudioCycleTrack, "Key_AudioCycleTrack");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_AudioCycleTrack", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_AudioCycleTrack", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Time, "Key_Time");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Time", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Time", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hibernate, "Key_Hibernate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hibernate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hibernate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_View, "Key_View");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_View", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_View", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_TopMenu, "Key_TopMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_TopMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_TopMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_PowerDown, "Key_PowerDown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_PowerDown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_PowerDown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Suspend, "Key_Suspend");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Suspend", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Suspend", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_ContrastAdjust, "Key_ContrastAdjust");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_ContrastAdjust", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_ContrastAdjust", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_MediaLast, "Key_MediaLast");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_MediaLast", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_MediaLast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Select, "Key_Select");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Select", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Select", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Yes, "Key_Yes");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Yes", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Yes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_No, "Key_No");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_No", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_No", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Cancel, "Key_Cancel");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Cancel", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Cancel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Printer, "Key_Printer");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Printer", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Printer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Execute, "Key_Execute");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Execute", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Execute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Sleep, "Key_Sleep");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Sleep", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Sleep", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Play, "Key_Play");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Play", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Play", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Zoom, "Key_Zoom");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Zoom", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Zoom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Context1, "Key_Context1");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Context1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Context1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Context2, "Key_Context2");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Context2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Context2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Context3, "Key_Context3");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Context3", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Context3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Context4, "Key_Context4");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Context4", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Context4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Call, "Key_Call");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Call", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Call", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Hangup, "Key_Hangup");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Hangup", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Hangup", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_Flip, "Key_Flip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_Flip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_Flip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_Key_Type,
        (long) Qt::Key_unknown, "Key_unknown");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Key_unknown", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_Key_Type.tp_dict,
        "Key_unknown", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::Key");

    // init enum class: ApplicationAttribute
    SbkPySide_QtCoreTypes[SBK_QT_APPLICATIONATTRIBUTE_IDX] = &SbkPySide_QtCore_Qt_ApplicationAttribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_ApplicationAttribute_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "ApplicationAttribute",((PyObject*)&SbkPySide_QtCore_Qt_ApplicationAttribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_ImmediateWidgetCreation, "AA_ImmediateWidgetCreation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_ImmediateWidgetCreation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_ImmediateWidgetCreation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_MSWindowsUseDirect3DByDefault, "AA_MSWindowsUseDirect3DByDefault");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_MSWindowsUseDirect3DByDefault", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_MSWindowsUseDirect3DByDefault", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_DontShowIconsInMenus, "AA_DontShowIconsInMenus");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_DontShowIconsInMenus", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_DontShowIconsInMenus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_NativeWindows, "AA_NativeWindows");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_NativeWindows", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_NativeWindows", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_DontCreateNativeWidgetSiblings, "AA_DontCreateNativeWidgetSiblings");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_DontCreateNativeWidgetSiblings", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_DontCreateNativeWidgetSiblings", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_MacPluginApplication, "AA_MacPluginApplication");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_MacPluginApplication", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_MacPluginApplication", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_DontUseNativeMenuBar, "AA_DontUseNativeMenuBar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_DontUseNativeMenuBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_DontUseNativeMenuBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_MacDontSwapCtrlAndMeta, "AA_MacDontSwapCtrlAndMeta");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_MacDontSwapCtrlAndMeta", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_MacDontSwapCtrlAndMeta", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_S60DontConstructApplicationPanes, "AA_S60DontConstructApplicationPanes");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_S60DontConstructApplicationPanes", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_S60DontConstructApplicationPanes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_ApplicationAttribute_Type,
        (long) Qt::AA_AttributeCount, "AA_AttributeCount");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "AA_AttributeCount", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_ApplicationAttribute_Type.tp_dict,
        "AA_AttributeCount", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::ApplicationAttribute");

    // init enum class: TextFlag
    SbkPySide_QtCoreTypes[SBK_QT_TEXTFLAG_IDX] = &SbkPySide_QtCore_Qt_TextFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TextFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TextFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TextFlag",((PyObject*)&SbkPySide_QtCore_Qt_TextFlag_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextSingleLine, "TextSingleLine");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextSingleLine", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextSingleLine", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextDontClip, "TextDontClip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextDontClip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextDontClip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextExpandTabs, "TextExpandTabs");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextExpandTabs", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextExpandTabs", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextShowMnemonic, "TextShowMnemonic");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextShowMnemonic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextShowMnemonic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextWordWrap, "TextWordWrap");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextWordWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextWordWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextWrapAnywhere, "TextWrapAnywhere");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextWrapAnywhere", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextWrapAnywhere", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextDontPrint, "TextDontPrint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextDontPrint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextDontPrint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextIncludeTrailingSpaces, "TextIncludeTrailingSpaces");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextIncludeTrailingSpaces", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextIncludeTrailingSpaces", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextHideMnemonic, "TextHideMnemonic");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextHideMnemonic", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextHideMnemonic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextJustificationForced, "TextJustificationForced");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextJustificationForced", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextJustificationForced", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextForceLeftToRight, "TextForceLeftToRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextForceLeftToRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextForceLeftToRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextForceRightToLeft, "TextForceRightToLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextForceRightToLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextForceRightToLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextFlag_Type,
        (long) Qt::TextLongestVariant, "TextLongestVariant");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextLongestVariant", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextFlag_Type.tp_dict,
        "TextLongestVariant", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TextFlag");

    // init enum class: BrushStyle
    SbkPySide_QtCoreTypes[SBK_QT_BRUSHSTYLE_IDX] = &SbkPySide_QtCore_Qt_BrushStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_BrushStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_BrushStyle_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "BrushStyle",((PyObject*)&SbkPySide_QtCore_Qt_BrushStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::NoBrush, "NoBrush");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoBrush", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "NoBrush", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::SolidPattern, "SolidPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SolidPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "SolidPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense1Pattern, "Dense1Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense1Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense1Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense2Pattern, "Dense2Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense2Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense2Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense3Pattern, "Dense3Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense3Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense3Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense4Pattern, "Dense4Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense4Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense4Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense5Pattern, "Dense5Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense5Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense5Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense6Pattern, "Dense6Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense6Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense6Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::Dense7Pattern, "Dense7Pattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "Dense7Pattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "Dense7Pattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::HorPattern, "HorPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "HorPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "HorPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::VerPattern, "VerPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "VerPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "VerPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::CrossPattern, "CrossPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "CrossPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "CrossPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::BDiagPattern, "BDiagPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "BDiagPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "BDiagPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::FDiagPattern, "FDiagPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "FDiagPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "FDiagPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::DiagCrossPattern, "DiagCrossPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "DiagCrossPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "DiagCrossPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::LinearGradientPattern, "LinearGradientPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LinearGradientPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "LinearGradientPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::RadialGradientPattern, "RadialGradientPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RadialGradientPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "RadialGradientPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::ConicalGradientPattern, "ConicalGradientPattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ConicalGradientPattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "ConicalGradientPattern", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_BrushStyle_Type,
        (long) Qt::TexturePattern, "TexturePattern");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TexturePattern", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_BrushStyle_Type.tp_dict,
        "TexturePattern", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::BrushStyle");

    // init enum class: WidgetAttribute
    SbkPySide_QtCoreTypes[SBK_QT_WIDGETATTRIBUTE_IDX] = &SbkPySide_QtCore_Qt_WidgetAttribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_WidgetAttribute_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_WidgetAttribute_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "WidgetAttribute",((PyObject*)&SbkPySide_QtCore_Qt_WidgetAttribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Disabled, "WA_Disabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Disabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Disabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_UnderMouse, "WA_UnderMouse");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_UnderMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_UnderMouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MouseTracking, "WA_MouseTracking");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MouseTracking", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MouseTracking", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_ContentsPropagated, "WA_ContentsPropagated");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_ContentsPropagated", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_ContentsPropagated", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_OpaquePaintEvent, "WA_OpaquePaintEvent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_OpaquePaintEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_OpaquePaintEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoBackground, "WA_NoBackground");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoBackground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_StaticContents, "WA_StaticContents");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_StaticContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_StaticContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_LaidOut, "WA_LaidOut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_LaidOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_LaidOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_PaintOnScreen, "WA_PaintOnScreen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_PaintOnScreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_PaintOnScreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoSystemBackground, "WA_NoSystemBackground");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoSystemBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoSystemBackground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_UpdatesDisabled, "WA_UpdatesDisabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_UpdatesDisabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_UpdatesDisabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Mapped, "WA_Mapped");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Mapped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Mapped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacNoClickThrough, "WA_MacNoClickThrough");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacNoClickThrough", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacNoClickThrough", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_PaintOutsidePaintEvent, "WA_PaintOutsidePaintEvent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_PaintOutsidePaintEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_PaintOutsidePaintEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_InputMethodEnabled, "WA_InputMethodEnabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_InputMethodEnabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_InputMethodEnabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_Visible, "WA_WState_Visible");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_Visible", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_Visible", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_Hidden, "WA_WState_Hidden");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_Hidden", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_Hidden", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_ForceDisabled, "WA_ForceDisabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_ForceDisabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_ForceDisabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_KeyCompression, "WA_KeyCompression");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_KeyCompression", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_KeyCompression", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_PendingMoveEvent, "WA_PendingMoveEvent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_PendingMoveEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_PendingMoveEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_PendingResizeEvent, "WA_PendingResizeEvent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_PendingResizeEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_PendingResizeEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetPalette, "WA_SetPalette");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetPalette", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetPalette", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetFont, "WA_SetFont");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetFont", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetFont", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetCursor, "WA_SetCursor");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetCursor", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetCursor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoChildEventsFromChildren, "WA_NoChildEventsFromChildren");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoChildEventsFromChildren", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoChildEventsFromChildren", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WindowModified, "WA_WindowModified");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WindowModified", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WindowModified", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Resized, "WA_Resized");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Resized", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Resized", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Moved, "WA_Moved");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Moved", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Moved", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_PendingUpdate, "WA_PendingUpdate");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_PendingUpdate", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_PendingUpdate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_InvalidSize, "WA_InvalidSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_InvalidSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_InvalidSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacBrushedMetal, "WA_MacBrushedMetal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacBrushedMetal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacBrushedMetal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacMetalStyle, "WA_MacMetalStyle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacMetalStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacMetalStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_CustomWhatsThis, "WA_CustomWhatsThis");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_CustomWhatsThis", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_CustomWhatsThis", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_LayoutOnEntireRect, "WA_LayoutOnEntireRect");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_LayoutOnEntireRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_LayoutOnEntireRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_OutsideWSRange, "WA_OutsideWSRange");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_OutsideWSRange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_OutsideWSRange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_GrabbedShortcut, "WA_GrabbedShortcut");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_GrabbedShortcut", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_GrabbedShortcut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_TransparentForMouseEvents, "WA_TransparentForMouseEvents");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_TransparentForMouseEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_TransparentForMouseEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_PaintUnclipped, "WA_PaintUnclipped");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_PaintUnclipped", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_PaintUnclipped", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetWindowIcon, "WA_SetWindowIcon");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetWindowIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetWindowIcon", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoMouseReplay, "WA_NoMouseReplay");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoMouseReplay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoMouseReplay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_DeleteOnClose, "WA_DeleteOnClose");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_DeleteOnClose", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_DeleteOnClose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_RightToLeft, "WA_RightToLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_RightToLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_RightToLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetLayoutDirection, "WA_SetLayoutDirection");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetLayoutDirection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetLayoutDirection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoChildEventsForParent, "WA_NoChildEventsForParent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoChildEventsForParent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoChildEventsForParent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_ForceUpdatesDisabled, "WA_ForceUpdatesDisabled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_ForceUpdatesDisabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_ForceUpdatesDisabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_Created, "WA_WState_Created");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_Created", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_Created", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_CompressKeys, "WA_WState_CompressKeys");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_CompressKeys", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_CompressKeys", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_InPaintEvent, "WA_WState_InPaintEvent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_InPaintEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_InPaintEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_Reparented, "WA_WState_Reparented");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_Reparented", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_Reparented", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_ConfigPending, "WA_WState_ConfigPending");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_ConfigPending", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_ConfigPending", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_Polished, "WA_WState_Polished");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_Polished", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_Polished", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_DND, "WA_WState_DND");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_DND", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_DND", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_OwnSizePolicy, "WA_WState_OwnSizePolicy");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_OwnSizePolicy", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_OwnSizePolicy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_ExplicitShowHide, "WA_WState_ExplicitShowHide");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_ExplicitShowHide", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_ExplicitShowHide", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_ShowModal, "WA_ShowModal");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_ShowModal", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_ShowModal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MouseNoMask, "WA_MouseNoMask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MouseNoMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MouseNoMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_GroupLeader, "WA_GroupLeader");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_GroupLeader", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_GroupLeader", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoMousePropagation, "WA_NoMousePropagation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoMousePropagation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoMousePropagation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Hover, "WA_Hover");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Hover", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Hover", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_InputMethodTransparent, "WA_InputMethodTransparent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_InputMethodTransparent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_InputMethodTransparent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_QuitOnClose, "WA_QuitOnClose");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_QuitOnClose", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_QuitOnClose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_KeyboardFocusChange, "WA_KeyboardFocusChange");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_KeyboardFocusChange", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_KeyboardFocusChange", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_AcceptDrops, "WA_AcceptDrops");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_AcceptDrops", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_AcceptDrops", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_DropSiteRegistered, "WA_DropSiteRegistered");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_DropSiteRegistered", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_DropSiteRegistered", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_ForceAcceptDrops, "WA_ForceAcceptDrops");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_ForceAcceptDrops", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_ForceAcceptDrops", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WindowPropagation, "WA_WindowPropagation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WindowPropagation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WindowPropagation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NoX11EventCompression, "WA_NoX11EventCompression");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NoX11EventCompression", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NoX11EventCompression", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_TintedBackground, "WA_TintedBackground");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_TintedBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_TintedBackground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11OpenGLOverlay, "WA_X11OpenGLOverlay");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11OpenGLOverlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11OpenGLOverlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_AlwaysShowToolTips, "WA_AlwaysShowToolTips");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_AlwaysShowToolTips", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_AlwaysShowToolTips", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacOpaqueSizeGrip, "WA_MacOpaqueSizeGrip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacOpaqueSizeGrip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacOpaqueSizeGrip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetStyle, "WA_SetStyle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetStyle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetLocale, "WA_SetLocale");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetLocale", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetLocale", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacShowFocusRect, "WA_MacShowFocusRect");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacShowFocusRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacShowFocusRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacNormalSize, "WA_MacNormalSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacNormalSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacNormalSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacSmallSize, "WA_MacSmallSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacSmallSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacSmallSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacMiniSize, "WA_MacMiniSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacMiniSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacMiniSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_LayoutUsesWidgetRect, "WA_LayoutUsesWidgetRect");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_LayoutUsesWidgetRect", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_LayoutUsesWidgetRect", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_StyledBackground, "WA_StyledBackground");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_StyledBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_StyledBackground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MSWindowsUseDirect3D, "WA_MSWindowsUseDirect3D");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MSWindowsUseDirect3D", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MSWindowsUseDirect3D", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_CanHostQMdiSubWindowTitleBar, "WA_CanHostQMdiSubWindowTitleBar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_CanHostQMdiSubWindowTitleBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_CanHostQMdiSubWindowTitleBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacAlwaysShowToolWindow, "WA_MacAlwaysShowToolWindow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacAlwaysShowToolWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacAlwaysShowToolWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_StyleSheet, "WA_StyleSheet");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_StyleSheet", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_StyleSheet", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_ShowWithoutActivating, "WA_ShowWithoutActivating");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_ShowWithoutActivating", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_ShowWithoutActivating", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11BypassTransientForHint, "WA_X11BypassTransientForHint");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11BypassTransientForHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11BypassTransientForHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_NativeWindow, "WA_NativeWindow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_NativeWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_NativeWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_DontCreateNativeAncestors, "WA_DontCreateNativeAncestors");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_DontCreateNativeAncestors", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_DontCreateNativeAncestors", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacVariableSize, "WA_MacVariableSize");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacVariableSize", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacVariableSize", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_DontShowOnScreen, "WA_DontShowOnScreen");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_DontShowOnScreen", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_DontShowOnScreen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeDesktop, "WA_X11NetWmWindowTypeDesktop");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeDesktop", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeDesktop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeDock, "WA_X11NetWmWindowTypeDock");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeDock", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeDock", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeToolBar, "WA_X11NetWmWindowTypeToolBar");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeToolBar", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeToolBar", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeMenu, "WA_X11NetWmWindowTypeMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeUtility, "WA_X11NetWmWindowTypeUtility");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeUtility", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeUtility", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeSplash, "WA_X11NetWmWindowTypeSplash");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeSplash", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeSplash", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeDialog, "WA_X11NetWmWindowTypeDialog");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeDialog", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeDialog", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeDropDownMenu, "WA_X11NetWmWindowTypeDropDownMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeDropDownMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeDropDownMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypePopupMenu, "WA_X11NetWmWindowTypePopupMenu");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypePopupMenu", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypePopupMenu", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeToolTip, "WA_X11NetWmWindowTypeToolTip");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeToolTip", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeToolTip", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeNotification, "WA_X11NetWmWindowTypeNotification");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeNotification", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeNotification", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeCombo, "WA_X11NetWmWindowTypeCombo");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeCombo", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeCombo", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_X11NetWmWindowTypeDND, "WA_X11NetWmWindowTypeDND");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_X11NetWmWindowTypeDND", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_X11NetWmWindowTypeDND", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MacFrameworkScaled, "WA_MacFrameworkScaled");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MacFrameworkScaled", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MacFrameworkScaled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_SetWindowModality, "WA_SetWindowModality");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_SetWindowModality", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_SetWindowModality", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_WindowOpacitySet, "WA_WState_WindowOpacitySet");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_WindowOpacitySet", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_WindowOpacitySet", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_TranslucentBackground, "WA_TranslucentBackground");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_TranslucentBackground", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_TranslucentBackground", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_AcceptTouchEvents, "WA_AcceptTouchEvents");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_AcceptTouchEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_AcceptTouchEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_WState_AcceptedTouchBeginEvent, "WA_WState_AcceptedTouchBeginEvent");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_WState_AcceptedTouchBeginEvent", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_WState_AcceptedTouchBeginEvent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_TouchPadAcceptSingleTouchEvents, "WA_TouchPadAcceptSingleTouchEvents");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_TouchPadAcceptSingleTouchEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_TouchPadAcceptSingleTouchEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MergeSoftkeys, "WA_MergeSoftkeys");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MergeSoftkeys", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MergeSoftkeys", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_MergeSoftkeysRecursively, "WA_MergeSoftkeysRecursively");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_MergeSoftkeysRecursively", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_MergeSoftkeysRecursively", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Maemo5NonComposited, "WA_Maemo5NonComposited");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Maemo5NonComposited", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Maemo5NonComposited", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Maemo5StackedWindow, "WA_Maemo5StackedWindow");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Maemo5StackedWindow", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Maemo5StackedWindow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Maemo5PortraitOrientation, "WA_Maemo5PortraitOrientation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Maemo5PortraitOrientation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Maemo5PortraitOrientation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Maemo5LandscapeOrientation, "WA_Maemo5LandscapeOrientation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Maemo5LandscapeOrientation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Maemo5LandscapeOrientation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Maemo5AutoOrientation, "WA_Maemo5AutoOrientation");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Maemo5AutoOrientation", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Maemo5AutoOrientation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_Maemo5ShowProgressIndicator, "WA_Maemo5ShowProgressIndicator");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_Maemo5ShowProgressIndicator", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_Maemo5ShowProgressIndicator", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_WidgetAttribute_Type,
        (long) Qt::WA_AttributeCount, "WA_AttributeCount");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "WA_AttributeCount", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_WidgetAttribute_Type.tp_dict,
        "WA_AttributeCount", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::WidgetAttribute");

    // init enum class: TouchPointState
    SbkPySide_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX] = &SbkPySide_QtCore_Qt_TouchPointState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TouchPointState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TouchPointState_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TouchPointState",((PyObject*)&SbkPySide_QtCore_Qt_TouchPointState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TouchPointState_Type,
        (long) Qt::TouchPointPressed, "TouchPointPressed");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TouchPointPressed", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TouchPointState_Type.tp_dict,
        "TouchPointPressed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TouchPointState_Type,
        (long) Qt::TouchPointMoved, "TouchPointMoved");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TouchPointMoved", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TouchPointState_Type.tp_dict,
        "TouchPointMoved", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TouchPointState_Type,
        (long) Qt::TouchPointStationary, "TouchPointStationary");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TouchPointStationary", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TouchPointState_Type.tp_dict,
        "TouchPointStationary", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TouchPointState_Type,
        (long) Qt::TouchPointReleased, "TouchPointReleased");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TouchPointReleased", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TouchPointState_Type.tp_dict,
        "TouchPointReleased", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TouchPointState_Type,
        (long) Qt::TouchPointStateMask, "TouchPointStateMask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TouchPointStateMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TouchPointState_Type.tp_dict,
        "TouchPointStateMask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TouchPointState_Type,
        (long) Qt::TouchPointPrimary, "TouchPointPrimary");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TouchPointPrimary", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TouchPointState_Type.tp_dict,
        "TouchPointPrimary", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TouchPointState");

    // init enum class: TextInteractionFlag
    SbkPySide_QtCoreTypes[SBK_QT_TEXTINTERACTIONFLAG_IDX] = &SbkPySide_QtCore_Qt_TextInteractionFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TextInteractionFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TextInteractionFlag",((PyObject*)&SbkPySide_QtCore_Qt_TextInteractionFlag_Type));

    // init flags class: QFlags<Qt::TextInteractionFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_TEXTINTERACTIONFLAG__IDX] = &SbkPySide_QtCore_Qt_TextInteractionFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TextInteractionFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TextInteractionFlags_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TextInteractionFlags",((PyObject*)&SbkPySide_QtCore_Qt_TextInteractionFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::NoTextInteraction, "NoTextInteraction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoTextInteraction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "NoTextInteraction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::TextSelectableByMouse, "TextSelectableByMouse");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextSelectableByMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "TextSelectableByMouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::TextSelectableByKeyboard, "TextSelectableByKeyboard");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextSelectableByKeyboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "TextSelectableByKeyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::LinksAccessibleByMouse, "LinksAccessibleByMouse");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LinksAccessibleByMouse", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "LinksAccessibleByMouse", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::LinksAccessibleByKeyboard, "LinksAccessibleByKeyboard");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LinksAccessibleByKeyboard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "LinksAccessibleByKeyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::TextEditable, "TextEditable");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextEditable", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "TextEditable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::TextEditorInteraction, "TextEditorInteraction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextEditorInteraction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "TextEditorInteraction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextInteractionFlag_Type,
        (long) Qt::TextBrowserInteraction, "TextBrowserInteraction");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "TextBrowserInteraction", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextInteractionFlag_Type.tp_dict,
        "TextBrowserInteraction", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TextInteractionFlag");

    // init enum class: MouseButton
    SbkPySide_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX] = &SbkPySide_QtCore_Qt_MouseButton_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_MouseButton_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_MouseButton_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "MouseButton",((PyObject*)&SbkPySide_QtCore_Qt_MouseButton_Type));

    // init flags class: QFlags<Qt::MouseButton>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON__IDX] = &SbkPySide_QtCore_Qt_MouseButtons_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_MouseButtons_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_MouseButtons_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "MouseButtons",((PyObject*)&SbkPySide_QtCore_Qt_MouseButtons_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::NoButton, "NoButton");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "NoButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "NoButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::LeftButton, "LeftButton");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "LeftButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "LeftButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::RightButton, "RightButton");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RightButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "RightButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::MidButton, "MidButton");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MidButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "MidButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::XButton1, "XButton1");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "XButton1", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "XButton1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::XButton2, "XButton2");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "XButton2", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "XButton2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MouseButton_Type,
        (long) Qt::MouseButtonMask, "MouseButtonMask");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MouseButtonMask", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MouseButton_Type.tp_dict,
        "MouseButtonMask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::MouseButton");

    // init enum class: MatchFlag
    SbkPySide_QtCoreTypes[SBK_QT_MATCHFLAG_IDX] = &SbkPySide_QtCore_Qt_MatchFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_MatchFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_MatchFlag_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "MatchFlag",((PyObject*)&SbkPySide_QtCore_Qt_MatchFlag_Type));

    // init flags class: QFlags<Qt::MatchFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QT_MATCHFLAG__IDX] = &SbkPySide_QtCore_Qt_MatchFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_MatchFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_MatchFlags_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "MatchFlags",((PyObject*)&SbkPySide_QtCore_Qt_MatchFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchExactly, "MatchExactly");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchExactly", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchExactly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchContains, "MatchContains");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchContains", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchContains", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchStartsWith, "MatchStartsWith");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchStartsWith", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchStartsWith", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchEndsWith, "MatchEndsWith");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchEndsWith", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchEndsWith", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchRegExp, "MatchRegExp");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchRegExp", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchRegExp", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchWildcard, "MatchWildcard");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchWildcard", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchWildcard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchFixedString, "MatchFixedString");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchFixedString", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchFixedString", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchCaseSensitive, "MatchCaseSensitive");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchCaseSensitive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchCaseSensitive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchWrap, "MatchWrap");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchWrap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchWrap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_MatchFlag_Type,
        (long) Qt::MatchRecursive, "MatchRecursive");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MatchRecursive", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_MatchFlag_Type.tp_dict,
        "MatchRecursive", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::MatchFlag");

    // init enum class: PenCapStyle
    SbkPySide_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX] = &SbkPySide_QtCore_Qt_PenCapStyle_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_PenCapStyle_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_PenCapStyle_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "PenCapStyle",((PyObject*)&SbkPySide_QtCore_Qt_PenCapStyle_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenCapStyle_Type,
        (long) Qt::FlatCap, "FlatCap");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "FlatCap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenCapStyle_Type.tp_dict,
        "FlatCap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenCapStyle_Type,
        (long) Qt::SquareCap, "SquareCap");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "SquareCap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenCapStyle_Type.tp_dict,
        "SquareCap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenCapStyle_Type,
        (long) Qt::RoundCap, "RoundCap");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "RoundCap", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenCapStyle_Type.tp_dict,
        "RoundCap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_PenCapStyle_Type,
        (long) Qt::MPenCapStyle, "MPenCapStyle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "MPenCapStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_PenCapStyle_Type.tp_dict,
        "MPenCapStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::PenCapStyle");

    // init enum class: TextElideMode
    SbkPySide_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX] = &SbkPySide_QtCore_Qt_TextElideMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_Qt_TextElideMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_Qt_TextElideMode_Type);
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
            "TextElideMode",((PyObject*)&SbkPySide_QtCore_Qt_TextElideMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextElideMode_Type,
        (long) Qt::ElideLeft, "ElideLeft");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ElideLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextElideMode_Type.tp_dict,
        "ElideLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextElideMode_Type,
        (long) Qt::ElideRight, "ElideRight");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ElideRight", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextElideMode_Type.tp_dict,
        "ElideRight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextElideMode_Type,
        (long) Qt::ElideMiddle, "ElideMiddle");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ElideMiddle", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextElideMode_Type.tp_dict,
        "ElideMiddle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_Qt_TextElideMode_Type,
        (long) Qt::ElideNone, "ElideNone");
    PyDict_SetItemString(SbkQt_Type.super.ht_type.tp_dict,
        "ElideNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_Qt_TextElideMode_Type.tp_dict,
        "ElideNone", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Qt::TextElideMode");

}


} // extern "C"

