/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qresource_wrapper.h"

// Extra includes
#include <qlocale.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQResource_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QResource* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QResource", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QResource(QString,QLocale)
        cptr = new QResource();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QResource(QString,QLocale)
            cptr = new QResource(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QLocale & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QLocale > cpp_arg1_auto_ptr;
            QLocale* cpp_arg1 = Shiboken::Converter<QLocale* >::toCpp(pyargs[1]);
            if (!SbkQLocale_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QLocale >(cpp_arg1);
            // QResource(QString,QLocale)
            cptr = new QResource(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQResource_Init_TypeError;
    } else goto SbkQResource_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QResource >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQResource_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQResource_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString(), PySide.QtCore.QLocale = QLocale()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QResource", overloads);
        return -1;
}

static PyObject* SbkQResourceFunc_absoluteFilePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // absoluteFilePath()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QResource::absoluteFilePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_addSearchPath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addSearchPath(QString)
        QResource::addSearchPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQResourceFunc_addSearchPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQResourceFunc_addSearchPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QResource.addSearchPath", overloads);
        return 0;
}

static PyObject* SbkQResourceFunc_children(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // children()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QResource::children();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QResource::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_isCompressed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCompressed()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QResource::isCompressed();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_isDir(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDir()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QResource::isDir();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_isFile(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFile()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QResource::isFile();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QResource::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_locale(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // locale()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    QLocale cpp_result = cppSelf->QResource::locale();
    py_result = Shiboken::Converter<QLocale >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_registerResource(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "registerResource", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // registerResource(QString,QString)
            bool cpp_result = QResource::registerResource(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // registerResource(QString,QString)
            bool cpp_result = QResource::registerResource(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQResourceFunc_registerResource_TypeError;
    } else goto SbkQResourceFunc_registerResource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQResourceFunc_registerResource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QResource.registerResource", overloads);
        return 0;
}

static PyObject* SbkQResourceFunc_searchPaths(PyObject* self)
{
    PyObject* py_result = 0;

    // searchPaths()
    QStringList cpp_result = QResource::searchPaths();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
        cppSelf->QResource::setFileName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQResourceFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQResourceFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QResource.setFileName", overloads);
        return 0;
}

static PyObject* SbkQResourceFunc_setLocale(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLocale & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLocale > cpp_arg0_auto_ptr;
        QLocale* cpp_arg0 = Shiboken::Converter<QLocale* >::toCpp(arg);
        if (!SbkQLocale_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLocale >(cpp_arg0);
        // setLocale(QLocale)
        QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
        cppSelf->QResource::setLocale(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQResourceFunc_setLocale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQResourceFunc_setLocale_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLocale", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QResource.setLocale", overloads);
        return 0;
}

static PyObject* SbkQResourceFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QResource* cppSelf = Shiboken::Converter<QResource* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QResource::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQResourceFunc_unregisterResource(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "unregisterResource", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // unregisterResource(QString,QString)
            bool cpp_result = QResource::unregisterResource(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // unregisterResource(QString,QString)
            bool cpp_result = QResource::unregisterResource(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQResourceFunc_unregisterResource_TypeError;
    } else goto SbkQResourceFunc_unregisterResource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQResourceFunc_unregisterResource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QResource.unregisterResource", overloads);
        return 0;
}

static PyMethodDef SbkQResource_methods[] = {
    {"absoluteFilePath", (PyCFunction)SbkQResourceFunc_absoluteFilePath, METH_NOARGS},
    {"addSearchPath", (PyCFunction)SbkQResourceFunc_addSearchPath, METH_O|METH_STATIC},
    {"children", (PyCFunction)SbkQResourceFunc_children, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQResourceFunc_fileName, METH_NOARGS},
    {"isCompressed", (PyCFunction)SbkQResourceFunc_isCompressed, METH_NOARGS},
    {"isDir", (PyCFunction)SbkQResourceFunc_isDir, METH_NOARGS},
    {"isFile", (PyCFunction)SbkQResourceFunc_isFile, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQResourceFunc_isValid, METH_NOARGS},
    {"locale", (PyCFunction)SbkQResourceFunc_locale, METH_NOARGS},
    {"registerResource", (PyCFunction)SbkQResourceFunc_registerResource, METH_VARARGS|METH_STATIC},
    {"searchPaths", (PyCFunction)SbkQResourceFunc_searchPaths, METH_NOARGS|METH_STATIC},
    {"setFileName", (PyCFunction)SbkQResourceFunc_setFileName, METH_O},
    {"setLocale", (PyCFunction)SbkQResourceFunc_setLocale, METH_O},
    {"size", (PyCFunction)SbkQResourceFunc_size, METH_NOARGS},
    {"unregisterResource", (PyCFunction)SbkQResourceFunc_unregisterResource, METH_VARARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQResource_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QResource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQResource_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQResource_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QResource >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QResource(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QRESOURCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQResource_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQResource_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQResource_Type));
    PyModule_AddObject(module, "QResource",
        ((PyObject*)&SbkQResource_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QResource >("QResource*");
    Shiboken::TypeResolver::createObjectTypeResolver<QResource >(typeid(QResource).name());
}


} // extern "C"

