/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qlinef_wrapper.h"

// Extra includes
#include <qline.h>
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQLineF_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLineF* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQLineF_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QLineF", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QLineF()
        cptr = new QLineF();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // QLineF(qreal,qreal,qreal,qreal)
        cptr = new QLineF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // QLineF(QPointF,QPointF)
        cptr = new QLineF(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLine & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QLine* cpp_arg0 = Shiboken::Converter<QLine* >::toCpp(pyargs[0]);
        // QLineF(QLine)
        cptr = new QLineF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLineF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(pyargs[0]);
        if (!SbkQLineF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // QLineF(QLineF)
        cptr = new QLineF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineF_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QLineF >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLineF_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQLineF_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLineF", "", "PySide.QtCore.QLine", "PySide.QtCore.QPointF, PySide.QtCore.QPointF", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLineF", overloads);
        return -1;
}

static PyObject* SbkQLineFFunc_angle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // angle()const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QLineF::angle();
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QLineF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(arg);
        if (!SbkQLineF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // angle(QLineF)const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QLineF::angle(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_angle_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFFunc_angle_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QLineF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.angle", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_angleTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QLineF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(arg);
        if (!SbkQLineF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // angleTo(QLineF)const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QLineF::angleTo(*cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_angleTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFFunc_angleTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLineF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.angleTo", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_dx(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dx()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::dx();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_dy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dy()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::dy();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_fromPolar(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromPolar", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // fromPolar(qreal,qreal)
        QLineF cpp_result = QLineF::fromPolar(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QLineF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_fromPolar_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFFunc_fromPolar_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLineF.fromPolar", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_intersect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QLineF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(arg);
        if (!SbkQLineF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // intersect(QLineF,QPointF*)const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        // Begin code injection
        
        QPointF p;
        QLineF::IntersectType retval = cppSelf->intersect(*cpp_arg0, &p);
        py_result = Shiboken::makeTuple(retval, p);
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_intersect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFFunc_intersect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLineF, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.intersect", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineF::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::length();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_normalVector(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalVector()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    QLineF cpp_result = cppSelf->QLineF::normalVector();
    py_result = Shiboken::Converter<QLineF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_p1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // p1()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QLineF::p1();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_p2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // p2()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QLineF::p2();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_pointAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // pointAt(qreal)const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        QPointF cpp_result = cppSelf->QLineF::pointAt(cpp_arg0);
        py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_pointAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFFunc_pointAt_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.pointAt", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_setAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setAngle(qreal)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::setAngle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_setAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_setAngle_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.setAngle", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_setLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLength(qreal)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::setLength(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_setLength_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_setLength_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.setLength", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_setLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setLine", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setLine(qreal,qreal,qreal,qreal)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::setLine(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_setLine_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_setLine_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLineF.setLine", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_setP1(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setP1(QPointF)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::setP1(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_setP1_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_setP1_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.setP1", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_setP2(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setP2(QPointF)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::setP2(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_setP2_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_setP2_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLineF.setP2", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_setPoints(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPoints", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // setPoints(QPointF,QPointF)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::setPoints(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_setPoints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_setPoints_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF, PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLineF.setPoints", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_toLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toLine()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    QLine cpp_result = cppSelf->QLineF::toLine();
    py_result = Shiboken::Converter<QLine >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translate(QPointF)
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        cppSelf->QLineF::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLineF.translate", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translated(qreal,qreal)const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        QLineF cpp_result = cppSelf->QLineF::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QLineF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translated(QPointF)const
        QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
        QLineF cpp_result = cppSelf->QLineF::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QLineF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLineF.translated", overloads);
        return 0;
}

static PyObject* SbkQLineFFunc_unitVector(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // unitVector()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    QLineF cpp_result = cppSelf->QLineF::unitVector();
    py_result = Shiboken::Converter<QLineF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_x1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x1()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::x1();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_x2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x2()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::x2();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_y1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y1()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::y1();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFFunc_y2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y2()const
    QLineF* cppSelf = Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QLineF::y2();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQLineF_methods[] = {
    {"angle", (PyCFunction)SbkQLineFFunc_angle, METH_NOARGS|METH_O},
    {"angleTo", (PyCFunction)SbkQLineFFunc_angleTo, METH_O},
    {"dx", (PyCFunction)SbkQLineFFunc_dx, METH_NOARGS},
    {"dy", (PyCFunction)SbkQLineFFunc_dy, METH_NOARGS},
    {"fromPolar", (PyCFunction)SbkQLineFFunc_fromPolar, METH_VARARGS|METH_STATIC},
    {"intersect", (PyCFunction)SbkQLineFFunc_intersect, METH_O},
    {"isNull", (PyCFunction)SbkQLineFFunc_isNull, METH_NOARGS},
    {"length", (PyCFunction)SbkQLineFFunc_length, METH_NOARGS},
    {"normalVector", (PyCFunction)SbkQLineFFunc_normalVector, METH_NOARGS},
    {"p1", (PyCFunction)SbkQLineFFunc_p1, METH_NOARGS},
    {"p2", (PyCFunction)SbkQLineFFunc_p2, METH_NOARGS},
    {"pointAt", (PyCFunction)SbkQLineFFunc_pointAt, METH_O},
    {"setAngle", (PyCFunction)SbkQLineFFunc_setAngle, METH_O},
    {"setLength", (PyCFunction)SbkQLineFFunc_setLength, METH_O},
    {"setLine", (PyCFunction)SbkQLineFFunc_setLine, METH_VARARGS},
    {"setP1", (PyCFunction)SbkQLineFFunc_setP1, METH_O},
    {"setP2", (PyCFunction)SbkQLineFFunc_setP2, METH_O},
    {"setPoints", (PyCFunction)SbkQLineFFunc_setPoints, METH_VARARGS},
    {"toLine", (PyCFunction)SbkQLineFFunc_toLine, METH_NOARGS},
    {"translate", (PyCFunction)SbkQLineFFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQLineFFunc_translated, METH_VARARGS},
    {"unitVector", (PyCFunction)SbkQLineFFunc_unitVector, METH_NOARGS},
    {"x1", (PyCFunction)SbkQLineFFunc_x1, METH_NOARGS},
    {"x2", (PyCFunction)SbkQLineFFunc_x2, METH_NOARGS},
    {"y1", (PyCFunction)SbkQLineFFunc_y1, METH_NOARGS},
    {"y2", (PyCFunction)SbkQLineFFunc_y2, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQLineF_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QLineF& cpp_self = *Shiboken::Converter<QLineF* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QLineF & >::isConvertible(other)) {
                // operator!=(const QLineF & d) const
                QLineF* cpp_other = Shiboken::Converter<QLineF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLineF  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QLineF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QLineF > cpp_other_auto_ptr;
                QLineF* cpp_other = Shiboken::Converter<QLineF* >::toCpp(other);
                if (!SbkQLineF_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QLineF >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQLineF_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QLineF & >::isConvertible(other)) {
                // operator==(const QLineF & d) const
                QLineF* cpp_other = Shiboken::Converter<QLineF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLineF  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QLineF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QLineF > cpp_other_auto_ptr;
                QLineF* cpp_other = Shiboken::Converter<QLineF* >::toCpp(other);
                if (!SbkQLineF_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QLineF >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQLineF_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQLineF_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLineF_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QLineF",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQLineF_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLineF_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLineF_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QLineF >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QLineF_IntersectType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QLineF_IntersectType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QLineF_IntersectType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "IntersectType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QLineF_IntersectType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QLineF_IntersectType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QLineF_IntersectType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QLineF(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QLINEF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLineF_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQLineF_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLineF_Type));
    PyModule_AddObject(module, "QLineF",
        ((PyObject*)&SbkQLineF_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: IntersectType
    SbkPySide_QtCoreTypes[SBK_QLINEF_INTERSECTTYPE_IDX] = &SbkPySide_QtCore_QLineF_IntersectType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QLineF_IntersectType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QLineF_IntersectType_Type);
    PyDict_SetItemString(SbkQLineF_Type.super.ht_type.tp_dict,
            "IntersectType",((PyObject*)&SbkPySide_QtCore_QLineF_IntersectType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLineF_IntersectType_Type,
        (long) QLineF::NoIntersection, "NoIntersection");
    PyDict_SetItemString(SbkQLineF_Type.super.ht_type.tp_dict,
        "NoIntersection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLineF_IntersectType_Type.tp_dict,
        "NoIntersection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLineF_IntersectType_Type,
        (long) QLineF::BoundedIntersection, "BoundedIntersection");
    PyDict_SetItemString(SbkQLineF_Type.super.ht_type.tp_dict,
        "BoundedIntersection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLineF_IntersectType_Type.tp_dict,
        "BoundedIntersection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QLineF_IntersectType_Type,
        (long) QLineF::UnboundedIntersection, "UnboundedIntersection");
    PyDict_SetItemString(SbkQLineF_Type.super.ht_type.tp_dict,
        "UnboundedIntersection", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QLineF_IntersectType_Type.tp_dict,
        "UnboundedIntersection", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLineF::IntersectType");

    Shiboken::TypeResolver::createValueTypeResolver<QLineF >("QLineF");
    Shiboken::TypeResolver::createValueTypeResolver<QLineF >(typeid(QLineF).name());
}


} // extern "C"

