/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qeventloop_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QEventLoopWrapper::QEventLoopWrapper(QObject * parent) : QEventLoop(parent), m_metaObject(0) {
    // ... middle
}

void QEventLoopWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QEventLoopWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QEventLoopWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QEventLoopWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QEventLoopWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QEventLoop.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QEventLoopWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QEventLoop.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QEventLoopWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QEventLoopWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QEventLoop::staticMetaObject);
}
    return m_metaObject;
}

int QEventLoopWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QEventLoop::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QEventLoopWrapper::~QEventLoopWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQEventLoop_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QEventLoopWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QEventLoop", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QEventLoop(QObject*)
        cptr = new QEventLoopWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QEventLoop(QObject*)
        cptr = new QEventLoopWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQEventLoop_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QEventLoop >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQEventLoop_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQEventLoop_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QEventLoop", overloads);
        return -1;
}

static PyObject* SbkQEventLoopFunc_exec_(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exec(QFlags<QEventLoop::ProcessEventsFlag>)
        QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QEventLoop::exec();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Check(arg)) {
        QFlags<QEventLoop::ProcessEventsFlag> cpp_arg0 = Shiboken::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::toCpp(arg);
        // exec(QFlags<QEventLoop::ProcessEventsFlag>)
        QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        int cpp_result = cppSelf->QEventLoop::exec(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEventLoopFunc_exec__TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQEventLoopFunc_exec__TypeError:
        const char* overloads[] = {"PySide.QtCore.QEventLoop.ProcessEventsFlags = QEventLoop.AllEvents", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEventLoop.exec_", overloads);
        return 0;
}

static PyObject* SbkQEventLoopFunc_exit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exit(int)
        QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
        cppSelf->QEventLoop::exit();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // exit(int)
        QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
        cppSelf->QEventLoop::exit(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQEventLoopFunc_exit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQEventLoopFunc_exit_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QEventLoop.exit", overloads);
        return 0;
}

static PyObject* SbkQEventLoopFunc_isRunning(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRunning()const
    QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QEventLoop::isRunning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQEventLoopFunc_processEvents(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processEvents", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
        QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QEventLoop::processEvents();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Check(pyargs[0])) {
        QFlags<QEventLoop::ProcessEventsFlag> cpp_arg0 = Shiboken::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
            QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QEventLoop::processEvents(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
            QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            cppSelf->QEventLoop::processEvents(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            //CppGenerator::writeParentChildManagement
            py_result = Py_None;
            Py_INCREF(Py_None);
        } else goto SbkQEventLoopFunc_processEvents_TypeError;
    } else goto SbkQEventLoopFunc_processEvents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQEventLoopFunc_processEvents_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEventLoop.ProcessEventsFlags = QEventLoop.AllEvents", "PySide.QtCore.QEventLoop.ProcessEventsFlags, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QEventLoop.processEvents", overloads);
        return 0;
}

static PyObject* SbkQEventLoopFunc_quit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // quit()
    QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
    cppSelf->QEventLoop::quit();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQEventLoopFunc_wakeUp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // wakeUp()
    QEventLoop* cppSelf = Shiboken::Converter<QEventLoop* >::toCpp((PyObject*)self);
    cppSelf->QEventLoop::wakeUp();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQEventLoop_methods[] = {
    {"exec_", (PyCFunction)SbkQEventLoopFunc_exec_, METH_NOARGS|METH_O},
    {"exit", (PyCFunction)SbkQEventLoopFunc_exit, METH_NOARGS|METH_O},
    {"isRunning", (PyCFunction)SbkQEventLoopFunc_isRunning, METH_NOARGS},
    {"processEvents", (PyCFunction)SbkQEventLoopFunc_processEvents, METH_VARARGS},
    {"quit", (PyCFunction)SbkQEventLoopFunc_quit, METH_NOARGS},
    {"wakeUp", (PyCFunction)SbkQEventLoopFunc_wakeUp, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQEventLoop_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QEventLoop",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQEventLoop_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQEventLoop_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QEventLoop >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toPython(
        ((QEventLoop::ProcessEventsFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toPython(
        ((QEventLoop::ProcessEventsFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toPython(
        ((QEventLoop::ProcessEventsFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toPython(
        ~ Shiboken::Converter< QEventLoop::ProcessEventsFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QEventLoop_ProcessEventsFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProcessEventsFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ProcessEventsFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QEventLoop(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QEVENTLOOP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQEventLoop_Type);

    SbkQEventLoop_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQEventLoop_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQEventLoop_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQEventLoop_Type));
    PyModule_AddObject(module, "QEventLoop",
        ((PyObject*)&SbkQEventLoop_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ProcessEventsFlag
    SbkPySide_QtCoreTypes[SBK_QEVENTLOOP_PROCESSEVENTSFLAG_IDX] = &SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type);
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
            "ProcessEventsFlag",((PyObject*)&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type));

    // init flags class: QFlags<QEventLoop::ProcessEventsFlag>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QEVENTLOOP_PROCESSEVENTSFLAG__IDX] = &SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Type);
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
            "ProcessEventsFlags",((PyObject*)&SbkPySide_QtCore_QEventLoop_ProcessEventsFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::AllEvents, "AllEvents");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "AllEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "AllEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::ExcludeUserInputEvents, "ExcludeUserInputEvents");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "ExcludeUserInputEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "ExcludeUserInputEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::ExcludeSocketNotifiers, "ExcludeSocketNotifiers");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "ExcludeSocketNotifiers", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "ExcludeSocketNotifiers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::WaitForMoreEvents, "WaitForMoreEvents");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "WaitForMoreEvents", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "WaitForMoreEvents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::X11ExcludeTimers, "X11ExcludeTimers");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "X11ExcludeTimers", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "X11ExcludeTimers", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::DeferredDeletion, "DeferredDeletion");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "DeferredDeletion", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "DeferredDeletion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::EventLoopExec, "EventLoopExec");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "EventLoopExec", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "EventLoopExec", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type,
        (long) QEventLoop::DialogExec, "DialogExec");
    PyDict_SetItemString(SbkQEventLoop_Type.super.ht_type.tp_dict,
        "DialogExec", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Type.tp_dict,
        "DialogExec", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QEventLoop::ProcessEventsFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QEventLoop >("QEventLoop*");
    Shiboken::TypeResolver::createObjectTypeResolver<QEventLoop >(typeid(QEventLoop).name());
}


} // extern "C"

