/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qabstracttransition_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractanimation.h>
#include <qabstractstate.h>
#include <qabstracttransition.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstate.h>
#include <qstatemachine.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractTransitionWrapper::QAbstractTransitionWrapper(QState * sourceState) : QAbstractTransition(sourceState), m_metaObject(0) {
    // ... middle
}

void QAbstractTransitionWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractTransitionWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractTransitionWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractTransitionWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractTransitionWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAbstractTransition::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractTransition.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractTransitionWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractTransition.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QAbstractTransitionWrapper::eventTest(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventTest"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTransition.eventTest()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractTransition.eventTest", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractTransitionWrapper::onTransition(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "onTransition"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTransition.onTransition()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractTransitionWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAbstractTransitionWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractTransition::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractTransitionWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractTransition::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractTransitionWrapper::~QAbstractTransitionWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractTransition_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractTransitionWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractTransition' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractTransition", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractTransition(QState*)
        cptr = new QAbstractTransitionWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else if (Shiboken::Converter<QState * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QState* cpp_arg0 = Shiboken::Converter<QState* >::toCpp(pyargs[0]);
        // QAbstractTransition(QState*)
        cptr = new QAbstractTransitionWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQAbstractTransition_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractTransition >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractTransition_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractTransition_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QState = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractTransition", overloads);
        return -1;
}

static PyObject* SbkQAbstractTransitionFunc_addAnimation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractAnimation* cpp_arg0 = Shiboken::Converter<QAbstractAnimation* >::toCpp(arg);
        // addAnimation(QAbstractAnimation*)
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTransition::addAnimation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQAbstractTransitionFunc_addAnimation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTransitionFunc_addAnimation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.addAnimation", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_animations(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // animations()const
    QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
    QList<QAbstractAnimation * > cpp_result = cppSelf->QAbstractTransition::animations();
    py_result = Shiboken::Converter<QList<QAbstractAnimation * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractTransitionFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractTransition::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTransitionFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractTransitionFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.event", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_eventTest(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // eventTest(QEvent*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTransition.eventTest()' not implemented.");
            return 0;
        }
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->eventTest(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTransitionFunc_eventTest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractTransitionFunc_eventTest_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.eventTest", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_machine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // machine()const
    QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
    QStateMachine * cpp_result = cppSelf->QAbstractTransition::machine();
    py_result = Shiboken::Converter<QStateMachine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractTransitionFunc_onTransition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // onTransition(QEvent*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractTransition.onTransition()' not implemented.");
            return 0;
        }
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        cppSelf->onTransition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTransitionFunc_onTransition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTransitionFunc_onTransition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.onTransition", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_removeAnimation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractAnimation* cpp_arg0 = Shiboken::Converter<QAbstractAnimation* >::toCpp(arg);
        // removeAnimation(QAbstractAnimation*)
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTransition::removeAnimation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQAbstractTransitionFunc_removeAnimation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTransitionFunc_removeAnimation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.removeAnimation", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_setTargetState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractState * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractState* cpp_arg0 = Shiboken::Converter<QAbstractState* >::toCpp(arg);
        // setTargetState(QAbstractState*)
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        cppSelf->QAbstractTransition::setTargetState(cpp_arg0);
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setTargetState(QAbstractState*)1", arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTransitionFunc_setTargetState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTransitionFunc_setTargetState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.setTargetState", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_setTargetStates(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QAbstractState * >  >::isConvertible(arg)) {
        QList<QAbstractState * >  cpp_arg0 = Shiboken::Converter<QList<QAbstractState * >  >::toCpp(arg);
        // setTargetStates(QList<QAbstractState*>)
        QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // The normal here would be to use the 'reference-count' tag but this
        // method is strongly tied to 'setTargetState' since both affect the same
        // internal value in QAbstractTransition.
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setTargetState(QAbstractState*)1", arg);
        
        // End of code injection

        cppSelf->QAbstractTransition::setTargetStates(cpp_arg0);

        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTransitionFunc_setTargetStates_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractTransitionFunc_setTargetStates_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractTransition.setTargetStates", overloads);
        return 0;
}

static PyObject* SbkQAbstractTransitionFunc_sourceState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sourceState()const
    QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
    QState * cpp_result = cppSelf->QAbstractTransition::sourceState();
    py_result = Shiboken::Converter<QState * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractTransitionFunc_targetState(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // targetState()const
    QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
    QAbstractState * cpp_result = cppSelf->QAbstractTransition::targetState();
    py_result = Shiboken::Converter<QAbstractState * >::toPython(cpp_result);

    // Ownership transferences.
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractTransitionFunc_targetStates(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // targetStates()const
    QAbstractTransition* cppSelf = Shiboken::Converter<QAbstractTransition* >::toCpp((PyObject*)self);
    QList<QAbstractState * > cpp_result = cppSelf->QAbstractTransition::targetStates();
    py_result = Shiboken::Converter<QList<QAbstractState * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAbstractTransition_methods[] = {
    {"addAnimation", (PyCFunction)SbkQAbstractTransitionFunc_addAnimation, METH_O},
    {"animations", (PyCFunction)SbkQAbstractTransitionFunc_animations, METH_NOARGS},
    {"event", (PyCFunction)SbkQAbstractTransitionFunc_event, METH_O},
    {"eventTest", (PyCFunction)SbkQAbstractTransitionFunc_eventTest, METH_O},
    {"machine", (PyCFunction)SbkQAbstractTransitionFunc_machine, METH_NOARGS},
    {"onTransition", (PyCFunction)SbkQAbstractTransitionFunc_onTransition, METH_O},
    {"removeAnimation", (PyCFunction)SbkQAbstractTransitionFunc_removeAnimation, METH_O},
    {"setTargetState", (PyCFunction)SbkQAbstractTransitionFunc_setTargetState, METH_O},
    {"setTargetStates", (PyCFunction)SbkQAbstractTransitionFunc_setTargetStates, METH_O},
    {"sourceState", (PyCFunction)SbkQAbstractTransitionFunc_sourceState, METH_NOARGS},
    {"targetState", (PyCFunction)SbkQAbstractTransitionFunc_targetState, METH_NOARGS},
    {"targetStates", (PyCFunction)SbkQAbstractTransitionFunc_targetStates, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractTransition_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QAbstractTransition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractTransition_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractTransition_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractTransition >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAbstractTransition(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QABSTRACTTRANSITION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractTransition_Type);

    SbkQAbstractTransition_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractTransition_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractTransition_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractTransition_Type));
    PyModule_AddObject(module, "QAbstractTransition",
        ((PyObject*)&SbkQAbstractTransition_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractTransition >("QAbstractTransition*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractTransition >(typeid(QAbstractTransition).name());
}


} // extern "C"

