/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qabstractfileengineiterator_wrapper.h"

// Extra includes
#include <qabstractfileengine.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractFileEngineIteratorWrapper::QAbstractFileEngineIteratorWrapper(QFlags<QDir::Filter> filters, const QStringList & nameFilters) : QAbstractFileEngineIterator(filters, nameFilters) {
    // ... middle
}

QFileInfo QAbstractFileEngineIteratorWrapper::currentFileInfo() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentFileInfo"));
    if (py_override.isNull()) {
        return this->QAbstractFileEngineIterator::currentFileInfo();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFileInfo();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFileInfo >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractFileEngineIterator.currentFileInfo", SbkType<QFileInfo >()->tp_name, py_result->ob_type->tp_name);
        return QFileInfo();
    }
    QFileInfo cpp_result(Shiboken::Converter<QFileInfo >::toCpp(py_result));
    return cpp_result;
}

QString QAbstractFileEngineIteratorWrapper::currentFileName() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentFileName"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractFileEngineIterator.currentFileName()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractFileEngineIterator.currentFileName", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractFileEngineIteratorWrapper::hasNext() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasNext"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractFileEngineIterator.hasNext()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractFileEngineIterator.hasNext", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QAbstractFileEngineIteratorWrapper::next()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "next"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractFileEngineIterator.next()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractFileEngineIterator.next", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QAbstractFileEngineIteratorWrapper::~QAbstractFileEngineIteratorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQAbstractFileEngineIterator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractFileEngineIteratorWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINEITERATOR_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractFileEngineIterator' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QAbstractFileEngineIterator", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && SbkPySide_QtCore_QDir_Filter_Check(pyargs[0]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!SbkQStringList_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // QAbstractFileEngineIterator(QFlags<QDir::Filter>,QStringList)
        cptr = new QAbstractFileEngineIteratorWrapper(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractFileEngineIterator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractFileEngineIterator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractFileEngineIterator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractFileEngineIterator_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractFileEngineIterator", overloads);
        return -1;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_currentFileInfo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFileInfo()const
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QFileInfo cpp_result = cppSelf->QAbstractFileEngineIterator::currentFileInfo();
    py_result = Shiboken::Converter<QFileInfo >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_currentFileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFileName()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractFileEngineIterator.currentFileName()' not implemented.");
        return 0;
    }
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->currentFileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_currentFilePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFilePath()const
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAbstractFileEngineIterator::currentFilePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_filters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // filters()const
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QFlags<QDir::Filter> cpp_result = cppSelf->QAbstractFileEngineIterator::filters();
    py_result = Shiboken::Converter<QFlags<QDir::Filter> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_hasNext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasNext()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractFileEngineIterator.hasNext()' not implemented.");
        return 0;
    }
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->hasNext();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_nameFilters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nameFilters()const
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QAbstractFileEngineIterator::nameFilters();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // next()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractFileEngineIterator.next()' not implemented.");
        return 0;
    }
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->next();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractFileEngineIteratorFunc_path(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // path()const
    QAbstractFileEngineIterator* cppSelf = Shiboken::Converter<QAbstractFileEngineIterator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAbstractFileEngineIterator::path();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAbstractFileEngineIterator_methods[] = {
    {"currentFileInfo", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_currentFileInfo, METH_NOARGS},
    {"currentFileName", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_currentFileName, METH_NOARGS},
    {"currentFilePath", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_currentFilePath, METH_NOARGS},
    {"filters", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_filters, METH_NOARGS},
    {"hasNext", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_hasNext, METH_NOARGS},
    {"nameFilters", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_nameFilters, METH_NOARGS},
    {"next", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_next, METH_NOARGS},
    {"path", (PyCFunction)SbkQAbstractFileEngineIteratorFunc_path, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractFileEngineIterator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QAbstractFileEngineIterator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractFileEngineIterator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractFileEngineIterator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractFileEngineIterator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQAbstractFileEngineIterator_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQAbstractFileEngineIterator_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QAbstractFileEngineIterator*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QAbstractFileEngineIterator(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINEITERATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractFileEngineIterator_Type);

    // Fill type discovery information
    SbkQAbstractFileEngineIterator_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQAbstractFileEngineIterator_Type.type_discovery->addTypeDiscoveryFunction(&SbkQAbstractFileEngineIterator_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractFileEngineIterator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractFileEngineIterator_Type));
    PyModule_AddObject(module, "QAbstractFileEngineIterator",
        ((PyObject*)&SbkQAbstractFileEngineIterator_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractFileEngineIterator >("QAbstractFileEngineIterator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractFileEngineIterator >(typeid(QAbstractFileEngineIterator).name());
}


} // extern "C"

