#!/bin/sh
set -x -e -u

# hardcode values here because we might not have access to
# /etc/default/pymaemo-optify
BIND_MOUNTS="/usr/lib/python2.5 /usr/share/pyshared /usr/lib/pyshared
/usr/share/python-support /usr/lib/python-support"
OPT_DIR="/opt/pymaemo"

oldver=0.1
newver=0.2

assert_clean()
{
    test ! -e /var/lib/dpkg/info/dummy.list
    test ! -e /var/lib/dpkg/info/pymaemo-optify.list
    test ! -e $OPT_DIR
    for d in $BIND_MOUNTS; do test ! -e $d; done
}

echo "Testing clean installation/removal"

for v in $oldver $newver; do
    assert_clean

    test -e /root/pymaemo-optify_${v}_all.deb
    dpkg -i /root/pymaemo-optify_${v}_all.deb
    dpkg --purge pymaemo-optify

    assert_clean
done

echo "Testing clean upgrade/downgrade"

dpkg -i /root/pymaemo-optify_${oldver}_all.deb
dpkg -i /root/pymaemo-optify_${newver}_all.deb
dpkg -i /root/pymaemo-optify_${oldver}_all.deb

echo "Testing dirty upgrade/downgrade #1"

test -e /root/dummy_0.1_all.deb
dpkg -i /root/dummy_0.1_all.deb

for v in $newver $oldver; do
    test -e /root/dummy_0.1_all.deb
    dpkg -i /root/pymaemo-optify_${v}_all.deb
    test -e /usr/lib/python2.5/somefile
    test -e $OPT_DIR/usr/lib/python2.5/somefile
    # trick to check if they are in fact the same file
    mv /usr/lib/python2.5/somefile /usr/lib/python2.5/somefile.orig
    test -e $OPT_DIR/usr/lib/python2.5/somefile.orig
    mv /usr/lib/python2.5/somefile.orig /usr/lib/python2.5/somefile
done

echo "Cleaning up test"

dpkg --purge dummy
dpkg --purge pymaemo-optify

echo "All tests passed!"
