/*****************************************************************************
 * PokerTH - The open source texas holdem engine                             *
 * Copyright (C) 2006-2011 Felix Hammer, Florian Thauer, Lothar May          *
 *                                                                           *
 * This program is free software: you can redistribute it and/or modify      *
 * it under the terms of the GNU Affero General Public License as            *
 * published by the Free Software Foundation, either version 3 of the        *
 * License, or (at your option) any later version.                           *
 *                                                                           *
 * This program is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU Affero General Public License for more details.                       *
 *                                                                           *
 * You should have received a copy of the GNU Affero General Public License  *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.     *
 *****************************************************************************/
/* Callback interface for the chatcleaner. */

#ifndef _CHATCLEANERCALLBACK_H_
#define _CHATCLEANERCALLBACK_H_

#include <string>


class ChatCleanerCallback
{
public:
	virtual ~ChatCleanerCallback();

	virtual void SignalChatBotMessage(const std::string &msg) = 0;
	virtual void SignalChatBotMessage(unsigned gameId, const std::string &msg) = 0;
	virtual void SignalKickPlayer(unsigned playerId) = 0;
	virtual void SignalBanPlayer(unsigned playerId) = 0;
	virtual void SignalMutePlayer(unsigned playerId) = 0;
};

#endif
