#include <QtCore>
#include <QTest>
#include <QDesktopServices>
#include <QGraphicsView>
#include <QGraphicsScene>
#include "basicunittests.h"
#include "ppgraphicsstroke.h"
#include "configentity.h"
#include "sketchpaper.h"
#include "ppxmlpaper.h"
#include "ppgraphicsstrokesnapshot.h"
//#include "sketchxmlpaper.h"

BasicUnitTests::BasicUnitTests(QObject *parent)
    : QObject(parent)
{
}

BasicUnitTests::~BasicUnitTests()
{

}

void BasicUnitTests::stroke_save_load(){
    QString xml = "<stroke points=\"149,9 149,10 150,13 151,14 153,17 157,22 161,28 165,36 170,43 175,51 180,58 184,66 190,74 194,84 199,92 204,101 208,109 211,117 215,123 216,124 217,126 218,128 220,130 220,131 221,133 222,134 223,136 224,138 225,140 226,142 227,143 228,144 228,145\"/>";
    PPXmlPaper xmlPaper;

    QDomDocument doc;
    QVERIFY (doc.setContent(xml) );

    QDomElement elem = doc.firstChildElement("stroke");
    QString input_points = elem.attribute("points","");

    PPGraphicsStroke *stroke = new PPGraphicsStroke();

    QVERIFY (xmlPaper.setStrokeFromElement(stroke,elem) );

    elem = xmlPaper.createStrokeElement(stroke,doc);

    QVERIFY(!elem.isNull());

    QString output_points = elem.attribute("points","");

    QCOMPARE(output_points,input_points);

    delete stroke;
}

void BasicUnitTests::graphicsStrokeSnapshot(){
    QString xml = "<stroke points=\"149,9 149,10 150,13 151,14 153,17 157,22 161,28 165,36 170,43 175,51 180,58 184,66 190,74 194,84 199,92 204,101 208,109 211,117 215,123 216,124 217,126 218,128 220,130 220,131 221,133 222,134 223,136 224,138 225,140 226,142 227,143 228,144 228,145\"/>";
    PPXmlPaper xmlPaper;
    QDomDocument doc;
    QVERIFY (doc.setContent(xml) );

    QDomElement elem = doc.firstChildElement("stroke");
    QString input_points = elem.attribute("points","");

    PPGraphicsStroke *stroke = new PPGraphicsStroke();

    QVERIFY (xmlPaper.setStrokeFromElement(stroke,elem) ); // Loaded the data to stroke

    PPGraphicsStrokeSnapshot snapshot;
    QVERIFY(snapshot.count() == 0);

    snapshot.read(stroke);
    QVERIFY(snapshot.count() == 2);

    PPGraphicsStroke *stroke2 = new PPGraphicsStroke();
    snapshot.write(stroke2);

    elem = xmlPaper.createStrokeElement(stroke2,doc);

    QVERIFY(!elem.isNull());

    QString output_points = elem.attribute("points","");

    QCOMPARE(output_points,input_points); // Test is stroke == stroke2

    delete stroke;
    delete stroke2;
}


void BasicUnitTests::paper_save_load(){
    QFile file(":save1.xml");
    QVERIFY(file.open(QIODevice::ReadOnly));
    QByteArray input = file.readAll();

    SketchPaper paper;

    PPXmlPaper paperXml;
    QDomDocument doc;
    QVERIFY (doc.setContent(input) );

    QDomElement elem = doc.firstChildElement("paper");
    QVERIFY(!elem.isNull());

//    paper.setFromElement(elem);
    paperXml.read(elem);
    paperXml.write(&paper);

    PPXmlPaper paperXml2;
    paperXml2.read(&paper);

    QString xml;
    QDomElement outputElem = paperXml2.read(&paper);

    QTextStream stream(&xml);
    outputElem.save(stream,0);

    xml = stream.readAll();
    QByteArray output;
    output.append(xml);

    if (input != output ){
        QFile file;
        file.setFileName("paper_save_load-input.xml");
        file.open(QIODevice::WriteOnly);
        file.write(input);
        file.close();

        file.setFileName("paper_save_load-output.xml");
        file.open(QIODevice::WriteOnly);
        file.write(output);
        file.close();
    }

    QVERIFY(input == output);

}

void BasicUnitTests::paperXml_read_write(){
    /* Test read */
    QFile file(":save1.xml");
    QVERIFY(file.open(QIODevice::ReadOnly));
    QByteArray input = file.readAll();

    QDomDocument doc;
    QVERIFY (doc.setContent(input) );

    QDomElement elem = doc.firstChildElement("paper");
    QVERIFY(!elem.isNull());

    PPXmlPaper xml;
    xml.read(elem);

    QDomDocument doc2 = xml.document();

    QByteArray output;
    QString str = doc2.toString(0);
    output.append(str);

    QVERIFY(input == output);

    /* Test write */
    output.clear();

    QDomDocument doc3;
    doc3.setContent(QByteArray());
    QVERIFY( xml.write(doc3) );

    str = doc3.toString(0);
    output.append(str);

    QVERIFY(input == output);

}

void BasicUnitTests::paper_id(){
    QGraphicsView *view = new QGraphicsView();
    QGraphicsScene* scene = new QGraphicsScene(this);
    view->setScene(scene);

    PPPaper *paper = new PPPaper();
    scene->addItem(paper);
    QVERIFY(paper->nextId() == 1);

    PPGraphicsStroke* stroke;

    stroke = new PPGraphicsStroke();
    QVERIFY(stroke->id() == 0);
    stroke->setParentItem(paper);

    QVERIFY(stroke->id() == 1);
    QVERIFY(paper->nextId() == 2);

    stroke = new PPGraphicsStroke(paper);
    QVERIFY(paper->nextId() == 3);
    QVERIFY(stroke->id() == 2);

    stroke = new PPGraphicsStroke();
    stroke->setId(1000);
    stroke->setParentItem(paper);

    QVERIFY(stroke->id() == 1000);
    QVERIFY(paper->nextId() == 1001);

    delete view;
}

/* StorageUnitTests */
void StorageUnitTests::initTestCase(){
    Storage *storage = Storage::instance();
    QVERIFY(storage->open());

    ConfigEntity entity;
    QVERIFY (entity.load("ver") );
    QVERIFY(entity.value() == "1");

    // Test field;
    entity.load("test");
    entity.setValue("test");
    entity.save();
    QVERIFY(entity.id() != -1);

    ConfigEntity entity2;
    QVERIFY( entity2.load("test") );

    QVERIFY( entity.id() == entity2.id() );
    QVERIFY( entity.value() == entity2.value() );

    QVERIFY (entity.load("ver") ); // Test will ver=1 be overridden.
    QVERIFY(entity.value() == "1");

}
