/**
  @author Ben Lau <xbenlau@gmail.com>
 */

#include <QtCore>
#include <QPainter>
#include <QMouseEvent>
#include "maemo5colorsvpicker.h"

Maemo5ColorSVPicker::Maemo5ColorSVPicker(QWidget *parent) :
    QWidget(parent)
{
    m_hue = m_saturation = m_value = 0;
    markerWidth = 0;
    markerWidth = 1;
}

void Maemo5ColorSVPicker::resizeEvent(QResizeEvent *event){
    updateMarker();
    QWidget::resizeEvent(event);
}

void Maemo5ColorSVPicker::paintEvent(QPaintEvent*){
//    qDebug() << metaObject()->className() << __func__;
    int w = width();
    int h = height();

    if (background.isNull() ||
        background.width() != w ||
        background.height() != h) {
        QImage image(w,h,QImage::Format_RGB32);

        qreal dx = 255 / (qreal) w;
        qreal dy = 255 / (qreal) h;
        qDebug() << dx << dy;
        qreal sat = 255;
        for (int y = 0; y < h ;y++ ){
            qreal value = 0;
            for (int x = 0; x < w; x++) {
                QColor c;
//                qDebug() << sat << value;
                c.setHsv(m_hue ,
                         sat,
                         value);
                image.setPixel(x,y,c.rgb());
                value += dx;
            }
            sat -= dy;
        }

        background = QPixmap::fromImage(image);
    }

    QPainter painter(this);
    painter.drawPixmap(0,0,background);

    QPen pen;
    pen.setColor(QColor(255,255,255,127));
    pen.setStyle(Qt::SolidLine);
    pen.setWidth(markerWidth);
    painter.setPen(pen);

    painter.drawLine(QPoint(marker.x() , 0),
                     QPointF(marker.x() , h));
    painter.drawLine(QPoint(0 , marker.y()),
                     QPointF(w ,marker.y()));

    painter.end();
}

void Maemo5ColorSVPicker::mouseMoveEvent(QMouseEvent *event){
    int x = event->pos().x();
    int y = event->pos().y();
    int w = width();
    int h = height();

    if (x < 0)
        x = 0;
    if (x > w)
        x = w;
    if (y < 0)
        y = 0;
    if (y > h)
        y = h;

    int s = yToSaturation(y);
    int v = xToValue(x);

    bool dirty = false;
    if (s != m_saturation) {
        dirty = true;
        m_saturation = s;

        emit saturationChanged(s);
    }
    if (v != m_value){
        dirty = true;
        m_value = v;
        emit valueChanged(v);
    }

    if (dirty)
        emit changed(s,v);

    marker = QPoint(x,y);
    update();
}

void Maemo5ColorSVPicker::mousePressEvent(QMouseEvent *event){
    int x = event->pos().x();
    int y = event->pos().y();

    int s = yToSaturation(y);
    int v = xToValue(x);

    bool dirty = false;
    if (s != m_saturation) {
        dirty = true;
        m_saturation = s;
        emit saturationChanged(s);
    }

    if (v != m_value){
        dirty = true;
        m_value = v;
        emit valueChanged(v);
    }

    if (dirty)
        emit changed(s,v);

    marker = QPoint(x,y);

//    update(QRect(0,0,width(),height()));
    repaint();
}

void Maemo5ColorSVPicker::setSaturation(int val){

    if (val!= m_saturation){
        m_saturation = val;
        emit saturationChanged(val);
        emit changed(val,m_value);

        updateMarker();
        update();
    }
}

int Maemo5ColorSVPicker::saturation(){
    return m_saturation;
}

void Maemo5ColorSVPicker::setValue(int val){
    if (val!= m_value){

        m_value = val;
        emit valueChanged(val);
        emit changed(m_saturation,val);
        updateMarker();
        update();
    }
}

int Maemo5ColorSVPicker::value(){
    return m_value;
}

void Maemo5ColorSVPicker::setHue(int val) {
    m_hue = val;
    background = QPixmap();
    update();
}

void Maemo5ColorSVPicker::updateMarker(){
    int y = saturationToY(m_saturation);
    int x = valueToX(m_value);

    marker = QPoint(x,y);
}

int Maemo5ColorSVPicker::yToSaturation(int y){
    int h = height();
    return 255 - ( y / (qreal) h ) * 255;
}

int Maemo5ColorSVPicker::xToValue(int x){
    int w = width();
    return ( x / (qreal) w ) * 255;
}

int Maemo5ColorSVPicker::saturationToY(int s){
    int h = height();

    return h - ( s / (qreal) 255) * h;
}

int Maemo5ColorSVPicker::valueToX(int v){
    int w = width();

    return (v / (qreal) 255) * w;
}
