/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QtCore>
#include <QResizeEvent>
#include "pppaperwidget.h"
#include "ppxmlpaper.h"

PPPaperWidget::PPPaperWidget(QWidget *parent) :
    QGraphicsView(parent)
{
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    QGraphicsScene *scene = new QGraphicsScene(this);
    setScene(scene);

    m_pencilBox = new PPPencilBox();
    scene->addItem(m_pencilBox);

    m_paper = new PPPaper();
    scene->addItem(m_paper);

    m_paper->setFlag(QGraphicsItem::ItemClipsToShape,true);
    m_paper->setFlag(QGraphicsItem::ItemClipsChildrenToShape,true);

    m_paper->setRect(QRect(0,0,100,100));

    m_pencilBox->setPaper(m_paper);


    QRect rect(0,0,
               size().width(),
               size().height());

    scene->setSceneRect(rect);
    m_paper->setRect(rect);
}

void PPPaperWidget::resizeEvent ( QResizeEvent * event ){
    QGraphicsScene *s = scene();
    QRect rect(0,0,
               event->size().width(),
               event->size().height());
    s->setSceneRect(rect);

    m_paper->setRect(rect);

    QGraphicsView::resizeEvent(event);
}

PPPencilBox *PPPaperWidget::pencilBox(){
    return m_pencilBox;
}

PPPaper *PPPaperWidget::paper(){
    return m_paper;
}

bool PPPaperWidget::setContent(QByteArray data){
    QDomDocument doc;
    if (doc.setContent(data)){
        PPXmlPaper xml;
        QDomElement paperElem = doc.firstChildElement("paper");
        xml.read(paperElem);
        xml.write(m_paper);
    }
    return false;
}

QByteArray PPPaperWidget::toByteArray(int indent) {
    QDomDocument doc;
    doc.setContent(QByteArray(""));

    PPXmlPaper xml;

    QDomElement paperElem = xml.read(m_paper);
    doc.appendChild(paperElem);

    return doc.toByteArray(indent);
}
