#ifndef PPGRAPHICSSTROKESNAPSHOT_H
#define PPGRAPHICSSTROKESNAPSHOT_H

#include <QVariantMap>
#include "ppgraphicsstroke.h"

/// Snapshot of PPGraphicsStroke
/**
   PPGraphicsStrokeSnapshot can save the state of a PPGraphicsStroke instance ,
   and copy the state to original or other instance.

   It is used for undo operation
 */
class PPGraphicsStrokeSnapshot : public QVariantMap
{
public:
    PPGraphicsStrokeSnapshot();

    /// Read from stroke
    void read(PPGraphicsStroke *stroke);

    /// Write the state to a stroke
    void write(PPGraphicsStroke *stroke);

};

#endif // PPGRAPHICSSTROKESNAPSHOT_H
