#ifndef PPERASER_H
#define PPERASER_H

#include <QGraphicsObject>

/// Eraser tool

class PPEraser : public QGraphicsObject
{
    Q_OBJECT
public:
    explicit PPEraser(QGraphicsItem *parent = 0);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 )  ;
    virtual QRectF boundingRect() const;

    void start(QGraphicsItem* canvas);

    void stop();

signals:
    /// It is emitted when an item is erased
    void erased();

public slots:

protected:
    virtual bool sceneEventFilter ( QGraphicsItem * watched, QEvent * event);

private:
    QGraphicsItem* m_canvas;
};

#endif // PPERASER_H
