#ifndef PAGEMODEL_H
#define PAGEMODEL_H

#include <QDirModel>
#include <string>
#include <QSignalMapper>
#include <QUrl>

#include "storage.h"
#include "pageentity.h"

/// Abstract Item model of page

class PageModel : public QAbstractItemModel
{
    Q_OBJECT
    public:
        PageModel (QObject *parent = NULL);
        virtual ~PageModel();

        /// Open a book
        bool open(int bookId);

        void clear();

        /// A new page
        void append(int pageId);
        void remove(int pageId);

        void refresh();


        void setThumbnailSize(const QSize &val);

        // AbstractItemModel functions

        int rowCount(const QModelIndex &parent = QModelIndex()) const;
        int columnCount(const QModelIndex &parent = QModelIndex()) const;

        QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
        QVariant data(const QModelIndex &index, int role) const;
        QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
        QModelIndex parent ( const QModelIndex & index ) const;

        Qt::ItemFlags flags ( const QModelIndex & index ) const;

        static int PageIdRole;

    public slots:

    private slots:

    private:
        QString pixmapCacheKey(int id) const;

        QSize m_thumbnailSize;

        QList<PageEntity> m_record;



};

#endif // PAGEMODEL_H
