/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QtCore>
#include "ppbackgroundmodeldialog.h"
#include "ui_ppbackgroundmodeldialog.h"

PPBackgroundModelDialog::PPBackgroundModelDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PPBackgroundModelDialog)
{
    ui->setupUi(this);
    m_model = new PPBackgroundModel();

    ui->listView->setModel(m_model);
}

PPBackgroundModelDialog::~PPBackgroundModelDialog()
{
    delete ui;
}

void PPBackgroundModelDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

PPBackgroundModel *PPBackgroundModelDialog::model(){
    return m_model;
}

PPBackground PPBackgroundModelDialog::selectedBackground(){
    PPBackground bg;
    QItemSelectionModel *sm = ui->listView->selectionModel();

    if (sm->hasSelection()){
        QModelIndex index = ui->listView->currentIndex();
        bg = m_model->backgroundAt(index.row());
    }

    return bg;
}

void PPBackgroundModelDialog::on_listView_activated(QModelIndex index)
{
    Q_UNUSED(index);
    accept();
}
