#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->svPicker->setHue(ui->hPicker->hue());

    connect(ui->hPicker,SIGNAL(hueChanged(int)),
            ui->svPicker,SLOT(setHue(int)));
    connect(ui->hPicker,SIGNAL(hueChanged(int)),
            ui->hue,SLOT(setValue(int)));
    connect(ui->hPicker,SIGNAL(hueChanged(int)),
            this,SLOT(updateColor()));

    connect(ui->svPicker,SIGNAL(changed(int,int)),
            this,SLOT(updateColor()));
    connect(ui->svPicker,SIGNAL(saturationChanged(int)),
            ui->saturation,SLOT(setValue(int)));
    connect(ui->svPicker,SIGNAL(valueChanged(int)),
            ui->value,SLOT(setValue(int)));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::updateColor(){
    QColor color;
    int h = ui->hPicker->hue();
    int s = ui->svPicker->saturation();
    int v = ui->svPicker->value();

    color.setHsv(h,s,v);
    QPalette p = ui->color->palette();
    p.setColor(QPalette::Window,color);
    ui->color->setPalette(p);
    ui->color->repaint();

}
