/*
 * This file is part of osso-abook-plugin-merge-contacts
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 * 
 * Header file with gui functions.
 */

#include "gui.h"
#include "appdata.h"


gchar *
touch_selector_print_account_func (HildonTouchSelector *selector, gpointer userdata) 
{
    GtkTreeIter iter;

    if (hildon_touch_selector_get_selected (HILDON_TOUCH_SELECTOR (selector), 0, &iter)) {
	Account *acc;
	GtkTreeModel *model;
	
	model = hildon_touch_selector_get_model (HILDON_TOUCH_SELECTOR (selector), 0);
	gtk_tree_model_get (model, &iter, 0, &acc, -1);

	if (acc) {
	    return g_strdup(acc->display_name);
	}
    }

    return NULL;
}

/**
 * Renderer for selector item of account name.
 */ 
void
renderer_account_name (GtkTreeViewColumn *tree_column,
               GtkCellRenderer   *cell,
               GtkTreeModel      *model,
               GtkTreeIter       *iter,
               gpointer           data)
{
    Account *acc;
    gtk_tree_model_get (model, iter, 0, &acc, -1);

    g_object_set (GTK_CELL_RENDERER (cell), "text", acc->display_name, NULL);
}


/**
 * Create selector for accounts.
 *
 * @accounts: GList with accounts (GList->data has Account type).
 */ 
GtkWidget *create_selector(GList *accounts, 
		void *renderer, 
		void *touch_selector_print_func) 
{
    GtkListStore *store;
    GList *items;
    GtkWidget *selector;
    HildonTouchSelectorColumn *column_name;
    GtkCellRenderer *renderer_name;
    
    
    store = gtk_list_store_new(1, G_TYPE_POINTER);
    items = g_list_first(accounts);
    while (items) {
	GtkTreeIter iter;

	gtk_list_store_append(store, &iter);
	gtk_list_store_set(store, &iter, 0, items->data, -1);
	
	items = g_list_next (items);
    }

   

    selector = hildon_touch_selector_new ();
    renderer_name = gtk_cell_renderer_text_new();
    hildon_touch_selector_set_print_func (
		    HILDON_TOUCH_SELECTOR (selector), 
		    (HildonTouchSelectorPrintFunc) touch_selector_print_func);
  
    hildon_touch_selector_set_model (HILDON_TOUCH_SELECTOR (selector), 0, GTK_TREE_MODEL (store));
    column_name = hildon_touch_selector_append_column (
		    HILDON_TOUCH_SELECTOR (selector), 
		    GTK_TREE_MODEL (store),
		    renderer_name, "text", 0, NULL);
    
    gtk_tree_view_column_pack_start (GTK_TREE_VIEW_COLUMN(column_name), renderer_name, TRUE); 
    gtk_tree_view_column_set_cell_data_func (GTK_TREE_VIEW_COLUMN(column_name), 
		    renderer_name, renderer, NULL, NULL);
    
    hildon_touch_selector_column_set_text_column (column_name, 0);
    
    return selector;
}

/**
 * Create picker button with selector.
 *
 */ 
GtkWidget *create_picker_button(GtkWidget *selector, gchar *text, gchar *value) 
{
    GtkWidget* picker_selector_button;
    picker_selector_button = hildon_picker_button_new(
		    HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(picker_selector_button), text, value);
    gtk_button_set_alignment(GTK_BUTTON(picker_selector_button), 0.0, 0.5);
    hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (picker_selector_button),
     		                                       HILDON_TOUCH_SELECTOR (selector));

    return picker_selector_button;
}

