#!/bin/sh
# preinst script for #PACKAGE#
#
# see: dh_installdeb(1)

set -e
changequote([{, }])dnl

PARENT_DIR=/usr/share/games
DATA_DIR=${PARENT_DIR}/openttd

ifelse(eval(MAEMO_MAJOR < 5), 1, [{
USE_CARD=
CARD_DATA_DIR=/media/mmc2/share/openttd

ask_for_card () {
	if [ -z "$DISPLAY" ]; then
		echo "No \$DISPLAY. Using rootfs for data files."
		return 0
	fi
	
	CARD_PRESENT=`gconftool-2 --get /system/osso/af/internal-mmc-device-present`
	if [ "x${CARD_PRESENT}" == "xtrue" ]; then
		echo "Internal MMC card found."
	else
		echo "No internal MMC card found. Using rootfs for data files."
		return 0
	fi
	
	cat > /tmp/openttd-confirm-text.txt <<EOF
Do you want to install OpenTTD data files to internal memory card?
Data files size is about 6 MB.

Press OK for installing to Internal Memory Card.
Press Cancel to install to Device Flash Memory.
EOF

	USE_CARD=1

	maemo-confirm-text "Installing to Internal Memory Card" \
		/tmp/openttd-confirm-text.txt \
		|| USE_CARD=

	if [ ${USE_CARD} ]; then
		echo "Ok. Installing to memory card."
	else
		echo "Installing to rootfs."
	fi

	rm /tmp/openttd-confirm-text.txt
}
}], [{
# Maemo 5 installs to /opt
USE_CARD=
CARD_DATA_DIR=/opt/openttd/

ask_for_card () {
	if [ -d /opt ]; then
		USE_CARD=1
	fi
}
}])

case "$1" in
    install)
		if [ -L "${DATA_DIR}" ]; then
			CURRENT_DATA_DIR=$(readlink -f "${DATA_DIR}")
			echo "Will reinstall files in ${CURRENT_DATA_DIR}"
		elif [ -d "${DATA_DIR}" ]; then
			echo "Will reinstall files in ${DATA_DIR}"
		else
			ask_for_card
			if [ ${USE_CARD} ]; then
				echo "Installing to ${CARD_DATA_DIR}..."
				mkdir -p "${PARENT_DIR}"
				mkdir -p "${CARD_DATA_DIR}"
				ln -s "${CARD_DATA_DIR}" "${DATA_DIR}"
			else
				echo "Installing to ${DATA_DIR}..."
				mkdir -p "${DATA_DIR}"
			fi
		fi
    ;;
    
    upgrade)
		if [ -L "${DATA_DIR}" ]; then
			CURRENT_DATA_DIR=$(readlink -f "${DATA_DIR}")
			echo "Will reinstall files in ${CURRENT_DATA_DIR}"
		elif [ -d "${DATA_DIR}" ]; then
			echo "Will reinstall files in ${DATA_DIR}"
		else
			echo "Something is wrong. ${DATA_DIR} is not a directory."
			exit 1
		fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

#DEBHELPER#

exit 0

