#!/usr/bin/python2.5
# -*- coding: utf-8 -*-

from urllib import urlencode
from urllib2 import Request, urlopen
from re import compile, findall, DOTALL, IGNORECASE, search
from time import strptime, mktime
from datetime import datetime, timedelta

stations = ["Aachen Hbf", "Aachen West", "Aalten", "Abcoude", "Ahaus", "Aime-La-Plagne", "Akkrum", "Albertville", "Alkmaar", "Alkmaar Noord", "Almelo", "Almelo De Riet", "Almere", "Almere Buiten", "Almere Centrum", "Almere Muziekwijk", "Almere Oostvaarders", "Almere Parkwijk", "Alphen A/D Rijn", "Altenberge", "Amersfoort", "Amersfoort Schothorst", "Amersfoort Vathorst", "Amsterdam", "Amsterdam Amstel", "Amsterdam Bijlmer Arena", "Amsterdam Centraal", "Amsterdam Holendrecht", "Amsterdam Lelylaan", "Amsterdam Muiderpoort", "Amsterdam Rai", "Amsterdam Science Park", "Amsterdam Sloterdijk", "Amsterdam Zuid", "Angermuende", "Anna Paulowna", "Antwerpen-Centraal", "Apeldoorn", "Apeldoorn De Maten", "Apeldoorn Osseveld", "Appingedam", "Arkel", "Arnemuiden", "Arnhem", "Arnhem Presikhaaf", "Arnhem Velperpoort", "Arnhem Zuid", "Assen", "Augsburg Hbf", "Avignon Tgv", "Baarn", "Bad Bentheim", "Baden", "Baden-Baden", "Baflo", "Barendrecht", "Barneveld Centrum", "Barneveld Noord", "Basel Bad Bf", "Basel Sbb", "Bedum", "Beek-Elsloo", "Beesd", "Beilen", "Bergen Op Zoom", "Berlin Hbf.-Lehrter Bahnhof", "Berlin Ostbahnhof", "Berlin-Gesundbrunnen", "Berlin-SchöNefeld Flughafen", "Berlin-Spandau", "Bernau (B Berlin)", "Best", "Beverwijk", "Bilthoven", "Blerick", "Bloemendaal", "Bodegraven", "Boenen", "Boisheim", "Bonn Hbf", "Borghorst (Westf)", "Bork (Westf)", "Borne", "Boskoop", "Bourg-St-Maurice", "Bovenkarspel Flora", "Bovenkarspel-Grootebroek", "Boxmeer", "Boxtel", "Breda", "Breda-Prinsenbeek", "Bremen Hbf", "Bressoux", "Breukelen", "Breyell", "Brummen", "Brussel-Centraal", "Brussel-Noord", "Brussel-Zuid/Midi", "Buitenpost", "Bunde", "Bunnik", "Burgsteinfurt", "Bussum Zuid", "Capelle Schollevaar", "Castricum", "Chambery", "Chevremont", "Coesfeld (Westf)", "Coevorden", "Cuijk", "Culemborg", "Daarlerveen", "Dalen", "Dalfsen", "De Eschmarke", "De Vink", "Deinum", "Delden", "Delft", "Delft Zuid", "Delfzijl", "Delfzijl West", "Den Bosch", "Den Bosch Oost", "Den Dolder", "Den Haag", "Den Haag Centraal", "Den Haag Hs", "Den Haag Laan V Noi", "Den Haag Mariahoeve", "Den Haag Moerwijk", "Den Haag Ypenburg", "Den Helder", "Den Helder Zuid", "Deurne", "Deventer", "Deventer Colmschate", "Deventer De Scheg", "Didam", "Diemen", "Diemen Zuid", "Dieren", "Doetinchem", "Doetinchem-De Huet", "Dordrecht", "Dordrecht Stadspolders", "Dordrecht Zuid", "Dortmund Hbf", "Dortmund-Derne", "Dortmund-Kirchderne", "Driebergen-Zeist", "Driehuis", "Dronrijp", "Duelken", "Duelmen", "Duesseldorf Hbf", "Duisburg Hbf", "Duiven", "Duivendrecht", "Eberswalde Hbf", "Echt", "Ede Centrum", "Ede-Wageningen", "Eijsden", "Eindhoven", "Eindhoven Beukenlaan", "Ekeren", "Elst", "Emmen", "Emmen Bargeres", "Emmerich", "Enkhuizen", "Ennepetal (Gevelsberg)", "Enschede", "Enschede Drienerlo", "Epe (Westf)", "Ermelo", "Essen (Belgie)", "Etten-Leur", "Eygelshoven", "Eygelshoven Markt", "Franeker", "Frankfurt (M) Hbf", "Frankfurt Flughafen Fernbf", "Freiburg (Breisgau) Hbf", "Gaanderen", "Geerdijk", "Geislingen", "Geldermalsen", "Geldrop", "Geleen Oost", "Geleen-Lutterade", "Gilze-Rijen", "Glanerbrug", "Goeppingen", "Goes", "Goor", "Gorinchem", "Gouda", "Gouda Goverwelle", "Gramsbergen", "Grijpskerk", "Gronau Westf", "Groningen", "Groningen Europapark", "Groningen Noord", "Grou-Jirnsum", "GüNzburg", "Haarlem", "Haarlem Spaarnwoude", "Hagen Hbf", "Hamburg Hbf", "Hamm (Westf.)", "Hannover Hbf", "Harde ('T)", "Hardenberg", "Harderwijk", "Hardinxveld-Giessendam", "Haren", "Harlingen", "Harlingen Haven", "Heemskerk", "Heemstede-Aerdenhout", "Heerenveen", "Heerenveen Ijsstadion", "Heerhugowaard", "Heerlen", "Heerlen De Kissel", "Heeze", "Heide", "Heiloo", "Heino", "Helmond", "Helmond 'T Hout", "Helmond Brandevoort", "Helmond Brouwhuis", "Hemmen-Dodewaard", "Hengelo", "Hengelo Oost", "Hertogenb ('S) Oost", "Hertogenbosch ('S)", "Herzogenrath", "Hillegom", "Hilversum", "Hilversum Noord", "Hilversum Sportpark", "Hindeloopen", "Hoek Van Holland Haven", "Hoek Van Holland Strand", "Hoensbroek", "Hollandsche Rading", "Holten", "Holtwick", "Holzwickede", "Hoofddorp", "Hoogeveen", "Hoogezand-Sappemeer", "Hoogkarspel", "Hoorn", "Hoorn Kersenboogerd", "Horst-Sevenum", "Houten", "Houten Castellum", "Houthem-St Gerlach", "Hurdegaryp", "Kaldenkirchen", "Kalmthout", "Kampen", "Kapelle-Biezelinge", "Kapellen", "Karlsruhe Hbf", "Kerkrade Centrum", "Kesteren", "Keulen", "Klarenbeek", "Klimmen-Ransdaal", "Koblenz Hbf", "Koeln Deutz", "Koeln Hbf", "Koeln-Ehrenfeld", "Kohlscheid", "Koog Bloemwijk", "Koog-Zaandijk", "Koudum-Molkwerum", "Krabbendijke", "Krommenie-Assendelft", "Kropswolde", "Kruiningen-Yerseke", "Lage Zwaluwe", "Landgraaf", "Landry", "Leer (Ostfriesland)", "Leerdam", "Leeuwarden", "Leeuwarden Camminghaburen", "Legden", "Leiden", "Leiden Centraal", "Leiden Lammenschans", "Lelystad Centrum", "Lette (Kr Coesfeld)", "Lichtenvoorde-Groenlo", "Liege-Guillemins", "Lochem", "Loppersum", "Luedinghausen", "Luenen Hbf", "Lunteren", "Maarn", "Maarssen", "Maassluis", "Maassluis West", "Maastricht", "Maastricht Randwyck", "Mainz Hbf", "Mannheim Hbf", "Mantgum", "Marienberg", "Marne-La-Vallee-Chessy", "Marseille-St-Charles", "Martenshoek", "Mechelen", "Meerssen", "Meppel", "Metelen Land", "Middelburg", "Minden (Westf.)", "Moenchengladbach Hbf", "Mook Molenhoek", "Moutiers-Salins-Brides", "Muenchen Hbf", "Muenster (W) Zentrum Nord", "Muenster (Westf) Hbf", "Muenster-HäGer", "Naarden-Bussum", "Neuss Hbf", "Nieuw Amsterdam", "Nieuw Vennep", "Nieuwerkerk Ad Ijssel", "Nieuweschans", "Nijkerk", "Nijmegen", "Nijmegen Dukenburg", "Nijmegen Heyendaal", "Nijmegen Lent", "Nijverdal", "Nijverdal West", "Nordwalde", "Nunspeet", "Nuth", "Obdam", "Oberhausen Hbf", "Ochtrup", "Offenburg", "Oisterwijk", "Oldenburg (Oldb) Hbf", "Oldenzaal", "Olst", "Ommen", "Onze Lieve Vrouwe Ter Nood", "Oosterbeek", "Opheusden", "Osnabrueck Hbf", "Oss", "Oss West", "Oudenbosch", "Overveen", "Parijs", "Paris-Nord", "Plochingen", "Preussen", "Pulheim", "Purmerend", "Purmerend Overwhere", "Purmerend Weidevenne", "Putten", "Raalte", "Ravenstein", "Reuver", "Rheden", "Rheine", "Rhenen", "Rijssen", "Rijswijk", "Rilland-Bath", "Roermond", "Rommerskirchen", "Roodeschool", "Roosendaal", "Rosmalen", "Rotterdam", "Rotterdam Alexander", "Rotterdam Blaak", "Rotterdam Centraal", "Rotterdam Lombardijen", "Rotterdam Noord", "Rotterdam Stadion", "Rotterdam Zuid", "Ruurlo", "Santpoort Noord", "Santpoort Zuid", "Sappemeer Oost", "Sauwerd", "Schagen", "Scheemda", "Schiedam Centrum", "Schiedam Nieuwland", "Schin Op Geul", "Schinnen", "Schiphol", "Schwelm", "Schwerte (Ruhr)", "Selm", "Selm-Beifang", "Siegburg", "Sittard", "Sliedrecht", "Sneek", "Sneek Noord", "Soest", "Soest Zuid", "Soestdijk", "Spaubeek", "Spoorwegmuseum", "Stavoren", "Stedum", "Steenwijk", "Stendal", "Stolberg Altstadt", "Stolberg Hbf", "Stommeln", "Stuttgart Hbf", "Susteren", "Swalmen", "Szczecin Glowny", "Szczecin Gumience", "Tegelen", "Terborg", "Tiel", "Tiel Passewaaij", "Tilburg", "Tilburg Reeshof", "Tilburg West", "Twello", "Uitgeest", "Uithuizen", "Uithuizermeeden", "Ulm Hbf", "Unna", "Usquert", "Utrecht", "Utrecht Centraal", "Utrecht Lunetten", "Utrecht Maliebaan", "Utrecht Overvecht", "Utrecht Terwijde", "Utrecht Zuilen", "Valence Tgv", "Valkenburg", "Varsseveld", "Veenendaal Centrum", "Veenendaal West", "Veenendaal-De Klomp", "Veenwouden", "Velp", "Venlo", "Venray", "Vierlingsbeek", "Viersen", "Vise", "Vlaardingen Centrum", "Vlaardingen Oost", "Vlaardingen West", "Vleuten", "Vlissingen", "Vlissingen Souburg", "Voerendaal", "Voorburg", "Voorhout", "Voorschoten", "Voorst-Empe", "Vorden", "Vriezenveen", "Vroomshoop", "Vught", "Waddinxveen", "Waddinxveen Noord", "Warffum", "Weener", "Weert", "Weesp", "Wehl", "Wezep", "Wien Westbf", "Wierden", "Wijchen", "Wijhe", "Winschoten", "Winsum", "Winterswijk", "Winterswijk West", "Woerden", "Wolfheze", "Wolfsburg", "Wolvega", "Workum", "Wormerveer", "Wuppertal Hbf", "Wuppertal Oberbarmen", "Wuppertal-Barmen", "Zaandam", "Zaandam Kogerveld", "Zaltbommel", "Zandvoort Aan Zee", "Zetten-Andelst", "Zevenaar", "Zevenbergen", "Zoetermeer", "Zoetermeer Oost", "Zuerich Hb", "Zuidbroek", "Zuidhorn", "Zutphen", "Zwaagwesteinde", "Zwijndrecht", "Zwolle"]

def remove_html_tags(data):
    p = compile(r'<.*?>|&nbsp;')
    return p.sub('', data)

class NSClientException(Exception):
    pass

class NSClient():
    def __init__(self):
        self.URL = "http://m.ns.nl/planner.action"
        self.numberOfResults = 1
        self.clear()

    def fetch_data(self):
        if not (self.fromStation and self.toStation and self.date and self.time):
            raise NSClientException, "At least Departure, Destination Stations and Date and Time information must be provided"
            return
        
        data = {'from': unicode(self.fromStation, 'utf-8').encode("iso-8859-1"),
                'to': unicode(self.toStation, 'utf-8').encode("iso-8859-1"),
                'via': self.viaStation,
                'date': self.date[:5],
                'time': self.time,
                'departure': self.departure,
                'hsl': 'true',
                'planroute': 'Journey+advice'}

        data = urlencode(data)
        req = Request(self.URL, data)
        response = urlopen(req)
        data = response.read()
        self.saved_page = data
        
        errors = search('<div id="errors">.+?</div>', data, DOTALL+IGNORECASE)
        if errors:
            raise NSClientException, remove_html_tags(errors.group(0))
            return
        
        if "Error" in data:
            raise NSClientException, "Undefined error"
            return	
        
        result = self.parseResponse(data)

        if len(result) == 0:
            raise NSClientException, "No journey information available"
            
        return result

    def get_saved_page(self):
        return self.saved_page
    
    def fetch_next(self):
        # check if we have cached result
        if self.index < len(self.results)-1 and self.index > -1:
            self.index += 1
            return self.results[self.index]
    
        else:
            if len(self.results) > 0:
                lastResult = self.results[-1][-1]
                try:
                    dateObject = datetime(*strptime("%s %s" % (lastResult['departureTime'], self.date), "%H:%M %d-%m-%Y")[:6])
                    dateObject += timedelta(minutes=1+lastResult['departureExtraTime'])
                except Exception, details:
                    print details
                    print dateObject
                    raise NSClientException, (details, dateObject)

                self.time = "%.2d:%.2d" % (dateObject.hour, dateObject.minute)
                self.date = "%.2d-%.2d-%.2d" % (dateObject.day, dateObject.month, dateObject.year) 

            result = self.fetch_data()
             
            self.results.append(result)
            self.index += 1
            
            return self.results[self.index]
    
    def fetch_prev(self):
        tmp = self.departure 
        self.departure = False

        if len(self.results) < 0:
            # raise exception
            raise NSClientException, "Cannot fetch previous journey now"
            return
            
        # check if we have cached result
        if self.index > 0:
            self.index -= 1
            self.departure = tmp
            return self.results[self.index]
            
        else:
            lastResult = self.results[0][-1]
            try:
                dateObject = datetime(*strptime("%s %s" % (lastResult['arrivalTime'], self.date), "%H:%M %d-%m-%Y")[:6])
                dateObject -= timedelta(minutes=1+lastResult['arrivalExtraTime'])
            except Exception, details:
                print page
                print details
                print dateObject   
                raise NSClientException, details
                
            self.time = "%.2d:%.2d" % (dateObject.hour, dateObject.minute)
            self.date = "%.2d-%.2d-%.2d" % (dateObject.day, dateObject.month, dateObject.year) 
            
            result = self.fetch_data()
            
            self.departure = tmp
            self.results.insert(0,result)
            self.index = 0
            
            return self.results[self.index]
    
    def clear(self):
        self.toStation = None
        self.fromStation = None
        self.viaStation = None
        self.date = None
        self.time = None
        self.departure = True
        self.results = []
        self.index = -1
        
    
    def set_data(self, toStation, fromStation, viaStation="", date=None, time=None, departure=True):
    
        toStation = toStation.title()
        fromStation = fromStation.title()
        viaStation = viaStation.title()
    
        if toStation not in stations:
            raise NSClientException, "Please select a valid arrival station from the list '%s'" % toStation
        else:
            self.toStation = toStation
        
        if fromStation not in stations:
            raise NSClientException, "Please select a valid departure station from the list '%s'" % fromStation
        else:
            self.fromStation = fromStation

        
        if (viaStation not in stations) and (viaStation is not ""):
            raise NSClientException, "Please select a valid via station from the list"
        else:
            self.viaStation = viaStation
        
        if toStation == fromStation:
            raise NSClientException, "Departure station cannot be the same as arrival station"

        self.toStation = toStation
        self.fromStation = fromStation
        self.viaStation = viaStation
        
        if not date:
            self.date = datetime.now().strftime("%d-%m-%Y")
        else:
            date = strptime(date, "%d-%m-%Y")
            self.date = "%.2d-%.2d-%.4d" % (date.tm_mday, date.tm_mon, date.tm_year)

        if not time:
            self.time = datetime.now().strftime("%H:%M")
        else:
            time = strptime(time, "%H:%M")
            self.time = "%.2d:%.2d" % (time.tm_hour, time.tm_min)

    def parseResponse(self, page):
        results = []
        regexed = findall('D&#160;(?P<dtime>\d{2}:\d{2}).+?(?:<font color="red">\+&#160;(?P<dextratime>\d+) min</font>.+?)?actvertrektijden.+?">(?P<dstation>.+?)</a>(?:&#160;&#160;)?(?:platform&#160;(?:<font color="red"><b><u>)?(?P<dplatform>[\d\w -]+))?(?:&#160;&#160;)?.+?<td colspan="2">(?P<train>[\w ]+).+?<b>A&#160;(?P<atime>\d{2}:\d{2})</b>.+?<b>(?:<font color="red">\+&#160;(?P<aextratime>\d+) min</font>&#160;)?(?P<astation>.+?)&#160;(?:&#160;platform&#160;(?:<font color="red"><b><u>)?(?P<aplatform>[\d\w -]+))?', page, DOTALL+IGNORECASE)
        
        if len(regexed) == 0:
            print page
            print "Error regex"
            return page        
        
        try:
            for i in range(len(regexed)):
                result = {}
                
                result['departureStation']  = regexed[i][2]
                result['departureTime'] = regexed[i][0]
                try:
                    result['departureExtraTime'] = int(regexed[i][1])
                except ValueError:
                    result['departureExtraTime'] = 0
                result['departurePlatform'] = regexed[i][3]
    
                result['arrivalStation']  = regexed[i][7]
                result['arrivalTime'] = regexed[i][5]
                try:
                    result['arrivalExtraTime'] = int(regexed[i][6])
                except ValueError:
                    result['arrivalExtraTime'] = 0
                result['arrivalPlatform'] = regexed[i][8]
                
                result['typeTrain'] = regexed[i][4]
                
                results.append(result)        
            
            if 'Attention' in page:
                result['attention'] = True
            else:
                result['attention'] = False 
        except Exception, error:
            print page
            print regexed
            print "Error: ", error
            raise
        
        return results


if __name__ == "__main__":
    print "This is only a library"
