/*
 * Copyright (C) 2003 Robert Kooima - 2006 Jean Privat
 * Part of the Neverball Project http://icculus.org/neverball/
 *
 * NEVERBALL is  free software; you can redistribute  it and/or modify
 * it under the  terms of the GNU General  Public License as published
 * by the Free  Software Foundation; either version 2  of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT  ANY  WARRANTY;  without   even  the  implied  warranty  of
 * MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
 * General Public License for more details.
 */


#include <string.h>

#include "gui.h"
#include "geom.h"
#include "part.h"
#include "audio.h"
#include "config.h"
#include "video.h"

#include "st_resol.h"

extern struct state  st_null;
static struct state *st_back;

static SDL_Rect **modes;

/*---------------------------------------------------------------------------*/

#define RESOL_BACK -1

static int resol_action(int i)
{
    int r = 1;

    audio_play("snd/menu.ogg", 1.0f);

    switch (i)
    {
    case RESOL_BACK:
        goto_state(st_back);
        st_back = NULL;
        break;

    default:
        goto_state(&st_null);
        r = video_mode(config_get_d(CONFIG_FULLSCREEN),
                       modes[i]->w, modes[i]->h);
        goto_state(&st_resol);
        break;
    }

    return r;
}

static int fill_row(int id, SDL_Rect **modes, int i, int n)
{
    int complete;

    if (n == 0)
        return 1;

    if (modes[i])
    {
        char label[20];

        sprintf(label, "%d x %d", modes[i]->w, modes[i]->h);

        complete = fill_row(id, modes, i + 1, n - 1);

        gui_state(id, label, GUI_SML, i,
                  config_get_d(CONFIG_WIDTH)  == modes[i]->w &&
                  config_get_d(CONFIG_HEIGHT) == modes[i]->h);
    }
    else
    {
        for (; n; gui_space(id), n--);
        complete = 0;
    }

    return complete;
}

static int resol_gui(void)
{
    int id, jd;

    if ((id = gui_vstack(0)))
    {
        if ((jd = gui_harray(id)))
        {
            gui_label(jd, _("Resolution"), GUI_SML, GUI_ALL, 0, 0);
            gui_space(jd);
            gui_start(jd, _("Back"),       GUI_SML, RESOL_BACK, 0);
        }

        gui_space(id);

        if (modes)
        {
            int i;

            for (i = 0; fill_row(gui_harray(id), modes, i, 4); i += 4);
        }

        gui_layout(id, 0, 0);
    }

    return id;
}

static int resol_enter(struct state *st, struct state *prev)
{
    if (!st_back)
    {
        /* Note the parent screen if not done yet. */

        st_back = prev;
    }

    back_init("back/gui.png");

    modes = SDL_ListModes(NULL, SDL_OPENGL | SDL_FULLSCREEN);

    if (modes == (SDL_Rect **) -1)
        modes = NULL;

    audio_music_fade_to(0.5f, "bgm/inter.ogg");

    return resol_gui();
}

static void resol_leave(struct state *st, struct state *next, int id)
{
    back_free();
    gui_delete(id);
}

static void resol_paint(int id, float st)
{
    video_push_persp((float) config_get_d(CONFIG_VIEW_FOV), 0.1f, FAR_DIST);
    {
        back_draw_easy();
    }
    video_pop_matrix();
    gui_paint(id);
}

static void resol_timer(int id, float dt)
{
    gui_timer(id, dt);
}

static void resol_point(int id, int x, int y, int dx, int dy)
{
    gui_pulse(gui_point(id, x, y), 1.2f);
}

static void resol_stick(int id, int a, float v, int bump)
{
    gui_pulse(gui_stick(id, a, v, bump), 1.2f);
}

static int resol_click(int b, int d)
{
    if (b == SDL_BUTTON_LEFT && d == 1)
        return resol_action(gui_token(gui_click()));
    return 1;
}

static int resol_keybd(int c, int d)
{
    return (d && c == SDLK_ESCAPE) ? resol_action(RESOL_BACK) : 1;
}

static int resol_buttn(int b, int d)
{
    if (d)
    {
        if (config_tst_d(CONFIG_JOYSTICK_BUTTON_A, b))
            return resol_action(gui_token(gui_click()));
        if (config_tst_d(CONFIG_JOYSTICK_BUTTON_B, b))
            return resol_action(RESOL_BACK);
        if (config_tst_d(CONFIG_JOYSTICK_BUTTON_EXIT, b))
            return resol_action(RESOL_BACK);
    }
    return 1;
}

/*---------------------------------------------------------------------------*/


struct state st_resol = {
    resol_enter,
    resol_leave,
    resol_paint,
    resol_timer,
    resol_point,
    resol_stick,
    NULL,
    resol_click,
    resol_keybd,
    resol_buttn
};

