/*
 *  Nameday desktop applet (widget) for Maemo.
 *  Copyright (C) 2009 Roman Moravcik
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NAMEDAY_DBPARSER_H
#define NAMEDAY_DBPARSER_H

#include <hildon/hildon.h>

#include "nameday_applet.h"

enum {
	COLUMN_DAY = 0,
	COLUMN_MONTH,
	COLUMN_DATE,
	COLUMN_NAME
};

enum {
	COLUMN_DB_NAME = 0,
	COLUMN_DB_FILENAME
};

void nameday_dbparser_open (NamedayDesktopApplet *priv);
void nameday_dbparser_close (NamedayDesktopApplet *priv);

gchar* nameday_dbparser_get_name_from_date (NamedayDesktopApplet *priv,
					    const gchar search_day,
					    const gchar search_month);

GtkListStore* nameday_dbparser_liststore_create (NamedayDesktopApplet *priv);
GtkListStore* nameday_dbparser_calendar_list_create (NamedayDesktopApplet *priv);

void nameday_dbparser_init (NamedayDesktopApplet *priv);
void nameday_dbparser_finalize (NamedayDesktopApplet *priv);

#endif
