from PyQt4.QtCore import pyqtSignature
from PyQt4.QtGui import QDialog
from Ui_SettingsDialog import Ui_SettingsDialog

class SettingsDialog(QDialog, Ui_SettingsDialog):

    def __init__(self, parent, settings):
        QDialog.__init__(self, parent)
        Ui_SettingsDialog.setupUi(self, self)
        self.__settings = settings

        self.trebleClefCheckBox.setChecked(self.__settings.useTrebleClef())
        self.bassClefCheckBox.setChecked(self.__settings.useBassClef())
        self.altoClefCheckBox.setChecked(self.__settings.useAltoClef())

        self.beginnerRadioButton.setChecked(self.__settings.getLevel() == "beginner")
        self.intermediateRadioButton.setChecked(self.__settings.getLevel() == "intermediate")
        self.advancedRadioButton.setChecked(self.__settings.getLevel() == "advanced")

    @pyqtSignature("")
    def on_saveButton_clicked(self):
        print "save"
        if((not self.trebleClefCheckBox.isChecked()) and (not self.bassClefCheckBox.isChecked()) and (not self.altoClefCheckBox.isChecked())):
            print "Notify error, please"
        else:
            level = "beginner"
            if(self.intermediateRadioButton.isChecked()):
                level = "intermediate"
            if(self.advancedRadioButton.isChecked()):
                level = "advanced"
            self.__settings.store(self.trebleClefCheckBox.isChecked(), self.bassClefCheckBox.isChecked(), self.altoClefCheckBox.isChecked(), level)
            self.hide()
