from PyQt4.QtGui import QMainWindow, QGraphicsScene, QGraphicsPixmapItem, QPixmap
from PyQt4.QtCore import pyqtSignature, Qt
from Ui_MainWindow import Ui_MainWindow
from TestWindow import TestWindow
from SettingsDialog import SettingsDialog
from Settings import Settings
import sys

class MainWindow(QMainWindow, Ui_MainWindow):
    def __init__(self, parent = None):
        QMainWindow.__init__(self, parent)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
        except:
            pass
        self.settings = Settings()

    def setupUi(self, mainwnd):
        super(MainWindow, self).setupUi(mainwnd)
        scene = QGraphicsScene(self)
        scene.addItem(QGraphicsPixmapItem(QPixmap(sys.path[0] + "/ui/main.png")))
        self.graphicsView.setScene(scene)

    @pyqtSignature("")
    def on_practiceButton_clicked(self):
        win=TestWindow(self, self.settings, True)
        win.setupUi(win)
        win.show()

    @pyqtSignature("")
    def on_testButton_clicked(self):
        win=TestWindow(self, self.settings, False)
        win.setupUi(win)
        win.show()

    @pyqtSignature("")
    def on_actionSettings_triggered(self):
        dialog = SettingsDialog(self, self.settings)
        dialog.exec_()
