import operator
import sys

class Clef():

    def __init__(self, clef, resource, beginnerRange, intermediateRange, advancedRange, firstNote):
        self.__clef = clef
        self.__resource = resource
        self.__beginnerRange = beginnerRange
        self.__intermediateRange = intermediateRange
        self.__advancedRange = advancedRange
        self.__firstNote = firstNote
        
    def getBeginnerRange(self):
        return self.__beginnerRange
        
    def getIntermediateRange(self):
        return self.__intermediateRange
        
    def getAdvancedRange(self):
        return self.__advancedRange
        
    def getResource(self):
        return self.__resource
    
    def asLetter(self, note):
        m = operator.mod(note + self.__firstNote - 1, 7)
        if m == 1:
            return "C"
        elif m == 2:
            return "D"
        elif m == 3:
            return "E"
        elif m == 4:
            return "F"
        elif m == 5:
            return "G"
        elif m == 6:
            return "A"
        else:
            return "B"

    def __eq__(self, other):
        if self.__clef == other.__clef:
            return True
        return False

    def __str__(self):
        return "Clef " + self.__clef

class Clefs():        
    TREBLE = Clef("treble", sys.path[0] + "/ui/clef_treble.png", range(6, 13), range(6, 20), range(1, 24), 3)
    BASS = Clef("bass", sys.path[0] + "/ui/clef_bass.png", range(11, 18), range(4, 18), range(1, 24), 5)
    ALTO = Clef("alto", sys.path[0] + "/ui/clef_alto.png", range(9, 16), range(5, 19), range(1, 24), 4)
