// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ITEMMODELSORTCLIENT_H
#define ITEMMODELSORTCLIENT_H

#include <QObject>

class ItemModelSortController;
class QAbstractItemModel;
class ItemModelSortProxy;

class ItemModelSortClient : public QObject
{
    Q_OBJECT
public:
    explicit ItemModelSortClient(ItemModelSortController *, QObject *parent = 0);

public:
    void Sort(QAbstractItemModel *model, int task_id, bool intermediate);

public:
    Q_SIGNAL void SortFinished(QAbstractItemModel *model, int task_id, bool intermediate);

private:
    Q_SLOT void SortFinished(QAbstractItemModel *model);

private:
    Q_SIGNAL void Sort(QAbstractItemModel *);

private:
    ItemModelSortProxy *_proxy;
    QAbstractItemModel *_model;
    int _task_id;
    bool _intermediate;
};

#endif // ITEMMODELSORTCLIENT_H
