// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "searchclientsemaphore.h"

static const int INVALID_ID = -1;

SearchClientSemaphore::SearchClientSemaphore()
    : _mutex(),
    _active_search_task_id(INVALID_ID)
{
}

void SearchClientSemaphore::Activate(int search_task_id)
{
    _active_search_task_id = search_task_id;
}

bool SearchClientSemaphore::IsActive(int search_task_id)
{
    return _active_search_task_id == search_task_id;
}

void SearchClientSemaphore::CancelAll()
{
    _active_search_task_id = INVALID_ID;
}
