// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef LOCATION_H
#define LOCATION_H

#include <QString>
#include <QMetaType>

class Location
{
public:
    Location();

    bool IsValid() const { return !_location_name.isEmpty(); }

    QString GetLocationName() const { return _location_name; }
    void SetLocationName(const QString &location_name) { _location_name = location_name; }

private:
    QString _location_name;
};

bool operator==(const Location &lhs, const Location &rhs);

bool operator!=(const Location &lhs, const Location &rhs);

Q_DECLARE_METATYPE(Location);

#endif // LOCATION_H
