/*
 *  Medard for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <QtGui>

#include "aboutdialog.h"

AboutDialog::AboutDialog(QDialog *parent) : QDialog(parent)
{
    setWindowTitle(tr("About"));

    QVBoxLayout *layout = new QVBoxLayout();
    layout->setMargin(16);
    layout->setSpacing(16);
    setLayout(layout);

    QLabel *application = new QLabel();
    QFont font = application->font();
    font.setBold(true);
    font.setPointSize(32);
    application->setFont(font);
    application->setText("Medard 0.1");
    application->setAlignment(Qt::AlignCenter);
    layout->addWidget(application);

    QLabel *applicationCopyright = new QLabel();
    applicationCopyright->setText(tr("Copyright(c) 2011 Roman Moravcik"));
    applicationCopyright->setAlignment(Qt::AlignCenter);
    layout->addWidget(applicationCopyright);

    QLabel *weatherDataCopyright = new QLabel();
    weatherDataCopyright->setText(tr("\n"
                                  "Weather data:\n"
                                  "Project MEDARD, Institute of Computer Science,\n"
                                  "Academy of Sciences of the Czech Republic, Prague\n"
                                  "\n"
                                  "Copyright(c) Institute of Computer Science AS CR 2003-2009.\n"
                                  "MM5: PSU/NCAR, USA (c) CAMx: EVNIRON Corp., USA"));
    layout->addWidget(weatherDataCopyright);

}
