#ifndef SCROLLABLEPAGE_H
#define SCROLLABLEPAGE_H

#include <QGraphicsWidget>
#include <QAbstractKineticScroller>
#include <QGraphicsWebView>
#include <QWebFrame>
#include <QTime>

//QGraphicsWebView subclassed to remove contextmenu
class GraphicsWebView : public QGraphicsWebView{
public:
    GraphicsWebView(QGraphicsItem *parent = 0) : QGraphicsWebView(parent){}
protected:
    void contextMenuEvent(QGraphicsSceneContextMenuEvent *event){
        QGraphicsWidget::contextMenuEvent(event);
    }
};
    

class ScrollablePage : public QGraphicsWidget, public QAbstractKineticScroller{
    Q_OBJECT
public:
    ScrollablePage(QGraphicsItem *parent = 0, Qt::WindowFlags wFlags = 0);
    QRectF boundingRect() const;
    void setPage(QWebPage*);
    void setPosition(int);
    int getPosition();
    void scrollToAnchor(const QString&);
    void scrollBy(int);

private:
    QGraphicsWebView *content;

protected:
   void mousePressEvent(QGraphicsSceneMouseEvent*);
   void mouseReleaseEvent(QGraphicsSceneMouseEvent*);
   void mouseMoveEvent(QGraphicsSceneMouseEvent*);
   void mouseDoubleClickEvent(QGraphicsSceneMouseEvent*);
   bool sceneEventFilter(QGraphicsItem*, QEvent*);

   QSize viewportSize() const;
   QPoint maximumScrollPosition() const;
   QPoint scrollPosition() const;
   void setScrollPosition(const QPoint&, const QPoint&);
   QPoint overShoot;
   QTime time;

signals:
    void positionChanged(int);
};

#endif
