#ifndef BOOKPROGRESSSLIDER_H
#define BOOKPROGRESSSLIDER_H

#include <QSlider>
#include <QPainter>
#include <QStyle>
#include <QStyleOptionSlider>
#include <QMouseEvent>

//BookProgressSlider is the widget shown at the bottom of the screen in reading UI,
//It shows current progress in book and allow jumping from position to another.
class BookProgressSlider : public QSlider{
    Q_OBJECT
public:
    BookProgressSlider(QWidget *parent = 0) : QSlider(parent), 
        color("#333333"), 
        bgColor(Qt::lightGray)
    {
        setMaximumHeight(32);
        setOrientation(Qt::Horizontal);
        setStyleSheet("QSlider{background: " + bgColor.name() + "}QSlider::groove:horizontal{background: " + bgColor.name() + " ; height: 30px;border: 1px solid " + color.name() + "; border-radius: 15px;} QSlider::handle:horizontal{background: " + color.name() + "; width: 70px; height: 30px; border: 1px solid " + color.name() + "; border-radius: 15px;}");
    }

    //Sets the markers as QList of x-coordinates.
    void setMarkers(QList<int> m)
    {
        sectionMarkers = m;
    }

    void  setColors(QColor c, QColor bg)
    {
        color = c;
        bgColor = bg;
        setStyleSheet("QSlider{background: " + bgColor.name() + "}QSlider::groove:horizontal{background: " + bgColor.name() + " ; height: 30px;border: 1px solid " + color.name() + "; border-radius: 15px;} QSlider::handle:horizontal{background: " + color.name() + "; width: 70px; height: 30px; border: 1px solid " + color.name() + "; border-radius: 15px;}");
    }

    void paintEvent(QPaintEvent *event)
    {
        QSlider::paintEvent(event);
        QPainter painter(this);

        //Draw markers.
        for(QList<int>::iterator iter = sectionMarkers.begin(); iter != sectionMarkers.end(); ++iter)
        {
            int x = ((float)(*iter) / (float)maximum()) * (float)width();
            QPen pen;
            pen.setColor(color);
            pen.setWidth(2);
            painter.setPen(pen);
            painter.drawLine(QPoint(x, 0), QPoint(x, height()));
        }

        //QStyleOptionSlider and style() used to get the rect of the slider handle.
        QStyleOptionSlider opt;
        initStyleOption(&opt);
        QRect handleRect = style()->subControlRect(QStyle::CC_Slider, &opt, QStyle::SC_SliderHandle, this);
        int percentage = ((float)(sliderPosition()) / (float)maximum()) * 100.00;
        painter.setPen(QPen(bgColor));
        painter.drawText(handleRect, Qt::AlignCenter, QString::number(percentage) + "%"); 
        
    }

protected:
    void mousePressEvent(QMouseEvent *event)
    {
        QStyleOptionSlider opt;
        initStyleOption(&opt);
        QRect handleRect = style()->subControlRect(QStyle::CC_Slider, &opt, QStyle::SC_SliderHandle, this);
        if(handleRect.contains(event->pos())){
            QSlider::mousePressEvent(event);
        } else {
            event->ignore();
        }

    }

private:
    QList<int> sectionMarkers;
    QColor color;
    QColor bgColor;

};

#endif
