#ifndef LIBRARY_H
#define LIBRARY_H

class QObject;
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QStringList>
#include <QDir>
#include "book.h"
#include "shared.h"

//Library handles saving books, bookmarks and annotations in a database.
class Library : public QObject{
    Q_OBJECT
public:
    //Library is initialized with a path to a folder and filepath to a database.
    Library(const QString &lD, const QString &databasename, QObject *parent = 0);
    ~Library();

    //Loads library by calling loadBooksfromdb and scanDirectory.
    void loadLibrary();

    //Recursively scans a directory tree for epub-files.
    void scanDirectory(const QString&);

    //Loads books from database and creates Book-objects.
    void loadBooksfromdb();
    void saveBooktodb(Book*);

    //Returns a QList of Book-pointers.
    //This is not used anymore.
    QList<Book*> getBooks(Sorting = None);

private:
    QStringList filenames;
    void connectdb(const QString&);
    void saveBookProgress(Book*);
    void loadBookProgress(Book*);
    void loadBookmarks(Book*);
    void loadAnnotations(Book*);
    //Check if books in database still exists and if a there's any new files in book directory.
    bool checkForChanges();


    QSqlDatabase database;
    QString libraryDirectory;

    QList<Book*> books;

public slots: 
    //Books can be added to library either with a pointer to Book-object (usually done when loading a book from a catalog) or with a filename.
    void addToLibrary(Book*, bool = true);
    void addToLibrary(const QString&);
    void removeFromLibrary(Book*);

    void deleteAnnotation(Book*, Annotation);
    void deleteBookmark(Book*, Bookmark);
    void saveBookmark(const Bookmark&, Book*);
    void saveAnnotation(const Annotation&, Book*);

signals:
    //Emitted when a book has been added to library so the UI can be updated.
    void bookAdded(Book*);
    void bookRemoved(Book*);
};

#endif
