#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QRadioButton>
#include <QCheckBox>
#include <QtMaemo5>

#include "shared.h"


class SettingsDialog : public QDialog
{
    Q_OBJECT
public:
    SettingsDialog(QWidget *parent = 0);

    int getOrientation();
    void setOrientation(int);

    int getColors();
    void setColors(int);

    void setFontFamily(const QString &family);
    QString getFontFamily();

    void setFontSize(int size);
    int getFontSize();

    void setBacklightForce(bool);
    bool getBacklighForce();

    void setViewMode(BookViewMode);
    BookViewMode getViewMode();
    

private:
    QButtonGroup *orientationButtonGroup;
    QRadioButton *portraitRadioButton;
    QRadioButton *landscapeRadioButton;
    QButtonGroup *colorsButtonGroup;
    QRadioButton *normalRadioButton;
    QRadioButton *invertedRadioButton;
    QButtonGroup *viewModeButtonGroup;
    QRadioButton *scrollRadioButton;
    QRadioButton *pagesRadioButton;
    QMaemo5ListPickSelector *fontSelector;
    QStandardItemModel *model;
    QHash<QString, QStandardItemModel*> fontSizes;
    QMaemo5ListPickSelector *fontSizeSelector;
    QCheckBox *backlightButton;
    QWidget *containerWidget;

public slots:
    void fontChanged(const QString&);
};

#endif
