#ifndef MAINWONDOW_H
#define MAINWONDOW_H

#include <QMainWindow>
#include <QEvent>
#include <QToolBar>
#include <QKeyEvent>
#include "bookview.h"

//MainWindow is the mainwindow that has the reading UI. Contains toolbar buttons for TOC, Bookmarks and Annotations. 
class MainWindow : public QMainWindow{
    Q_OBJECT
public:
    MainWindow(osso_context_t *context = 0, QWidget *parent = 0);
    ~MainWindow();

    //Book can be opened either from filename or Book-object.
    void openBook(const QString &filename);
    void openBook(Book *book);

    void setFont(const QString&, int);
    void setColorMode(int);
    void enableBacklightForcing(bool);
    void setViewMode(BookViewMode, Qt::WidgetAttribute);

protected:
    bool eventFilter(QObject*, QEvent*);
    void keyPressEvent(QKeyEvent*);
    void closeEvent(QCloseEvent*);

private:
    BookView *bookView;
    Book *currentBook;
    QToolBar *toolbar;
    void grabZoomKeys(bool);
    QTimer brightnessTimer;
    //osso_context is used for in forcing the backlight on.
    osso_context_t *osso_context;

public slots:
    void tocNavigation();
    void viewBookmarks();
    void viewAnnotations();
    void forceBacklightOn();

signals:
    void volumeDownPressed();
    void volumeUpPressed();
    void closing();
};

#endif
