/*
    Funcion para realizar menues para una aplicacion
	Parametros:
    ---------------------------------------------------------------------
    |  x            | posicion x del comienzo del menu en la pantalla   |
    |  y            | posicion y del comienzo del menu en la pantalla   |
    |  inactivefont | font a utilizar para las opciones no selecionadas |
    |  activefont   | font a utilizar para la opcion selecionada        |
    |  spacing      | separacion entre una opcion y la siguiente        |
    |  optionsc     | cantidad de opciones en el menu                   |
    |  options      | el texto de cada opcion                           |
    |  pos          | opcion activa en el menu al inicio                |
    ---------------------------------------------------------------------
*/
#include "common.h"

#define MENU_LEFT_MARGIN	300
#define MENU_RIGHT_MARGIN	(screen_w - MENU_LEFT_MARGIN)
#define MENU_ITEMS_HIGH		55
#define MENU_ITEMS_VERT_SPACE	10

#define MENU_ITEM_1_TOP_MARGIN	140
#define MENU_ITEM_2_TOP_MARGIN	(MENU_ITEM_1_TOP_MARGIN + MENU_ITEMS_HIGH) + MENU_ITEMS_VERT_SPACE
#define MENU_ITEM_3_TOP_MARGIN	(MENU_ITEM_2_TOP_MARGIN + MENU_ITEMS_HIGH) + MENU_ITEMS_VERT_SPACE
#define MENU_ITEM_4_TOP_MARGIN	(MENU_ITEM_3_TOP_MARGIN + MENU_ITEMS_HIGH) + MENU_ITEMS_VERT_SPACE

SDL_Surface *back;

int menu(int x, int y, SDL_Surface * inactivefont, SDL_Surface * activefont, int spacing, int optionc, char *option[], int pos)
{
    SDL_Surface * font;
    SDL_Event event;
    int oldpos = pos;

    while(true)
    {
	int mouse_x = 0, mouse_y = 0;

        // ATTENTION checked the mouse! This is specific to each menu is not standard for all projects
	SDL_GetMouseState(&mouse_x, &mouse_y);

	// Prevent to return bad position
	if (mouse_x == screen_w/2 && mouse_y == screen_h/2)
   	    return pos;

	if(	(mouse_x>=MENU_LEFT_MARGIN && mouse_x<=MENU_RIGHT_MARGIN) && 
		(mouse_y>=MENU_ITEM_1_TOP_MARGIN && mouse_y<=(MENU_ITEM_1_TOP_MARGIN + MENU_ITEMS_HIGH)))
	    pos = 1;
	else if((mouse_x>=MENU_LEFT_MARGIN && mouse_x<=MENU_RIGHT_MARGIN) && 
		(mouse_y>=MENU_ITEM_2_TOP_MARGIN && mouse_y<=(MENU_ITEM_2_TOP_MARGIN + MENU_ITEMS_HIGH)))
	    pos = 2;
	else if((mouse_x>=MENU_LEFT_MARGIN && mouse_x<=MENU_RIGHT_MARGIN) && 
		(mouse_y>=MENU_ITEM_3_TOP_MARGIN && mouse_y<=(MENU_ITEM_3_TOP_MARGIN + MENU_ITEMS_HIGH)))
	    pos = 3;
	else if((mouse_x>=MENU_LEFT_MARGIN && mouse_x<=MENU_RIGHT_MARGIN) && 
		(mouse_y>=MENU_ITEM_4_TOP_MARGIN && mouse_y<=(MENU_ITEM_4_TOP_MARGIN + MENU_ITEMS_HIGH)))
	    pos = 4;
	else
	    pos = 0;

	if (oldpos!= pos)
	{
	    oldpos = pos;
//	    if ((pos >= 1 && pos <= 4) && !muted)
//	       Mix_PlayChannel(1, option_sound,0);

	    if (pos == 3)
	       SDL_WarpMouse(0,0);
	}

	int n;
	for(n=0;n<optionc;n++)
	{
	    if(n+1==pos)
		font=inactivefont;
	    else
		font=activefont;

	    int fw=font->w/91;
	    int fh=font->h;

	    T_Print(font, x, (y+(n*spacing)), (char*)"%s",option[n]);
	    SDL_UpdateRect(screen,x, (y+(n*spacing)), (fw*(strlen(option[n]))), fh);
	    SDL_Delay(10);
	}

	SDL_PollEvent(&event);
	if(event.type==SDL_MOUSEBUTTONDOWN)
		return pos;

	if(event.type==SDL_KEYDOWN)
	{
	    switch(event.key.keysym.sym)
	    {
		case SDLK_p:
			pos = 1;
			break;

		case SDLK_s:
			pos = 2;
			break;

		case SDLK_e:
			pos = 3;
			break;

		case SDLK_m:
			pos = 4;
			break;

		default:
			pos = 0;
			break;
 	    }
	    return pos;
	}
    }
}

