/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtCore>
#include <QSizeF>
#include <QRectF>
#include <QResizeEvent>
#include <QMainWindow>
#include <QLabel>
#include <QAction>
#include <QStackedWidget>

//#include <kxmlguiwindow.h>
//#include <kgamedifficulty.h>

#include "GameController.h"
#include "settingswidget.h"

class GameInfo;
class ThemeManager;
class GraphicsScene;
class GameController;
class QGraphicsView;
//class KSelectAction;
class QXmlStreamReader;
//class KGameClock;

class MainWindow : public QMainWindow{
    Q_OBJECT

    public:
        MainWindow(QWidget *parent = 0);
        ~MainWindow();

        QString gameName(){ return m_gameName;}

        QRectF windowRect(){ return this->rect();}

        void setGameName(QString gameName);


    private slots:
        void newGame(int gameId);
        void slotShowScore(int score,bool human);
        void slotShowTurn(bool);
        void slotShowGameOver();
        void slotMessage(QString);
        void slotPause();
        // void slotChangeDifficulty(KGameDifficulty::standardLevel);
        void slotChangeDifficulty(int level);
        void slotStartGame();
        void slotShowSettings();
        void slotChangeGameName(int game);
        void help();

    signals:
        void signalLoadTheme();
        void signalGameDifficulty(GameController::Difficulty);

    protected:
        void resizeEvent(QResizeEvent *event);

    private:
        void setupGame();
        void setupWidgets();
        void startGame();
        void setupActions();


        void setGameName();
        void parseXml(QIODevice *device);
        void parseNames();

        GraphicsScene *m_scene;
        GameInfo* m_gameInfo;
        ThemeManager* m_gameTheme;
        GameController *m_gameController;
        // KGameClock* m_gameClock;

        QStringList m_gameNameList;
        QString m_gameName;
        int m_gameNameId;
        QGraphicsView *m_view;
//        GraphicsView* m_view;

        // KSelectAction* newGameAct;
        QXmlStreamReader *reader;

        QLabel *msgLabel;
        QLabel *turnLabel;
        QLabel *humanScore;
        QLabel *aiScore;

        enum Level {
            Easy = 0,
            Medium = 1,
            Hard = 2
        };

        QMenu *mainMenu;
        QMenu *newGameMenu;
        QAction *newGameAction;
        QAction *restartGameAction;
        QAction *helpAction;

        SettingsWidget *settings;
        QStackedWidget *m_StackedWidget;

    signals:
        void resized(QSizeF size);
};

#endif // MAINWINDOW_H
