/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef KALAH_H
#define KALAH_H

#include <QtSvg/QGraphicsSvgItem>
#include <QGraphicsSimpleTextItem>


class Board;
class Stone;
class GameInfo;

class Kalah : public QGraphicsSvgItem{

    public:
        enum side{Left, Right};

        Kalah(GameInfo* info, Kalah::side p, QGraphicsSvgItem *parent);

        QPointF* calculateStonePosition(Stone* stone);
        void updateStoneList(Stone* stoneItem);

        QSizeF size() const{ return m_size;}
        QPointF position() const{ return m_pos;}
        QPointF middlePoint() const{ return m_mid_point;}
        int index() const{ return m_side;}


    private:
        void initialSetup();
        void setupText();

        QSizeF m_size;
        QPointF m_mid_point,m_pos;
        QList <Stone*> m_stone;
        QGraphicsSimpleTextItem *m_text;

        side m_side;
        Board *m_board;
        GameInfo *m_gameInfo;
};

#endif // KALAH_H
