/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "Board.h"

#include "math.h"

#include <QDebug>

// #include <kdebug.h>

#include "Cup.h"
#include "Kalah.h"
#include "Stone.h"
#include "GameInfo.h"
#include "ThemeManager.h"


Board::Board(GameInfo *gameInfo, ThemeManager *theme)
    : QGraphicsSvgItem(0)
{
    setSharedRenderer(theme);
    m_gameInfo = gameInfo;
    m_theme = theme;
    setElementId("board");
    initialSetup();
    setZValue(1);

    qreal posX,posY,width,height,scaleX,scaleY;

    posX = sceneBoundingRect().x() + sceneBoundingRect().width() * 0.0125; // 0.15
    posY = sceneBoundingRect().y() + sceneBoundingRect().height() * 0.03; // 0.8
    width = 1.16 * sceneBoundingRect().width(); // 0.85
    // height = width / 1.75 ; // 2.5
    height = 2.6 * sceneBoundingRect().height();

    scaleX = width / ( boundingRect().width() );
    scaleY = height / ( boundingRect().height() ) ;
    scale(scaleX,scaleY);

    setPos(posX,posY);
    
//     qDebug() << "posX" << posX;
//     qDebug() << "posY" << posY;
//     qDebug() << "scaleX" << scaleX;
//     qDebug() << "scaleY" << scaleY;
//     qDebug() << "width" << width;
//     qDebug() << "height" << height;
//     qDebug() << "boundingRect width" << boundingRect().width();
//     qDebug() << "boundingRect height" << boundingRect().height();
//     qDebug() << "sceneBoundingRect().height()" << sceneBoundingRect().height();
//     qDebug() << "sceneBoundingRect().width()" << sceneBoundingRect().width();
//     qDebug() << "sceneBoundingRect().y()" << sceneBoundingRect().y();
//     qDebug() << "sceneBoundingRect().x()" << sceneBoundingRect().x();
   
}

Board::~Board(){
    //kDebug() << "Destructor of Board";
    while(m_cups.count())
        m_cups.pop_front();
}

void Board::initialSetup(){
    createKalahs();
    createCups();
}

void Board::createKalahs(){

    //If the game supports Kalah(store) then create kalah
    if(m_gameInfo->numKalahs()){
        m_leftKalah = new Kalah(m_gameInfo, Kalah::Left, this);
        m_rightKalah = new Kalah(m_gameInfo, Kalah::Right, this);
    }
    else return;
}

void Board::createCups(){

    int i = 0;

    //kDebug() << "---------Total in the list before first push---------: " << m_cups.count();
    for(int row = 0; row < m_gameInfo->numRows(); row++){
        for(int column = 0; column < m_gameInfo->numCupsPerRow(); column++){
            //appending to the list of cup
            m_cups << new Cup(m_gameInfo, i++ , this);
        }
    }

}

void Board::manipulateStones(QList<Stone*>& currentStoneList){

    int j = 0 , stonesPerCupInitially = m_gameInfo->initialStonesPerCup();
    Cup* cup;
    m_stones = currentStoneList;

    foreach(cup,m_cups){
        for(int i = 0; i < stonesPerCupInitially ; i++ ){
            cup->addStone(m_stones[j++]);
        }
    }

}


int Board::findCupIndex(QPointF position){
    Cup* cup;
    foreach(cup,m_cups){

        if(cup->shape().contains( cup->mapFromScene(position) )){
            return cup->index();
        }
    }
    return -1;
}


void Board::updateChildren(int cupIndex,int kalahIndex,int stoneNo){

    //kDebug() << "Int3 is called";

    for(int i = 0 ; i < stoneNo ; i++){
        //Remove from cup a stone
        Stone *stone = m_cups[cupIndex]->updateStoneList();

        if(kalahIndex == Kalah::Left){
            m_leftKalah->updateStoneList(stone);
        }
        else m_rightKalah->updateStoneList(stone);
        update();
    }
    update();
}

//It will remove stone from cupIndex and push it to kalah[index] or cup[index]
void Board::updateChildren(int cupIndex,int index,bool isCup){

    Stone* stone = m_cups[cupIndex]->updateStoneList();

    m_isCup = isCup;
    m_index = index;
    m_stone = stone;

    slotUpdateChildren();
    update();
}


void Board::slotUpdateChildren(){

    if(m_isCup)
        m_cups[m_index]->updateStoneList(m_stone);

    else{
        if(m_index == Kalah::Left)
            m_leftKalah->updateStoneList(m_stone);
        else m_rightKalah->updateStoneList(m_stone);
    }
}


