/*
*
*  This file is part of Mancala
*
*  Copyright (C) 2009 Reto Zingg
*
*  Some of the code is based on the examples on:
*  http://wiki.maemo.org/Documentation/Maemo_5_Developer_Guide
*
*  This program is free software; you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by the
*  Free Software Foundation; either version 2, or (at your option) any
*  later version.
*
*  This program is distributed in the hope that it will be useful, but
*  WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  General Public License for more details, a copy of which may be found in
*  the file COPYING provided in the main directory of this release.
*
*/

/*********************************************************************
**
** NOT used at the moment...
**
*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <hildon/hildon.h>
#include <libosso.h>
#include <gtk/gtk.h>


#include "play.h"

#define OSSO_SERVICE "com.nokia.mancala"

osso_context_t *ossoContext = NULL;

gint
dbus_callback (const gchar *interface, const gchar *method,
                GArray *arguments, gpointer data,
                osso_rpc_t *retval)
{
        printf ("Msg dbus: %s, %s\n", interface, method);

        if (!strcmp (method, "top_application"))
                gtk_window_present (GTK_WINDOW (data));

        retval->type = DBUS_TYPE_INVALID;
        return OSSO_OK;
}


void play_wrapper (GtkWidget *win)
{

        fprintf(stderr, "Button start-play pressed\n");
        if (play() > 0){
                fprintf(stderr, "start play failed\n");
        }
        else{
                fprintf(stderr, "successfull played...\n");
        }

        osso_application_top(ossoContext, OSSO_SERVICE, NULL);

}

static HildonAppMenu* create_menu (GtkWidget *win)
        {
                int i;
                gchar *command_id;
                GtkWidget * button;
                HildonAppMenu *menu = HILDON_APP_MENU (hildon_app_menu_new ());
                for (i = 1; i <= 2; i++) {
                        /* Create menu entries */
                        button = hildon_gtk_button_new (HILDON_SIZE_AUTO);
                        command_id = g_strdup_printf ("Menu command %d", i);
                        gtk_button_set_label (GTK_BUTTON (button), command_id);

                        /* Attach callback to clicked signal */
                        switch (i) {
                                // Start game
                                case 1:
                                        command_id = g_strdup_printf ("Play");
                                        gtk_button_set_label (GTK_BUTTON (button), command_id);
                                        g_signal_connect_after (button, "clicked",
                                                G_CALLBACK (play_wrapper),win);
                                break;
                                // Show help
                                case 2:
                                        command_id = g_strdup_printf ("Quit");
                                        gtk_button_set_label (GTK_BUTTON (button), command_id);
                                        g_signal_connect_after (button, "clicked",
                                                G_CALLBACK (gtk_main_quit), NULL);
                                break;
                        }
                        /* Add entry to the view menu */
                        hildon_app_menu_append (menu, GTK_BUTTON (button));
                }

        gtk_widget_show_all (GTK_WIDGET (menu));
        return menu;
}


int main (int argc, char **argv) {

        osso_return_t ret;

        g_print("Initializing LibOSSO\n");
        ossoContext = osso_initialize(OSSO_SERVICE, "0.1", FALSE, NULL);
        if (ossoContext == NULL) {
                g_error("Failed to initialize LibOSSO\n");
        }

        GtkWidget *win;
        GtkWidget *textbox;
        GtkTextBuffer *textbox_buffer;
        gchar *textbox_text;
        GtkBox *vbox;
        HildonAppMenu *menu;
        PangoFontDescription *font_desc;
        GtkWidget * button;
        gchar *button_lable_text;
        GtkWidget *pannable_text;

        hildon_gtk_init (&argc, &argv);
        win = hildon_window_new ();

        /* Create and pack labels */     
        textbox_text = g_strdup_printf("Welcome to Mancala, the ancient African game of skill!\n\nMancala is a very simple, easy-to-learn game. Each player begins with a horizontal row of holes or pits filled with a certain number of stones. At either end of the board are the players' home pits, which are used to keep score. In this case, the human player has the left home pit and the upper row holes. A move is made by clicking into the hole you wish to move from. The stones are then picked up and distributed, one to each hole, moving toward your home pit is reached, and then moving through your opponent's row, bypassing his/her home, and moving back towards in a circle (counterclockwise), until all the stones have been distributed.\n\nIf the last stone is placed in your home, you receive an extra turn. If the last stone lands in an empty hole on your side, you 'capture' the stones in the opposite hole on your opponent's side, moving them to your home.\n\nThe game ends when one player cannot play (ie. there are no stones on his/her side of the board.  The player who has the most stones on his/her *side* wins.");

        textbox = hildon_text_view_new();
        // gtk_text_view_set_editable(GTK_TEXT_VIEW(textbox), FALSE);
        // gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(textbox), FALSE);
        gtk_text_view_set_indent(GTK_TEXT_VIEW(textbox), 10);
        gtk_text_view_set_left_margin(GTK_TEXT_VIEW(textbox), 10);
        gtk_text_view_set_right_margin(GTK_TEXT_VIEW(textbox), 10);
        gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(textbox), 3);
        gtk_text_view_set_pixels_below_lines(GTK_TEXT_VIEW(textbox), 2);
        gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textbox), GTK_WRAP_WORD);
        // gtk_widget_set_sensitive(textbox, FALSE);
        font_desc = pango_font_description_from_string ("vera 18");
        gtk_widget_modify_font(textbox, font_desc);
        pango_font_description_free (font_desc);

        textbox_buffer = hildon_text_view_get_buffer (HILDON_TEXT_VIEW (textbox));

        gtk_text_buffer_set_text(textbox_buffer, textbox_text, -1);


        pannable_text = hildon_pannable_area_new();
        hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA(pannable_text), textbox);


        vbox = GTK_BOX (gtk_vbox_new (FALSE, 2));

        button = hildon_button_new (HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
                                        HILDON_BUTTON_ARRANGEMENT_VERTICAL);
        button_lable_text = g_strdup_printf ("Play");
        gtk_button_set_label (GTK_BUTTON (button), button_lable_text);
        g_signal_connect_after (button, "clicked",
                                 G_CALLBACK (play_wrapper),win);

        gtk_box_pack_start (vbox, button, FALSE, TRUE, 1);
        gtk_box_pack_start (vbox, pannable_text, TRUE, TRUE, 1);

        /* Create menu */
        menu = create_menu (win);

        /* Attach menu to the window */
        hildon_window_set_app_menu (HILDON_WINDOW (win), menu);

        /* Add label's box to window */
        gtk_container_add (GTK_CONTAINER (win), GTK_WIDGET (vbox));

        g_signal_connect (win, "delete_event", G_CALLBACK (gtk_main_quit), NULL);

        gtk_widget_show_all (win);

        ret = osso_rpc_set_default_cb_f (ossoContext, dbus_callback, GTK_WINDOW(win));
        if (ret != OSSO_OK)
        {
                fprintf (stderr, "osso_rpc_set_default_cb_f failed: %d.\n", ret);
                exit (1);
        }

        gtk_main ();

        osso_deinitialize(ossoContext);
        ossoContext = NULL;

        return 0;
}


