//#define DEBUG

#include <iostream>
#include <string>
#include <QtCore/QCoreApplication>
#include <QStringList>
#include <CMulticalendar.h>

#include <functions.h>

void log(string msg, int level, bool newline); //declaration for global log method

using namespace std;

QStringList args;
CMulticalendar *mcalendar = 0;
int _loglevel_ = 1; //default log level. 0 is same as --quiet

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    args = a.arguments();

#ifdef DEBUG
    for(int i=0; i< args.size(); i++){
        cout << args.at(i).toLocal8Bit().constData() << endl;
    }
#endif

    mcalendar = CMulticalendar::MCInstance();

    QString operation;
    bool ok = true;

    //get operation first as it is always required
    if (!parse_cmd_arg(args, ARG_OPERATION_LONG, operation)){
        cout << "invalid '" << "--operation" << "' argument" << endl;

        cout << "try one of the following:" << endl;
        cout << "--operation import" << endl;
        cout << "--operation export" << endl;
        cout << "--operation list" << endl;
        cout << "--operation tasks-clear-done" << endl;
        cout << "--operation tasks-bump-today" << endl;

        return -1;
    }

    if(parse_cmd_arg(args,ARG_QUIET)){
        _loglevel_ = 0;
    }

    ok = do_operation(args, operation);

    if (!ok){
        cerr << "Program failure" << endl;
        return -1;
    }

    //return a.exec();
    return 0;
}

void log(string msg, int level, bool newline){
    //print a message to stdout based on the logging level
    if (level <= _loglevel_){
        cout << msg;
        if(newline){
            cout << endl;
        }
    }

}
