/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bookmarkdlg.h"
#include "ui_bookmarkdlg.h"

#include <QWebSettings>

BookmarkDlg::BookmarkDlg(QWidget *parent) :
    QDialog(parent),
    m_pUI(new Ui::BookmarkDlg)
{
    m_pUI->setupUi(this);
}

BookmarkDlg::~BookmarkDlg()
{
    delete m_pUI;
}

void BookmarkDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_pUI->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BookmarkDlg::setTitle(QString value){
    return m_pUI->titleEdit->setText(value);
}

void BookmarkDlg::setUrl(QString value) {
    setWindowIcon( QWebSettings::iconForUrl(value) );
    return m_pUI->urlEdit->setText(value);
}

QString BookmarkDlg::title(){
    return m_pUI->titleEdit->text();
}

QString BookmarkDlg::url() {
    return m_pUI->urlEdit->text();
}

QPushButton* BookmarkDlg::removeBtt() {
    return m_pUI->removeBtt;
}

void BookmarkDlg::on_removeBtt_clicked()
{
    // ...
    reject();
}
