/*
 *  Microfeed - Backend for accessing feed-based services
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <microfeed-provider/microfeederror.h>
#include <microfeed-common/microfeedmisc.h>

#include <string.h>

struct _MicrofeedError {
	char* name;
	char* message;	
};

MicrofeedError* microfeed_error_new(const char* name, const char* message) {
	MicrofeedError* error;
	
	error = microfeed_memory_allocate(MicrofeedError);
	error->name = (name ? strdup(name) : NULL);
	error->message = (message ? strdup(message) : NULL);

	return error;
}

void microfeed_error_free(MicrofeedError* error) {
	free(error->name);
	free(error->message);
	microfeed_memory_free(error);
}

const char* microfeed_error_get_name(MicrofeedError* error) {
	
	return error->name;
}

const char* microfeed_error_get_message(MicrofeedError* error) {
	
	return error->message;
}
