/*
 *  Microfeed - Backend for accessing feed-based services
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation, or under the terms of the GNU Lesser General
 *  Public License version 2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MICROFEEDCONFIGURATION_H
#define MICROFEEDCONFIGURATION_H

/**
 * @addtogroup common libmicrofeed-common - Common modules used both in the publisher and in the subscriber side
 * @{
 * @addtogroup MicrofeedConfiguration
 * 
 * An easy access to provider and publisher configuration in the file system.
 * 
 * @link MicrofeedProvider MicrofeedProvider@endlink and @link MicrofeedSubscriber MicrofeedSubsciber@endlink
 * require configuration to locate existing publishers before instantiating or creating a
 * @link MicrofeedPublisher MicrofeedPublisher@endlink.
 *
 * @{
 */

/**
 * Opaque data type representing configuration.
 */
typedef struct _MicrofeedConfiguration MicrofeedConfiguration;

MicrofeedConfiguration* microfeed_configuration_new();
void microfeed_configuration_free(MicrofeedConfiguration* configuration);
void microfeed_configuration_invalidate(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_application_identifier(MicrofeedConfiguration* configuration);
const char** microfeed_configuration_get_providers(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_provider_name(MicrofeedConfiguration* configuration, const char* provider_identifier);
const char** microfeed_configuration_get_publishers(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_publisher_directory(MicrofeedConfiguration* configuration, const char* publisher_identifier);
const char* microfeed_configuration_get_default_publisher_directory(MicrofeedConfiguration* configuration);
const char** microfeed_configuration_get_providers_predefined_feed_uris(MicrofeedConfiguration* configuration, const char* provider_identifier);
const char** microfeed_configuration_get_subscriptions(MicrofeedConfiguration* configuration, const char* application_identifier);
void microfeed_configuration_add_subscription(MicrofeedConfiguration* configuration, const char* application_identifier, const char* publisher_identifier);
void microfeed_configuration_remove_subscription(MicrofeedConfiguration* configuration, const char* application_identifier, const char* publisher_identifier);
int microfeed_configuration_is_subscribed(MicrofeedConfiguration* configuration, const char* application_identifier, const char* publisher_identifier);
const char** microfeed_configuration_get_wizards(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_wizard_name(MicrofeedConfiguration* configuration, const char* publisher_identifier);
const char** microfeed_configuration_get_wizard_settings(MicrofeedConfiguration* configuration, const char* publisher_identifier);

/**
 * @}
 * @}
 */

#endif
