/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef WIDGETSCREEN_H
#define WIDGETSCREEN_H

#include <QtCore/QMap>
#include <QtCore/QSet>
#include <QtGui/QStackedWidget>
#include "abstractscreen.h"

class QDomNode;
class QString;
class Reader;
class ThemeScreen;

class WidgetScreen : public QStackedWidget, public AbstractScreen
{
    Q_OBJECT

public:
    enum Orientation {LANDSCAPE, PORTRAIT};
    WidgetScreen(QWidget* parent = 0);
    ~WidgetScreen();
    void addScreen(ThemeScreen* screen, Orientation orientation);
    bool load(Orientation orientation, QDomNode const& data, Reader* reader);
    bool load(QDomNode const& data, Reader* reader);
    bool orientationEnabled(Orientation orientation) const;
    bool orientationLoaded(Orientation orientation) const;
    void setColor(Orientation orientation, QString const& color);
    void setColor(QString const& color);

public slots:
    virtual void reArrange();
    virtual void flip();
    virtual void clear();
    void removeUnloaded();

signals:
    void minimizePressed();
    void settingsPressed();
    void closePressed();
    void clicked();

private:
    QMap<Orientation, ThemeScreen*> screens_;
    QSet<Orientation> loadedScreens_;
    Orientation currentOrientation_;

};

#endif
