/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef THEMESCREEN_H
#define THEMESCREEN_H

#include "graphicsscreen.h"

class QString;
class QWidget;
class GraphicsElement;
class QDomNode;
class Reader;

class ThemeScreen : public GraphicsScreen
{
public:
    ThemeScreen(QWidget* parent = 0);
    bool load(QDomNode const& data, Reader* reader);
    virtual void update();
    void removeElements();
    virtual void setColor(QString const& color);

private:
    QList<GraphicsElement*> elements_;
    QString error_;
};

#endif
