/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef LOCATION_H
#define LOCATION_H

#include <QtCore/QObject>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>

class Location : public QObject
{
    Q_OBJECT

public:

    enum Unit {KM, MILE};

    struct Fix
    {
        Unit unit;
        double kmSpeed;
        double time;
        double ept;
        double latitude;
        double longitude;
        double eph;
        double altitude;
        double epv;
        double track;
        double epd;
        double speed;
        double eps;
        double climb;
        double epc;
        Fix();
    };

    enum Error {USER_REJECTED_DIALOG,
        USER_REJECTED_SETTINGS,
        GPS_NOT_AVAILABLE,
        NOT_ALLOWED_IN_OFFLINE_MODE,
        SYSTEM_ERROR};

    Location(QObject* parent = 0);
    ~Location();
    void start();
    void end();
    bool hasFix() const;
    double getSignalStrength() const;
    static void setUnit(Unit unit);
    static Unit getUnit();
    static double getUnitMultiplier();
    static double getMeterMultiplier();

signals:
    void locationChanged(Location::Fix const& fix);
    void locationError(Location::Error error);

private:
    static void onChanged(LocationGPSDevice *device, gpointer data);
    static void onError(LocationGPSDControl *control, LocationGPSDControlError error, gpointer data);
    bool started_;
    LocationGPSDControl* control_;
    LocationGPSDevice* device_;
    static Unit unit_;
};

#endif
