/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef GRAPHICSELEMENT_H
#define GRAPHICSELEMENT_H

#include <QtCore/QObject>
#include <QtCore/QMap>

class QString;
class QByteArray;
class QFont;
class QGraphicsItem;
class GraphicsScene;
class QGraphicsEffect;
class Reader;
class Effect;

class GraphicsElement : public QObject
{
    Q_OBJECT

public:

    struct AttributeDetails
    {
        QString name;
        bool isInt;
    };

    GraphicsElement(Reader* reader);
    static GraphicsElement* getElement(QString const& name, Reader* reader);
    virtual bool setAttribute(QString const& name, QString const& value) = 0;
    virtual void addToScene(GraphicsScene* scene) = 0;
    virtual void update() = 0;
    virtual QGraphicsItem* getElement() const = 0;
    QString const& getError() const;
    bool setEffect(QString const& effect);
    bool setEffectAttribute(QString const& name, QString const& value);
    void applyEffect();
    bool canBeVisible() const;

protected:
    enum VisibleWhen {ALWAYS, POI_VISIBLE, SPEED_EXCEEDED};

    int getAttribute(QString const& name, QString const& value, const AttributeDetails details[], int count, int& intValue);
    void setError(QString const& error);
    bool readFile(QString const& name, QByteArray& data);
    bool getFont(QString const& name, QFont& font);
    void setVisibleWhen(VisibleWhen when);
    VisibleWhen strToVisibleWhen(QString const& str) const;

private slots:
    void updateVisibility(bool visible);

private:
    Reader* reader_;
    QString error_;
    Effect* effect_;
    QMap<QString, QString> loadedFonts_;
    VisibleWhen visibleWhen_;
    bool canBeVisible_;
};

#endif
