/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XSheet;
import sun.tools.jconsole.inspector.XTree;
import sun.tools.jconsole.inspector.XTreeRenderer;

public class MBeansTab
extends Tab
implements NotificationListener,
PropertyChangeListener,
TreeSelectionListener {
    private XTree tree;
    private XSheet sheet;
    private XDataViewer viewer;
    private MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            int selRow;
            if (e.getClickCount() == 1 && (selRow = MBeansTab.this.tree.getRowForLocation(e.getX(), e.getY())) != -1) {
                TreePath selPath = MBeansTab.this.tree.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (MBeansTab.this.sheet.isMBeanNode(node)) {
                    MBeansTab.this.tree.expandPath(selPath);
                }
            }
        }
    };

    public static String getTabName() {
        return Resources.getText("MBeans", new Object[0]);
    }

    public MBeansTab(VMPanel vmPanel) {
        super(vmPanel, MBeansTab.getTabName());
        this.addPropertyChangeListener(this);
        this.setupTab();
    }

    public XDataViewer getDataViewer() {
        return this.viewer;
    }

    public XTree getTree() {
        return this.tree;
    }

    public XSheet getSheet() {
        return this.sheet;
    }

    public void dispose() {
        super.dispose();
        this.sheet.dispose();
    }

    public int getUpdateInterval() {
        return this.vmPanel.getUpdateInterval();
    }

    void synchroniseMBeanServerView() {
        try {
            this.getMBeanServerConnection().addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, null, null);
        }
        catch (InstanceNotFoundException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            this.vmPanel.getProxyClient().markAsDead();
            return;
        }
        Set<ObjectName> newSet = null;
        try {
            newSet = this.getMBeanServerConnection().queryNames(null, null);
        }
        catch (IOException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            this.vmPanel.getProxyClient().markAsDead();
            return;
        }
        this.tree.removeAll();
        this.tree.setVisible(false);
        for (ObjectName mbean : newSet) {
            this.tree.addMBeanToView(mbean);
        }
        this.tree.setVisible(true);
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.vmPanel.getProxyClient().getMBeanServerConnection();
    }

    public void update() {
        try {
            this.getMBeanServerConnection().getDefaultDomain();
        }
        catch (IOException ex) {
            this.vmPanel.getProxyClient().markAsDead();
        }
    }

    private void setupTab() {
        this.setLayout(new BorderLayout());
        JSplitPane mainSplit = new JSplitPane(1);
        mainSplit.setDividerLocation(160);
        mainSplit.setBorder(BorderFactory.createEmptyBorder());
        this.tree = new XTree(this);
        this.tree.setCellRenderer(new XTreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this.ml);
        JScrollPane theScrollPane = new JScrollPane(this.tree, 20, 30);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)theScrollPane, "Center");
        mainSplit.add(treePanel, "left", 0);
        this.viewer = new XDataViewer(this);
        this.sheet = new XSheet(this);
        mainSplit.add(this.sheet, "right", 0);
        this.add(mainSplit);
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName mbean = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                this.tree.addMBeanToView(mbean);
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                this.tree.delMBeanFromView(mbean);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "connectionState") {
            boolean connected = (Boolean)evt.getNewValue();
            if (connected) {
                this.workerAdd(new Runnable(){

                    public void run() {
                        MBeansTab.this.synchroniseMBeanServerView();
                    }
                });
            } else {
                this.sheet.dispose();
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.sheet.displayNode(node);
    }
}

