/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.EmbeddedFrame;
import sun.awt.PaintEventDispatcher;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.Native;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XKeysym;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XRepaintArea;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public class XWindow
extends XBaseWindow
implements X11ComponentPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XWindow");
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWindow");
    private static Logger eventLog = Logger.getLogger("sun.awt.X11.event.XWindow");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XWindow");
    private static Logger keyEventLog = Logger.getLogger("sun.awt.X11.kye.XWindow");
    private static final int AWT_MULTICLICK_SMUDGE = 4;
    static int rbutton = 0;
    static int lastX = 0;
    static int lastY = 0;
    static long lastTime = 0L;
    static long lastButton = 0L;
    static WeakReference lastWindowRef = null;
    static int clickCount = 0;
    int oldWidth = -1;
    int oldHeight = -1;
    protected X11GraphicsConfig graphicsConfig;
    protected AwtGraphicsConfigData graphicsConfigData;
    private boolean reparented;
    XWindow parent;
    Component target;
    private static int JAWT_LOCK_ERROR = 1;
    private static int JAWT_LOCK_CLIP_CHANGED = 2;
    private static int JAWT_LOCK_BOUNDS_CHANGED = 4;
    private static int JAWT_LOCK_SURFACE_CHANGED = 8;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    public static final String TARGET = "target";
    public static final String REPARENTED = "reparented";
    SurfaceData surfaceData;
    XRepaintArea paintArea;
    static final Font defaultFont = new Font("Dialog", 0, 12);
    private int mouseDragState = 0;
    private static Field isPostedField;
    static Method m_sendMessage;
    Color backgroundColor;
    static Field bdata;

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    native void getWMInsets(long var1, long var3, long var5, long var7, long var9, long var11);

    native long getTopWindow(long var1, long var3);

    native void getWindowBounds(long var1, long var3, long var5, long var7, long var9);

    private static native void initIDs();

    XWindow(XCreateWindowParams params) {
        super(params);
    }

    XWindow() {
    }

    XWindow(long parentWindow, Rectangle bounds) {
        super(new XCreateWindowParams(new Object[]{"bounds", bounds, "parent window", parentWindow}));
    }

    XWindow(Component target, long parentWindow, Rectangle bounds) {
        super(new XCreateWindowParams(new Object[]{"bounds", bounds, "parent window", parentWindow, TARGET, target}));
    }

    XWindow(Component target, long parentWindow) {
        this(target, parentWindow, target.getBounds());
    }

    XWindow(Component target) {
        this(target, target.getParent() == null ? 0L : XWindow.getParentWindowID(target), target.getBounds());
    }

    XWindow(Object target) {
        this(null, 0L, null);
    }

    XWindow(long parentWindow) {
        super(new XCreateWindowParams(new Object[]{"parent window", parentWindow, REPARENTED, Boolean.TRUE, "embedded", Boolean.TRUE}));
    }

    protected void initGraphicsConfiguration() {
        this.graphicsConfig = (X11GraphicsConfig)this.target.getGraphicsConfiguration();
        this.graphicsConfigData = new AwtGraphicsConfigData(this.graphicsConfig.getAData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        this.reparented = Boolean.TRUE.equals(params.get(REPARENTED));
        this.target = (Component)params.get(TARGET);
        this.initGraphicsConfiguration();
        AwtGraphicsConfigData gData = this.getGraphicsConfigurationData();
        X11GraphicsConfig config = (X11GraphicsConfig)this.getGraphicsConfiguration();
        XVisualInfo visInfo = gData.get_awt_visInfo();
        params.putIfNull((Object)"event mask", 2269311L);
        if (this.target != null) {
            params.putIfNull((Object)"bounds", this.target.getBounds());
        } else {
            params.putIfNull((Object)"bounds", new Rectangle(0, 0, 1, 1));
        }
        params.putIfNull((Object)"border pixel", (Object)0L);
        this.getColorModel();
        params.putIfNull((Object)"color map", gData.get_awt_cmap());
        params.putIfNull((Object)"visual depth", gData.get_awt_depth());
        params.putIfNull((Object)"visual class", (Object)1);
        params.putIfNull((Object)"visual", visInfo.get_visual());
        params.putIfNull((Object)"value mask", 10248L);
        Long parentWindow = (Long)params.get("parent window");
        if (parentWindow == null || parentWindow == 0L) {
            XToolkit.awtLock();
            try {
                int screen = visInfo.get_screen();
                if (screen != -1) {
                    params.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), screen));
                } else {
                    params.add((Object)"parent window", XToolkit.getDefaultRootWindow());
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        this.paintArea = new XRepaintArea();
        if (this.target != null) {
            this.parent = XWindow.getParentXWindowObject(this.target.getParent());
        }
        params.putIfNull((Object)"backing store", XToolkit.getBackingStoreType());
    }

    void postInit(XCreateWindowParams params) {
        Color c;
        super.postInit(params);
        this.setWMClass(this.getWMClass());
        this.surfaceData = this.graphicsConfig.createSurfaceData(this);
        if (this.target != null && (c = this.target.getBackground()) != null) {
            this.xSetBackground(c);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfig == null) {
            this.initGraphicsConfiguration();
        }
        return this.graphicsConfig;
    }

    public AwtGraphicsConfigData getGraphicsConfigurationData() {
        if (this.graphicsConfigData == null) {
            this.initGraphicsConfiguration();
        }
        return this.graphicsConfigData;
    }

    protected String[] getWMClass() {
        return new String[]{XToolkit.getCorrectXIDString(this.getClass().getName()), XToolkit.getAWTAppClassName()};
    }

    void setReparented(boolean newValue) {
        this.reparented = newValue;
    }

    boolean isReparented() {
        return this.reparented;
    }

    static long getParentWindowID(Component target) {
        ComponentPeer peer = target.getParent().getPeer();
        Container temp = target.getParent();
        while (!(peer instanceof XWindow)) {
            temp = temp.getParent();
            peer = temp.getPeer();
        }
        if (peer != null && peer instanceof XWindow) {
            return ((XWindow)((Object)peer)).getContentWindow();
        }
        return 0L;
    }

    static XWindow getParentXWindowObject(Component target) {
        if (target == null) {
            return null;
        }
        Container temp = target.getParent();
        if (temp == null) {
            return null;
        }
        ComponentPeer peer = temp.getPeer();
        if (peer == null) {
            return null;
        }
        while (peer != null && !(peer instanceof XWindow)) {
            temp = temp.getParent();
            peer = temp.getPeer();
        }
        if (peer != null && peer instanceof XWindow) {
            return (XWindow)((Object)peer);
        }
        return null;
    }

    boolean isParentOf(XWindow win) {
        if (!(this.target instanceof Container) || win == null || win.getTarget() == null) {
            return false;
        }
        Container parent = ComponentAccessor.getParent_NoClientCode(win.target);
        while (parent != null && parent != this.target) {
            parent = ComponentAccessor.getParent_NoClientCode(parent);
        }
        return parent == this.target;
    }

    public Object getTarget() {
        return this.target;
    }

    public Component getEventSource() {
        return this.target;
    }

    public ColorModel getColorModel(int transparency) {
        return this.graphicsConfig.getColorModel(transparency);
    }

    public ColorModel getColorModel() {
        if (this.graphicsConfig != null) {
            return this.graphicsConfig.getColorModel();
        }
        return XToolkit.getStaticColorModel();
    }

    Graphics getGraphics(SurfaceData surfData, Color afore, Color aback, Font afont) {
        Font font;
        Color fgColor;
        if (surfData == null) {
            return null;
        }
        Component target = this.target;
        Color bgColor = aback;
        if (bgColor == null) {
            bgColor = SystemColor.window;
        }
        if ((fgColor = afore) == null) {
            fgColor = SystemColor.windowText;
        }
        if ((font = afont) == null) {
            font = defaultFont;
        }
        return new SunGraphics2D(surfData, fgColor, bgColor, font);
    }

    public Graphics getGraphics() {
        return this.getGraphics(this.surfaceData, this.target.getForeground(), this.target.getBackground(), this.target.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getTargetBounds() {
        return this.target.getBounds();
    }

    boolean prePostEvent(AWTEvent e) {
        return false;
    }

    static void sendEvent(final AWTEvent e) {
        if (isPostedField == null) {
            isPostedField = SunToolkit.getField(AWTEvent.class, "isPosted");
        }
        PeerEvent pe = new PeerEvent(Toolkit.getDefaultToolkit(), new Runnable(){

            public void run() {
                block4: {
                    try {
                        isPostedField.setBoolean(e, true);
                    }
                    catch (IllegalArgumentException e2) {
                        assert (false);
                    }
                    catch (IllegalAccessException e3) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                ((Component)e.getSource()).dispatchEvent(e);
            }
        }, 2L);
        if (focusLog.isLoggable(Level.FINER) && e instanceof FocusEvent) {
            focusLog.finer("Sending " + e);
        }
        XToolkit.postEvent(XToolkit.targetToAppContext(e.getSource()), pe);
    }

    void postEvent(AWTEvent event) {
        XToolkit.postEvent(XToolkit.targetToAppContext(event.getSource()), event);
    }

    static void postEventStatic(AWTEvent event) {
        XToolkit.postEvent(XToolkit.targetToAppContext(event.getSource()), event);
    }

    public void postEventToEventQueue(AWTEvent event) {
        if (!this.prePostEvent(event)) {
            this.postEvent(event);
        }
    }

    protected boolean doEraseBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xSetBackground(Color c) {
        XToolkit.awtLock();
        try {
            this.winBackground(c);
            if (!this.doEraseBackground()) {
                return;
            }
            ColorModel cm = this.getColorModel();
            int pixel = PixelConverter.instance.rgbToPixel(c.getRGB(), cm);
            XlibWrapper.XSetWindowBackground(XToolkit.getDisplay(), this.getContentWindow(), pixel);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setBackground(Color c) {
        this.xSetBackground(c);
    }

    void winBackground(Color c) {
        this.backgroundColor = c;
    }

    public Color getWinBackground() {
        Color c = null;
        if (this.backgroundColor != null) {
            c = this.backgroundColor;
        } else if (this.parent != null) {
            c = this.parent.getWinBackground();
        }
        if (c instanceof SystemColor) {
            c = new Color(c.getRGB());
        }
        return c;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int x, int y, int width, int height) {
        if (!this.isVisible()) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                g.setClip(x, y, width, height);
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        if (!this.isVisible()) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    void paint(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void popup(int x, int y, int width, int height) {
        this.xSetBounds(x, y, width, height);
    }

    public void handleExposeEvent(XEvent xev) {
        super.handleExposeEvent(xev);
        XExposeEvent xe = xev.get_xexpose();
        if (this.isEventDisabled(xev)) {
            return;
        }
        int x = xe.get_x();
        int y = xe.get_y();
        int w = xe.get_width();
        int h = xe.get_height();
        Component target = this.getEventSource();
        if (!ComponentAccessor.getIgnoreRepaint(target) && ComponentAccessor.getWidth(target) != 0 && ComponentAccessor.getHeight(target) != 0) {
            this.handleExposeEvent(target, x, y, w, h);
        }
    }

    public void handleExposeEvent(Component target, int x, int y, int w, int h) {
        PaintEvent event = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent(target, x, y, w, h);
        if (event != null) {
            this.postEventToEventQueue(event);
        }
    }

    static int getModifiers(int state, int button, int keyCode) {
        int modifiers = 0;
        if ((state & 1) != 0 ^ keyCode == 16) {
            modifiers |= 0x40;
        }
        if ((state & 4) != 0 ^ keyCode == 17) {
            modifiers |= 0x80;
        }
        if ((state & XToolkit.metaMask) != 0 ^ keyCode == 157) {
            modifiers |= 0x100;
        }
        if ((state & XToolkit.altMask) != 0 ^ keyCode == 18) {
            modifiers |= 0x200;
        }
        if ((state & XToolkit.modeSwitchMask) != 0 ^ keyCode == 65406) {
            modifiers |= 0x2000;
        }
        if ((state & 0x100) != 0 ^ button == 1) {
            modifiers |= 0x400;
        }
        if ((state & 0x200) != 0 ^ button == 2) {
            modifiers |= 0x800;
        }
        if ((state & 0x400) != 0 ^ button == 3) {
            modifiers |= 0x1000;
        }
        return modifiers;
    }

    static int getXModifiers(AWTKeyStroke stroke) {
        int mods = stroke.getModifiers();
        int res = 0;
        if ((mods & 0x41) != 0) {
            res |= 1;
        }
        if ((mods & 0x82) != 0) {
            res |= 4;
        }
        if ((mods & 0x208) != 0) {
            res |= XToolkit.altMask;
        }
        if ((mods & 0x104) != 0) {
            res |= XToolkit.metaMask;
        }
        if ((mods & 0x2020) != 0) {
            res |= XToolkit.modeSwitchMask;
        }
        return res;
    }

    private static int getButtonMask(long mouseButton) {
        if (mouseButton == 1L) {
            return 256;
        }
        if (mouseButton == 2L) {
            return 512;
        }
        if (mouseButton == 3L) {
            return 1024;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRightButtonNumber() {
        if (rbutton == 0) {
            XToolkit.awtLock();
            try {
                rbutton = XlibWrapper.XGetPointerMapping(XToolkit.getDisplay(), XlibWrapper.ibuffer, 3);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return rbutton;
    }

    static int getMouseMovementSmudge() {
        return 4;
    }

    public void handleButtonPressRelease(XEvent xev) {
        super.handleButtonPressRelease(xev);
        XButtonEvent xbe = xev.get_xbutton();
        if (this.isEventDisabled(xev)) {
            return;
        }
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xbe.toString());
        }
        boolean popupTrigger = false;
        int button = 0;
        boolean wheel_mouse = false;
        long lbutton = xbe.get_button();
        int type = xev.get_type();
        long when = xbe.get_time();
        long jWhen = XToolkit.nowMillisUTC_offset(when);
        int x = xbe.get_x();
        int y = xbe.get_y();
        if (xev.get_xany().get_window() != this.window) {
            Point localXY = this.toLocal(xbe.get_x_root(), xbe.get_y_root());
            x = localXY.x;
            y = localXY.y;
        }
        if (type == 4) {
            XWindow lastWindow;
            XWindow xWindow = lastWindow = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
            if (eventLog.isLoggable(Level.FINEST)) {
                eventLog.finest("lastWindow = " + lastWindow + ", lastButton " + lastButton + ", lastTime " + lastTime + ", multiClickTime " + XToolkit.getMultiClickTime());
            }
            if (lastWindow == this && lastButton == lbutton && when - lastTime < (long)XToolkit.getMultiClickTime()) {
                ++clickCount;
            } else {
                clickCount = 1;
                lastWindowRef = new WeakReference<XWindow>(this);
                lastButton = lbutton;
                lastX = x;
                lastY = y;
            }
            lastTime = when;
            popupTrigger = lbutton == (long)XWindow.getRightButtonNumber() || lbutton > 2L;
        }
        if (lbutton == 1L) {
            button = 1;
        } else if (lbutton == 2L) {
            button = 2;
        } else if (lbutton == 3L) {
            button = 3;
        } else if (lbutton == 4L) {
            button = 4;
            wheel_mouse = true;
        } else if (lbutton == 5L) {
            button = 5;
            wheel_mouse = true;
        }
        int modifiers = XWindow.getModifiers(xbe.get_state(), button, 0);
        if (!wheel_mouse) {
            MouseEvent me = new MouseEvent(this.getEventSource(), type == 4 ? 501 : 502, jWhen, modifiers, x, y, xbe.get_x_root(), xbe.get_y_root(), clickCount, popupTrigger, button);
            this.postEventToEventQueue(me);
            if ((this.mouseDragState & XWindow.getButtonMask(lbutton)) == 0 && type == 5) {
                me = new MouseEvent(this.getEventSource(), 500, jWhen, modifiers, x, y, xbe.get_x_root(), xbe.get_y_root(), clickCount, false, button);
                this.postEventToEventQueue(me);
            }
        } else if (xev.get_type() == 4) {
            MouseWheelEvent mwe = new MouseWheelEvent(this.getEventSource(), 507, jWhen, modifiers, x, y, xbe.get_x_root(), xbe.get_y_root(), clickCount, false, 0, 3, button == 4 ? -1 : 1);
            this.postEventToEventQueue(mwe);
        }
        this.mouseDragState &= ~XWindow.getButtonMask(lbutton);
    }

    public void handleMotionNotify(XEvent xev) {
        XWindow lastWindow;
        super.handleMotionNotify(xev);
        XMotionEvent xme = xev.get_xmotion();
        if (this.isEventDisabled(xev)) {
            return;
        }
        int mouseKeyState = xme.get_state() & 0x700;
        boolean isDragging = mouseKeyState != 0;
        int mouseEventType = 0;
        mouseEventType = isDragging ? 506 : 503;
        int x = xme.get_x();
        int y = xme.get_y();
        XWindow xWindow = lastWindow = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
        if (lastWindow != this || xme.get_time() - lastTime >= (long)XToolkit.getMultiClickTime() || Math.abs(lastX - x) >= 4 || Math.abs(lastY - y) >= 4) {
            clickCount = 0;
            lastWindowRef = null;
            this.mouseDragState = mouseKeyState;
            lastTime = 0L;
            lastX = 0;
            lastY = 0;
        }
        long jWhen = XToolkit.nowMillisUTC_offset(xme.get_time());
        int modifiers = XWindow.getModifiers(xme.get_state(), 0, 0);
        boolean popupTrigger = false;
        Component source = this.getEventSource();
        if (xme.get_window() != this.window) {
            Point localXY = this.toLocal(xme.get_x_root(), xme.get_y_root());
            x = localXY.x;
            y = localXY.y;
        }
        if (isDragging && clickCount == 0 || !isDragging) {
            MouseEvent mme = new MouseEvent(source, mouseEventType, jWhen, modifiers, x, y, xme.get_x_root(), xme.get_y_root(), clickCount, popupTrigger, 0);
            this.postEventToEventQueue(mme);
        }
    }

    public native boolean x11inputMethodLookupString(long var1, long[] var3);

    native boolean haveCurrentX11InputMethodInstance();

    public void handleXCrossingEvent(XEvent xev) {
        MouseEvent me;
        XBaseWindow child;
        XWindowPeer toplevel;
        super.handleXCrossingEvent(xev);
        XCrossingEvent xce = xev.get_xcrossing();
        if (eventLog.isLoggable(Level.FINEST)) {
            eventLog.finest(xce.toString());
        }
        if ((toplevel = this.getToplevelXWindow()) != null && !toplevel.isModalBlocked() && xce.get_mode() != 0) {
            if (xce.get_type() == 7) {
                XAwtState.setComponentMouseEntered(this.getEventSource());
                XGlobalCursorManager.nativeUpdateCursor(this.getEventSource());
            } else {
                XAwtState.setComponentMouseEntered(null);
            }
            return;
        }
        long childWnd = xce.get_subwindow();
        if (childWnd != 0L && (child = XToolkit.windowToXWindow(childWnd)) != null && child instanceof XWindow && !child.isEventDisabled(xev)) {
            return;
        }
        Component compWithMouse = XAwtState.getComponentMouseEntered();
        if (toplevel != null) {
            if (!toplevel.isModalBlocked()) {
                if (xce.get_type() == 7) {
                    XAwtState.setComponentMouseEntered(this.getEventSource());
                    XGlobalCursorManager.nativeUpdateCursor(this.getEventSource());
                } else {
                    XAwtState.setComponentMouseEntered(null);
                }
            } else {
                ((XComponentPeer)ComponentAccessor.getPeer(this.target)).pSetCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        long jWhen = XToolkit.nowMillisUTC_offset(xce.get_time());
        int modifiers = XWindow.getModifiers(xce.get_state(), 0, 0);
        int clickCount = 0;
        boolean popupTrigger = false;
        int x = xce.get_x();
        int y = xce.get_y();
        if (xce.get_window() != this.window) {
            Point localXY = this.toLocal(xce.get_x_root(), xce.get_y_root());
            x = localXY.x;
            y = localXY.y;
        }
        if (compWithMouse != null) {
            me = new MouseEvent(compWithMouse, 505, jWhen, modifiers, xce.get_x(), xce.get_y(), xce.get_x_root(), xce.get_y_root(), clickCount, popupTrigger, 0);
            this.postEventToEventQueue(me);
            eventLog.finest("Clearing last window ref");
            lastWindowRef = null;
        }
        if (xce.get_type() == 7) {
            me = new MouseEvent(this.getEventSource(), 504, jWhen, modifiers, xce.get_x(), xce.get_y(), xce.get_x_root(), xce.get_y_root(), clickCount, popupTrigger, 0);
            this.postEventToEventQueue(me);
        }
    }

    public void doLayout(int x, int y, int width, int height) {
    }

    public void handleConfigureNotifyEvent(XEvent xev) {
        Rectangle oldBounds = this.getBounds();
        super.handleConfigureNotifyEvent(xev);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.log(Level.FINER, "Configure, {0}, event disabled: {1}", new Object[]{String.valueOf(xev), this.isEventDisabled(xev)});
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        long eventWindow = xev.get_xany().get_window();
        Rectangle bounds = this.getBounds();
        if (!bounds.getSize().equals(oldBounds.getSize())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
        }
        if (!bounds.getLocation().equals(oldBounds.getLocation())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
        }
    }

    public void handleMapNotifyEvent(XEvent xev) {
        super.handleMapNotifyEvent(xev);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Mapped {0}", new Object[]{String.valueOf(this)});
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        ComponentEvent ce = new ComponentEvent(this.getEventSource(), 102);
        this.postEventToEventQueue(ce);
    }

    public void handleUnmapNotifyEvent(XEvent xev) {
        super.handleUnmapNotifyEvent(xev);
        if (this.isEventDisabled(xev)) {
            return;
        }
        ComponentEvent ce = new ComponentEvent(this.target, 103);
        this.postEventToEventQueue(ce);
    }

    private void dumpKeysymArray(XKeyEvent ev) {
        keyEventLog.fine("  " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), ev.get_keycode(), 0)) + "\n        " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), ev.get_keycode(), 1)) + "\n        " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), ev.get_keycode(), 2)) + "\n        " + Long.toHexString(XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), ev.get_keycode(), 3)));
    }

    char keysymToUnicode(long keysym, int state) {
        return XKeysym.convertKeysym(keysym, state);
    }

    int keyEventType2Id(int xEventType) {
        return xEventType == 2 ? 401 : (xEventType == 3 ? 402 : 0);
    }

    private static long xkeycodeToKeysym(XKeyEvent ev) {
        return XKeysym.getKeysym(ev);
    }

    void logIncomingKeyEvent(XKeyEvent ev) {
        keyEventLog.fine("--XWindow.java:handleKeyEvent:" + ev);
        this.dumpKeysymArray(ev);
        keyEventLog.fine("XXXXXXXXXXXXXX javakeycode will be most probably:0x" + Integer.toHexString(XKeysym.getJavaKeycodeOnly(ev)));
    }

    public void handleKeyPress(XEvent xev) {
        super.handleKeyPress(xev);
        XKeyEvent ev = xev.get_xkey();
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(ev.toString());
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        this.handleKeyPress(ev);
    }

    final void handleKeyPress(XKeyEvent ev) {
        XKeysym.Keysym2JavaKeycode jkc;
        boolean keycode = false;
        long[] keysym = new long[2];
        char unicodeKey = '\u0000';
        keysym[0] = 0L;
        if (keyEventLog.isLoggable(Level.FINE)) {
            this.logIncomingKeyEvent(ev);
        }
        if (this.haveCurrentX11InputMethodInstance()) {
            if (this.x11inputMethodLookupString(ev.pData, keysym)) {
                if (keyEventLog.isLoggable(Level.FINE)) {
                    keyEventLog.fine("--XWindow.java XIM did process event; return; dec keysym processed:" + keysym[0] + "; hex keysym processed:" + Long.toHexString(keysym[0]));
                }
                return;
            }
            unicodeKey = this.keysymToUnicode(keysym[0], ev.get_state());
            if (keyEventLog.isLoggable(Level.FINE)) {
                keyEventLog.fine("--XWindow.java XIM did NOT process event, hex keysym:" + Long.toHexString(keysym[0]) + "\n" + "                                         unicode key:" + Integer.toHexString(unicodeKey));
            }
        } else {
            keysym[0] = XWindow.xkeycodeToKeysym(ev);
            unicodeKey = this.keysymToUnicode(keysym[0], ev.get_state());
            if (keyEventLog.isLoggable(Level.FINE)) {
                keyEventLog.fine("--XWindow.java XIM is absent;             hex keysym:" + Long.toHexString(keysym[0]) + "\n" + "                                         unicode key:" + Integer.toHexString(unicodeKey));
            }
        }
        if ((jkc = XKeysym.getJavaKeycode(ev)) == null) {
            jkc = new XKeysym.Keysym2JavaKeycode(0, 0);
        }
        if (keyEventLog.isLoggable(Level.FINE)) {
            keyEventLog.fine(">>>Fire Event:" + (ev.get_type() == 2 ? "KEY_PRESSED; " : "KEY_RELEASED; ") + "jkeycode:decimal=" + jkc.getJavaKeycode() + ", hex=0x" + Integer.toHexString(jkc.getJavaKeycode()) + "; ");
        }
        this.postKeyEvent(401, ev.get_time(), jkc.getJavaKeycode(), unicodeKey == '\u0000' ? (char)'\uffff' : (char)unicodeKey, jkc.getKeyLocation(), ev.get_state(), ev.getPData(), XKeyEvent.getSize());
        if (unicodeKey > '\u0000') {
            keyEventLog.fine("fire _TYPED on " + unicodeKey);
            this.postKeyEvent(400, ev.get_time(), 0, unicodeKey, 0, ev.get_state(), ev.getPData(), XKeyEvent.getSize());
        }
    }

    public void handleKeyRelease(XEvent xev) {
        super.handleKeyRelease(xev);
        XKeyEvent ev = xev.get_xkey();
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(ev.toString());
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        this.handleKeyRelease(ev);
    }

    private void handleKeyRelease(XKeyEvent ev) {
        XKeysym.Keysym2JavaKeycode jkc;
        boolean keycode = false;
        long[] keysym = new long[2];
        char unicodeKey = '\u0000';
        keysym[0] = 0L;
        if (keyEventLog.isLoggable(Level.FINE)) {
            this.logIncomingKeyEvent(ev);
        }
        if ((jkc = XKeysym.getJavaKeycode(ev)) == null) {
            jkc = new XKeysym.Keysym2JavaKeycode(0, 0);
        }
        if (keyEventLog.isLoggable(Level.FINE)) {
            keyEventLog.fine(">>>Fire Event:" + (ev.get_type() == 2 ? "KEY_PRESSED; " : "KEY_RELEASED; ") + "jkeycode:decimal=" + jkc.getJavaKeycode() + ", hex=0x" + Integer.toHexString(jkc.getJavaKeycode()) + "; ");
        }
        unicodeKey = this.keysymToUnicode(XWindow.xkeycodeToKeysym(ev), ev.get_state());
        this.postKeyEvent(402, ev.get_time(), jkc.getJavaKeycode(), unicodeKey == '\u0000' ? (char)'\uffff' : (char)unicodeKey, jkc.getKeyLocation(), ev.get_state(), ev.getPData(), XKeyEvent.getSize());
    }

    public void reshape(Rectangle bounds) {
        this.reshape(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void reshape(int x, int y, int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.xSetBounds(x, y, width, height);
        this.validateSurface();
        this.layout();
    }

    public void layout() {
    }

    boolean isShowing() {
        return this.visible;
    }

    boolean isResizable() {
        return true;
    }

    boolean isLocationByPlatform() {
        return false;
    }

    void updateSizeHints() {
        this.updateSizeHints(this.x, this.y, this.width, this.height);
    }

    void updateSizeHints(int x, int y, int width, int height) {
        long flags = 8L | (this.isLocationByPlatform() ? 0L : 5L);
        if (!this.isResizable()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Window {0} is not resizable", new Object[]{String.valueOf(this)});
            }
            flags |= 0x30L;
        } else if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Window {0} is resizable", new Object[]{String.valueOf(this)});
        }
        this.setSizeHints(flags, x, y, width, height);
    }

    void updateSizeHints(int x, int y) {
        long flags;
        long l = flags = this.isLocationByPlatform() ? 0L : 5L;
        if (!this.isResizable()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Window {0} is not resizable", new Object[]{String.valueOf(this)});
            }
            flags |= 0x38L;
        } else if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Window {0} is resizable", new Object[]{String.valueOf(this)});
        }
        this.setSizeHints(flags, x, y, this.width, this.height);
    }

    void validateSurface() {
        if (this.width != this.oldWidth || this.height != this.oldHeight) {
            SurfaceData oldData = this.surfaceData;
            if (oldData != null) {
                this.surfaceData = this.graphicsConfig.createSurfaceData(this);
                oldData.invalidate();
            }
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        }
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public void dispose() {
        SurfaceData oldData = this.surfaceData;
        this.surfaceData = null;
        if (oldData != null) {
            oldData.invalidate();
        }
        XToolkit.targetDisposedPeer(this.target, this);
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Point getLocationOnScreen() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            Component comp = this.target;
            while (comp != null && !(comp instanceof Window)) {
                comp = ComponentAccessor.getParent_NoClientCode(comp);
            }
            if (comp == null || comp instanceof EmbeddedFrame) {
                return this.toGlobal(0, 0);
            }
            XToolkit.awtLock();
            try {
                Object wpeer = XToolkit.targetToPeer(comp);
                if (wpeer == null || !(wpeer instanceof XDecoratedPeer) || ((XDecoratedPeer)wpeer).configure_seen) {
                    Point point = this.toGlobal(0, 0);
                    return point;
                }
                Point pt = XWindow.toOtherWindow(this.getContentWindow(), ((XDecoratedPeer)wpeer).getContentWindow(), 0, 0);
                if (pt == null) {
                    pt = new Point(((XBaseWindow)wpeer).getAbsoluteX(), ((XBaseWindow)wpeer).getAbsoluteY());
                }
                pt.x += comp.getX();
                pt.y += comp.getY();
                Point point = pt;
                return point;
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    static void setBData(KeyEvent e, byte[] data) {
        block3: {
            try {
                if (bdata == null) {
                    bdata = SunToolkit.getField(AWTEvent.class, "bdata");
                }
                bdata.set(e, data);
            }
            catch (IllegalAccessException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void postKeyEvent(int id, long when, int keyCode, char keyChar, int keyLocation, int state, long event, int eventSize) {
        long jWhen = XToolkit.nowMillisUTC_offset(when);
        int modifiers = XWindow.getModifiers(state, 0, keyCode);
        KeyEvent ke = new KeyEvent(this.getEventSource(), id, jWhen, modifiers, keyCode, keyChar, keyLocation);
        if (event != 0L) {
            byte[] data = Native.toBytes(event, eventSize);
            XWindow.setBData(ke, data);
        }
        this.postEventToEventQueue(ke);
    }

    static native int getAWTKeyCodeForKeySym(int var0);

    static native int getKeySymForAWTKeyCode(int var0);

    static {
        XWindow.initIDs();
    }
}

